/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.delegates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainRealization;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolverElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.FunctionalChainAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.la.CapabilityRealization;

public class FunctionalChainHelper {
    private static FunctionalChainHelper instance;

    private FunctionalChainHelper() {
    }

    public static FunctionalChainHelper getInstance() {
        if (instance == null) {
            instance = new FunctionalChainHelper();
        }
        return instance;
    }

    public Object doSwitch(FunctionalChain element, EStructuralFeature feature) {
        List<AbstractFunction> ret = null;
        if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__INVOLVED_FUNCTIONAL_CHAIN_INVOLVEMENTS)) {
            ret = this.getInvolvedFunctionalChainInvolvements(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__INVOLVED_ELEMENTS)) {
            ret = this.getInvolvedElements(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__INVOLVED_FUNCTIONAL_EXCHANGES)) {
            ret = this.getInvolvedFunctionalExchanges(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__INVOLVED_FUNCTIONS)) {
            ret = this.getInvolvedFunctions(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__ENACTED_FUNCTIONS)) {
            ret = this.getEnactedFunctions(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__ENACTED_FUNCTIONAL_BLOCKS)) {
            ret = this.getEnactedFunctionalBlocks(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__FIRST_FUNCTIONAL_CHAIN_INVOLVEMENTS)) {
            ret = this.getFirstFunctionalChainInvolvements(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__INVOLVING_CAPABILITIES)) {
            ret = this.getInvolvingCapabilities(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__INVOLVING_CAPABILITY_REALIZATIONS)) {
            ret = this.getInvolvingCapabilityRealizations(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__REALIZED_FUNCTIONAL_CHAINS)) {
            ret = this.getRealizedFunctionalChains(element);
        } else if (feature.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__REALIZING_FUNCTIONAL_CHAINS)) {
            ret = this.getRealizingFunctionalChains(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        if (ret == null) {
            ret = InvolverElementHelper.getInstance().doSwitch((InvolverElement)element, feature);
        }
        if (ret == null) {
            ret = InvolvedElementHelper.getInstance().doSwitch((InvolvedElement)element, feature);
        }
        return ret;
    }

    protected List<FunctionalChainInvolvement> getInvolvedFunctionalChainInvolvements(FunctionalChain element) {
        return new ArrayList<FunctionalChainInvolvement>((Collection<FunctionalChainInvolvement>)element.getOwnedFunctionalChainInvolvements());
    }

    protected List<InvolvedElement> getInvolvedElements(FunctionalChain element) {
        ArrayList<InvolvedElement> ret = new ArrayList<InvolvedElement>();
        for (FunctionalChainInvolvement involvement : this.getInvolvedFunctionalChainInvolvements(element)) {
            InvolvedElement elt = involvement.getInvolved();
            if (elt == null) continue;
            ret.add(elt);
        }
        return ret;
    }

    protected List<FunctionalExchange> getInvolvedFunctionalExchanges(FunctionalChain element) {
        ArrayList<FunctionalExchange> ret = new ArrayList<FunctionalExchange>();
        for (InvolvedElement involvedElement : this.getInvolvedElements(element)) {
            if (!(involvedElement instanceof FunctionalExchange)) continue;
            ret.add((FunctionalExchange)involvedElement);
        }
        return ret;
    }

    protected List<AbstractFunction> getInvolvedFunctions(FunctionalChain element) {
        ArrayList<AbstractFunction> ret = new ArrayList<AbstractFunction>();
        for (InvolvedElement involvedElement : this.getInvolvedElements(element)) {
            if (!(involvedElement instanceof AbstractFunction)) continue;
            ret.add((AbstractFunction)involvedElement);
        }
        return ret;
    }

    protected List<AbstractFunction> getEnactedFunctions(FunctionalChain element) {
        return this.getInvolvedFunctions(element);
    }

    protected List<AbstractFunctionalBlock> getEnactedFunctionalBlocks(FunctionalChain element) {
        ArrayList<AbstractFunctionalBlock> ret = new ArrayList<AbstractFunctionalBlock>();
        for (AbstractFunction func : this.getEnactedFunctions(element)) {
            ret.addAll((Collection<AbstractFunctionalBlock>)func.getAllocationBlocks());
        }
        return ret;
    }

    protected List<FunctionalChainInvolvement> getFirstFunctionalChainInvolvements(FunctionalChain element) {
        ArrayList<FunctionalChainInvolvement> ret = new ArrayList<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement inv : element.getOwnedFunctionalChainInvolvements()) {
            if (inv.getInvolved() == null || !inv.getPreviousFunctionalChainInvolvements().isEmpty()) continue;
            ret.add(inv);
        }
        return ret;
    }

    protected List<Capability> getInvolvingCapabilities(FunctionalChain element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (Involvement inv : element.getInvolvingInvolvements()) {
            AbstractCapability cap;
            if (!(inv instanceof FunctionalChainAbstractCapabilityInvolvement) || !((cap = ((FunctionalChainAbstractCapabilityInvolvement)inv).getCapability()) instanceof Capability)) continue;
            ret.add((Capability)cap);
        }
        return ret;
    }

    protected List<CapabilityRealization> getInvolvingCapabilityRealizations(FunctionalChain element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (Involvement inv : element.getInvolvingInvolvements()) {
            AbstractCapability cap;
            if (!(inv instanceof FunctionalChainAbstractCapabilityInvolvement) || !((cap = ((FunctionalChainAbstractCapabilityInvolvement)inv).getCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)cap);
        }
        return ret;
    }

    protected List<FunctionalChain> getRealizedFunctionalChains(FunctionalChain element) {
        ArrayList<FunctionalChain> ret = new ArrayList<FunctionalChain>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            if (!(trace instanceof FunctionalChainRealization)) continue;
            ret.add((FunctionalChain)trace.getTargetElement());
        }
        return ret;
    }

    protected List<FunctionalChain> getRealizingFunctionalChains(FunctionalChain element) {
        ArrayList<FunctionalChain> ret = new ArrayList<FunctionalChain>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            if (!(trace instanceof FunctionalChainRealization)) continue;
            ret.add((FunctionalChain)trace.getSourceElement());
        }
        return ret;
    }
}

