/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeMechanismExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;

public class CommunicationLinkExt {
    public static void changeExchangeItemMechanism(CommunicationLink link, ExchangeMechanism mechanism) {
        boolean isSender = CommunicationLinkExt.isSender(link);
        link.setProtocol(ExchangeMechanismExt.getProtocol(mechanism, isSender));
        link.setKind(ExchangeMechanismExt.getKind(mechanism, isSender));
    }

    public static void changeExchangeItem(CommunicationLink link, ExchangeItem newEI) {
        link.setExchangeItem(newEI);
        CommunicationLinkExt.changeExchangeItemMechanism(link, newEI.getExchangeMechanism());
    }

    public static Collection<CommunicationLink> getAllCommunicationLinks(CommunicationLinkExchanger sndCpnt) {
        HashSet<CommunicationLink> result = new HashSet<CommunicationLink>();
        Collection<Object> components = null;
        if (sndCpnt instanceof GeneralizableElement) {
            components = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)sndCpnt);
            components.add((GeneralizableElement)sndCpnt);
        } else {
            components = Collections.singleton(sndCpnt);
        }
        for (NamedElement namedElement : components) {
            if (namedElement == null || !(namedElement instanceof CommunicationLinkExchanger)) continue;
            CommunicationLinkExchanger sndCompo = (CommunicationLinkExchanger)namedElement;
            result.addAll((Collection<CommunicationLink>)sndCompo.getOwnedCommunicationLinks());
        }
        return result;
    }

    public static Collection<CommunicationLink> filterByKind(Collection<CommunicationLink> links, CommunicationLinkKind kind) {
        HashSet<CommunicationLink> result = new HashSet<CommunicationLink>();
        for (CommunicationLink snd : links) {
            if (snd == null || snd.getKind() != kind) continue;
            result.add(snd);
        }
        return result;
    }

    public static Collection<AbstractExchangeItem> getExchangeItems(Collection<CommunicationLink> links) {
        HashSet<AbstractExchangeItem> result = new HashSet<AbstractExchangeItem>();
        for (CommunicationLink snd : links) {
            if (snd == null || snd.getExchangeItem() == null) continue;
            result.add((AbstractExchangeItem)snd.getExchangeItem());
        }
        return result;
    }

    public static Collection<AbstractExchangeItem> getExchangeItemsByKinds(Collection<CommunicationLink> links, CommunicationLinkKind[] kinds) {
        HashSet<AbstractExchangeItem> result = new HashSet<AbstractExchangeItem>();
        HashSet<CommunicationLinkKind> kinds_set = new HashSet<CommunicationLinkKind>();
        CommunicationLinkKind[] communicationLinkKindArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            CommunicationLinkKind kind = communicationLinkKindArray[n2];
            kinds_set.add(kind);
            ++n2;
        }
        for (CommunicationLink snd : links) {
            if (snd == null || !kinds_set.contains(snd.getKind())) continue;
            result.add((AbstractExchangeItem)snd.getExchangeItem());
        }
        return result;
    }

    public static Collection<AbstractExchangeItem> getExchangeItemsByKind(Collection<CommunicationLink> links, CommunicationLinkKind kind) {
        HashSet<AbstractExchangeItem> result = new HashSet<AbstractExchangeItem>();
        for (CommunicationLink snd : links) {
            if (snd == null || !kind.equals((Object)snd.getKind())) continue;
            result.add((AbstractExchangeItem)snd.getExchangeItem());
        }
        return result;
    }

    public static Component getSource(CommunicationLink link) {
        return (Component)link.eContainer();
    }

    public static AbstractExchangeItem getExchangeItemsByKind(CommunicationLink link, CommunicationLinkKind kind) {
        if (link != null && kind.equals((Object)link.getKind())) {
            return link.getExchangeItem();
        }
        return null;
    }

    public static boolean isSender(CommunicationLink link) {
        return link.getKind() == CommunicationLinkKind.PRODUCE || link.getKind() == CommunicationLinkKind.SEND || link.getKind() == CommunicationLinkKind.CALL || link.getKind() == CommunicationLinkKind.WRITE || link.getKind() == CommunicationLinkKind.TRANSMIT;
    }

    public static boolean isReceiver(CommunicationLink link) {
        return link.getKind() == CommunicationLinkKind.RECEIVE || link.getKind() == CommunicationLinkKind.CONSUME || link.getKind() == CommunicationLinkKind.EXECUTE || link.getKind() == CommunicationLinkKind.ACCESS || link.getKind() == CommunicationLinkKind.ACQUIRE;
    }

    public static List<CommunicationLink> getSenderCommunicationLink(Component component) {
        ArrayList<CommunicationLink> senderLinks = new ArrayList<CommunicationLink>();
        for (CommunicationLink link : component.getOwnedCommunicationLinks()) {
            if (!CommunicationLinkExt.isSender(link)) continue;
            senderLinks.add(link);
        }
        return senderLinks;
    }

    public static List<CommunicationLink> getAllSenderCommunicationLink(Component component) {
        ArrayList<CommunicationLink> senderLinks = new ArrayList<CommunicationLink>();
        List<GeneralizableElement> components = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)component);
        components.add((GeneralizableElement)component);
        for (GeneralizableElement ge : components) {
            if (!(ge instanceof Component)) continue;
            for (CommunicationLink link : ((Component)ge).getOwnedCommunicationLinks()) {
                if (!CommunicationLinkExt.isSender(link)) continue;
                senderLinks.add(link);
            }
        }
        return senderLinks;
    }

    public static List<CommunicationLink> getReceiverCommunicationLink(Component component) {
        ArrayList<CommunicationLink> receiverLinks = new ArrayList<CommunicationLink>();
        for (CommunicationLink link : component.getOwnedCommunicationLinks()) {
            if (!CommunicationLinkExt.isReceiver(link)) continue;
            receiverLinks.add(link);
        }
        return receiverLinks;
    }

    public static List<CommunicationLink> getAllReceiverCommunicationLink(Component component) {
        ArrayList<CommunicationLink> receiverLinks = new ArrayList<CommunicationLink>();
        List<GeneralizableElement> components = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)component);
        components.add((GeneralizableElement)component);
        for (GeneralizableElement ge : components) {
            if (!(ge instanceof Component)) continue;
            for (CommunicationLink link : ((Component)ge).getOwnedCommunicationLinks()) {
                if (!CommunicationLinkExt.isReceiver(link)) continue;
                receiverLinks.add(link);
            }
        }
        return receiverLinks;
    }

    public static boolean isSameCommunication(CommunicationLink link1, CommunicationLink link2) {
        return link1.getExchangeItem() == link2.getExchangeItem() && link1.getProtocol() == link2.getProtocol() && link1.getKind() == link2.getKind();
    }
}

