/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.interaction.delegates;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.SequenceMessage;

public class SequenceMessageHelper {
    private static SequenceMessageHelper instance;

    private SequenceMessageHelper() {
    }

    public static SequenceMessageHelper getInstance() {
        if (instance == null) {
            instance = new SequenceMessageHelper();
        }
        return instance;
    }

    public Object doSwitch(SequenceMessage element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(InteractionPackage.Literals.SEQUENCE_MESSAGE__INVOKED_OPERATION)) {
            ret = this.getInvokedOperation(element);
        } else if (feature.equals(InteractionPackage.Literals.SEQUENCE_MESSAGE__SENDING_PART)) {
            ret = this.getSendingPart(element);
        } else if (feature.equals(InteractionPackage.Literals.SEQUENCE_MESSAGE__RECEIVING_PART)) {
            ret = this.getReceivingPart(element);
        } else if (feature.equals(InteractionPackage.Literals.SEQUENCE_MESSAGE__SENDING_FUNCTION)) {
            ret = this.getSendingFunction(element);
        } else if (feature.equals(InteractionPackage.Literals.SEQUENCE_MESSAGE__RECEIVING_FUNCTION)) {
            ret = this.getReceivingFunction(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        return ret;
    }

    protected AbstractEventOperation getInvokedOperation(SequenceMessage element) {
        if (element != null) {
            Event evt;
            Event evt2;
            MessageEnd receiver = element.getReceivingEnd();
            if (receiver != null && (evt2 = receiver.getEvent()) instanceof EventReceiptOperation) {
                return ((EventReceiptOperation)evt2).getOperation();
            }
            MessageEnd sender = element.getSendingEnd();
            if (sender != null && (evt = sender.getEvent()) instanceof EventSentOperation) {
                return ((EventSentOperation)evt).getOperation();
            }
        }
        return null;
    }

    protected Part getSendingPart(SequenceMessage element) {
        AbstractInstance inst;
        InstanceRole role;
        MessageEnd sender = element.getSendingEnd();
        if (sender != null && (role = sender.getCovered()) != null && (inst = role.getRepresentedInstance()) instanceof Part) {
            return (Part)inst;
        }
        return null;
    }

    protected Part getReceivingPart(SequenceMessage element) {
        AbstractInstance inst;
        InstanceRole role;
        MessageEnd sender = element.getReceivingEnd();
        if (sender != null && (role = sender.getCovered()) != null && (inst = role.getRepresentedInstance()) instanceof Part) {
            return (Part)inst;
        }
        return null;
    }

    protected AbstractFunction getSendingFunction(SequenceMessage element) {
        AbstractInstance inst;
        InstanceRole role;
        MessageEnd sender = element.getSendingEnd();
        if (sender != null && (role = sender.getCovered()) != null && (inst = role.getRepresentedInstance()) instanceof AbstractFunction) {
            return (AbstractFunction)inst;
        }
        return null;
    }

    protected AbstractFunction getReceivingFunction(SequenceMessage element) {
        AbstractInstance inst;
        InstanceRole role;
        MessageEnd sender = element.getReceivingEnd();
        if (sender != null && (role = sender.getCovered()) != null && (inst = role.getRepresentedInstance()) instanceof AbstractFunction) {
            return (AbstractFunction)inst;
        }
        return null;
    }
}

