/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.la.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.cs.SystemComponentCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.helpers.interaction.delegates.AbstractCapabilityHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;

public class CapabilityRealizationHelper {
    private static CapabilityRealizationHelper instance;

    private CapabilityRealizationHelper() {
    }

    public static CapabilityRealizationHelper getInstance() {
        if (instance == null) {
            instance = new CapabilityRealizationHelper();
        }
        return instance;
    }

    public Object doSwitch(CapabilityRealization element, EStructuralFeature feature) {
        List<SystemComponent> ret = null;
        if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__INVOLVED_SYSTEM_COMPONENTS)) {
            ret = this.getInvolvedSystemComponents(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__INVOLVED_ACTORS)) {
            ret = this.getInvolvedActors(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__PARTICIPATING_SYSTEM_COMPONENTS)) {
            ret = this.getParticitpatingSystemComponents(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__PARTICIPATING_ACTORS)) {
            ret = this.getParticitpatingActors(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZED_CAPABILITIES)) {
            ret = this.getRealizedCapabilities(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZED_CAPABILITY_REALIZATIONS)) {
            ret = this.getRealizedCapabilityRealizations(element);
        } else if (feature.equals(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZING_CAPABILITY_REALIZATIONS)) {
            ret = this.getRealizingCapabilityRealizations(element);
        }
        if (ret == null) {
            ret = AbstractCapabilityHelper.getInstance().doSwitch((AbstractCapability)element, feature);
        }
        return ret;
    }

    protected List<SystemComponentCapabilityRealizationInvolvement> getInvolvedSystemComponents(CapabilityRealization element) {
        ArrayList<SystemComponentCapabilityRealizationInvolvement> ret = new ArrayList<SystemComponentCapabilityRealizationInvolvement>();
        for (Involvement involvement : element.getInvolvedInvolvements()) {
            if (!(involvement instanceof SystemComponentCapabilityRealizationInvolvement)) continue;
            ret.add((SystemComponentCapabilityRealizationInvolvement)involvement);
        }
        return ret;
    }

    protected List<ActorCapabilityRealizationInvolvement> getInvolvedActors(CapabilityRealization element) {
        ArrayList<ActorCapabilityRealizationInvolvement> ret = new ArrayList<ActorCapabilityRealizationInvolvement>();
        for (Involvement involvement : element.getInvolvedInvolvements()) {
            if (!(involvement instanceof ActorCapabilityRealizationInvolvement)) continue;
            ret.add((ActorCapabilityRealizationInvolvement)involvement);
        }
        return ret;
    }

    protected List<SystemComponent> getParticitpatingSystemComponents(CapabilityRealization element) {
        ArrayList<SystemComponent> ret = new ArrayList<SystemComponent>();
        for (SystemComponentCapabilityRealizationInvolvement involvement : element.getInvolvedSystemComponents()) {
            InvolvedElement comp = involvement.getInvolved();
            if (comp == null || !(comp instanceof SystemComponent)) continue;
            ret.add((SystemComponent)comp);
        }
        return ret;
    }

    protected List<AbstractActor> getParticitpatingActors(CapabilityRealization element) {
        ArrayList<AbstractActor> ret = new ArrayList<AbstractActor>();
        for (ActorCapabilityRealizationInvolvement involvement : element.getInvolvedActors()) {
            InvolvedElement comp = involvement.getInvolved();
            if (comp == null || !(comp instanceof AbstractActor)) continue;
            ret.add((AbstractActor)comp);
        }
        return ret;
    }

    protected List<Capability> getRealizedCapabilities(CapabilityRealization element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizedCapability()) instanceof Capability)) continue;
            ret.add((Capability)capability);
        }
        return ret;
    }

    protected List<CapabilityRealization> getRealizedCapabilityRealizations(CapabilityRealization element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizedCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)capability);
        }
        return ret;
    }

    protected List<CapabilityRealization> getRealizingCapabilityRealizations(CapabilityRealization element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizingCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)capability);
        }
        return ret;
    }
}

