/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.oa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.cs.delegates.BlockArchitectureHelper;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;

public class OpAnalysisHelper {
    private static OpAnalysisHelper instance;

    private OpAnalysisHelper() {
    }

    public static OpAnalysisHelper getInstance() {
        if (instance == null) {
            instance = new OpAnalysisHelper();
        }
        return instance;
    }

    public Object doSwitch(OperationalAnalysis element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(OaPackage.Literals.OPERATIONAL_ANALYSIS__CONTAINED_OPERATIONAL_CAPABILITY_PKG)) {
            ret = this.getContainedOperationalCapabilityPkg(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ANALYSIS__CONTAINED_OPERATIONAL_ACTIVITY_PKG)) {
            ret = this.getContainedOperationalActivityPkg(element);
        } else if (feature.equals(OaPackage.Literals.OPERATIONAL_ANALYSIS__ALLOCATING_SYSTEM_ANALYSES)) {
            ret = this.getAllocatingSystemAnalyses(element);
        }
        if (ret == null) {
            ret = BlockArchitectureHelper.getInstance().doSwitch((BlockArchitecture)element, feature);
        }
        return ret;
    }

    protected OperationalCapabilityPkg getContainedOperationalCapabilityPkg(OperationalAnalysis element) {
        AbstractCapabilityPkg abstractCapabilityPkg = element.getOwnedAbstractCapabilityPkg();
        if (abstractCapabilityPkg instanceof OperationalCapabilityPkg) {
            return (OperationalCapabilityPkg)abstractCapabilityPkg;
        }
        return null;
    }

    protected OperationalActivityPkg getContainedOperationalActivityPkg(OperationalAnalysis element) {
        FunctionPkg functionPkg = element.getOwnedFunctionPkg();
        if (functionPkg instanceof OperationalActivityPkg) {
            return (OperationalActivityPkg)functionPkg;
        }
        return null;
    }

    protected List<SystemAnalysis> getAllocatingSystemAnalyses(OperationalAnalysis element) {
        ArrayList<SystemAnalysis> ret = new ArrayList<SystemAnalysis>();
        for (BlockArchitecture architecture : element.getAllocatingArchitectures()) {
            if (!(architecture instanceof SystemAnalysis)) continue;
            ret.add((SystemAnalysis)architecture);
        }
        return ret;
    }
}

