/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.scenario.ScenarioTransform;
import org.polarsys.capella.core.projection.scenario.fs2es.handlers.ScenarioFS2ESHandler;
import org.polarsys.capella.core.projection.scenario.handlers.IScenarioHandler;
import org.polarsys.capella.core.tiger.ITransfo;

public class FS2ESTransform
extends ScenarioTransform {
    private static final String CAPELLA_SCENARIO_RULES = "org.polarsys.capella.core.projection.scenario.fs2es";

    @Override
    protected String getRules() {
        return CAPELLA_SCENARIO_RULES;
    }

    @Override
    protected IScenarioHandler createScenarioHandler(IContext context_p) {
        return new ScenarioFS2ESHandler();
    }

    protected boolean retainContextElement(EObject contextElement, ITransfo transfo) {
        BlockArchitecture sourceBlock;
        if (contextElement instanceof Scenario && (sourceBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement)) != null) {
            transfo.put((Object)"transfoSource", (Object)contextElement);
            transfo.put((Object)"transfoTarget", (Object)this.getTransitionedScenario((Scenario)contextElement, transfo));
            transfo.put((Object)"transfoTargetContainer", (Object)sourceBlock);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isValidTransitionedScenario(Scenario contextElement_p, Scenario scenario_p) {
        BlockArchitecture sourceBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement_p);
        BlockArchitecture targetBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario_p);
        return (scenario_p.getKind() == ScenarioKind.DATA_FLOW || scenario_p.getKind() == ScenarioKind.INTERACTION && !TransitionHelper.getService().isFunctionalScenario(scenario_p)) && sourceBlock.equals(targetBlock);
    }
}

