/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.AbstractRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;

public class CheckboxRenderer
extends AbstractRenderer {
    Button dataExport;

    @Override
    public void performRender(Composite parent, final IRendererContext rendererContext) {
        final IProperty property = rendererContext.getProperty(this);
        this.dataExport = new Button(parent, 32);
        if (!Boolean.FALSE.equals(rendererContext.getParameter("PARAMETER_RENDER_LABEL"))) {
            this.dataExport.setText(property.getName());
        }
        this.dataExport.setToolTipText(property.getDescription());
        this.dataExport.setData((Object)property);
        this.dataExport.setEnabled(property.isEnabled(rendererContext.getPropertyContext()));
        this.dataExport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean newValue = ((Button)e.widget).getSelection();
                Boolean value = newValue;
                CheckboxRenderer.this.changeValue(property, rendererContext, value);
                CheckboxRenderer.this.updatedValue(property, rendererContext, value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public void initialize(IProperty property, IRendererContext propertyContext) {
        Object value = propertyContext.getPropertyContext().getDefaultValue(property);
        this.updatedValue(property, propertyContext, value);
    }

    @Override
    public void updatedValue(IProperty property, IRendererContext rendererContext, Object newValue) {
        if (this.isDisposed()) {
            return;
        }
        IProperty prop = rendererContext.getProperty(this);
        if (property.equals(prop)) {
            this.dataExport.setSelection(Boolean.valueOf(newValue.toString()).booleanValue());
            this.dataExport.setEnabled(prop.isEnabled(rendererContext.getPropertyContext()));
        }
    }

    @Override
    public void dispose(IRendererContext context) {
        super.dispose(context);
        if (this.dataExport != null) {
            this.dataExport.dispose();
        }
    }
}

