/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.compare;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.ui.sirius.SiriusScopeDefinitionFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.compare.CapellaScope;

public class CapellaScopeFactory
extends SiriusScopeDefinitionFactory {
    protected IModelScopeDefinition createScopeDefinitionFromURI(URI uri, String label, boolean editable) {
        return new CapellaScopeDefinition(uri, label, editable);
    }

    public Collection<? extends Class<?>> getOverridenClasses() {
        return Collections.singleton(SiriusScopeDefinitionFactory.class);
    }

    public static class CapellaScopeDefinition
    extends SiriusScopeDefinitionFactory.SiriusScopeDefinition {
        public CapellaScopeDefinition(URI uri_p, String label_p, boolean editable_p) {
            super(uri_p, label_p, editable_p);
        }

        protected IEditableModelScope createScopeOnEditingDomain(EditingDomain domain) {
            return new CapellaScope(this.getEntrypoint(), domain, !this.isEditable());
        }

        protected IEditableModelScope createScopeOnResourceSet(ResourceSet resourceSet) {
            return new CapellaScope(this.getEntrypoint(), resourceSet, !this.isEditable());
        }

        protected Object getDefaultContext() {
            Object result;
            URI uri = this.getEntrypoint();
            Session session = SessionManager.INSTANCE.getExistingSession(uri);
            if (session != null) {
                result = super.getDefaultContext();
            } else {
                SemanticEditingDomainFactory factory = new SemanticEditingDomainFactory();
                result = factory.createEditingDomain();
            }
            return result;
        }
    }
}

