/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.scenarios.core.datastructures;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.ExtensionPriorityComparator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.helpers.interaction.services.FragmentEndExt;
import org.polarsys.capella.core.data.helpers.interaction.services.MessageEndExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.communication.SignalInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.AbstractFragment;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.CreationEvent;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.ExecutionEvent;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.model.helpers.AbstractFragmentExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.refinement.scenarios.core.Messages;
import org.polarsys.capella.core.refinement.scenarios.core.RefinementServices;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.Node;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.Tree;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IScenarioRepresentationListener;

public class ScenarioRepresentation {
    private static final String REFINEMENT_FRAMEWORK_PLUGIN_ID = "org.polarsys.capella.core.refinement.framework";
    private static final String SCENARIO_REPRESENTATION_LISTENER_EXTENSION_ID = "scenarioRepresentationListenerExtension";
    private Set<CapellaElement> clonedElements = null;
    private List<IScenarioRepresentationListener> listeners = new ArrayList<IScenarioRepresentationListener>();
    private Logger logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
    private Tree<InteractionFragment> messageTree = null;
    private Scenario scenario = null;

    public ScenarioRepresentation(Scenario scenario) {
        if (scenario != null) {
            this.scenario = scenario;
            this.messageTree = new Tree();
            Node<InteractionFragment> rootNode = new Node<InteractionFragment>(null);
            this.messageTree.setRootElement(rootNode);
            ExtensionPriorityComparator priorityComparator = new ExtensionPriorityComparator();
            List<IConfigurationElement> listenerProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)REFINEMENT_FRAMEWORK_PLUGIN_ID, (String)SCENARIO_REPRESENTATION_LISTENER_EXTENSION_ID));
            Collections.sort(listenerProvider, priorityComparator);
            for (IConfigurationElement configurationElement : listenerProvider) {
                String loggedMsg = MessageFormat.format(Messages.NewListenerProvider, configurationElement.getAttribute("id"));
                this.logger.debug((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)scenario));
                IScenarioRepresentationListener listener = (IScenarioRepresentationListener)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                if (listener == null) continue;
                listener.scenarioCreated(this.messageTree);
                this.listeners.add(listener);
            }
            this.fillTree((List<InteractionFragment>)scenario.getOwnedInteractionFragments(), rootNode);
        }
    }

    public void addChildAfter(Node<InteractionFragment> parent, Node<InteractionFragment> child, Node<InteractionFragment> previousNode) {
        parent.addChildAfter(child, previousNode);
        this.updateListeners();
    }

    private void addClonedElement(CapellaElement elt) {
        if (this.clonedElements == null) {
            this.clonedElements = new HashSet<CapellaElement>();
        }
        this.clonedElements.add(elt);
    }

    public void addFirstChild(Node<AbstractEnd> parent, Node<AbstractEnd> child) {
        parent.addFirstChild(child);
        this.updateListeners();
    }

    public void addLastChild(Node<InteractionFragment> parent, Node<InteractionFragment> child) {
        parent.addLastChild(child);
        this.updateListeners();
    }

    public void clean() {
        for (Node<InteractionFragment> node : this.walk()) {
            node.relatedNode = null;
        }
    }

    public void cleanClonedElements() {
        if (this.clonedElements != null) {
            for (CapellaElement elt : this.clonedElements) {
                CapellaElementExt.cleanTraces((CapellaElement)elt);
                elt.destroy();
            }
        }
    }

    private CombinedFragment cloneCombinedFragment(CombinedFragment srcFragment) {
        CombinedFragment tgtFragment = null;
        if (srcFragment != null) {
            if (srcFragment.eContainer().equals(this.scenario)) {
                tgtFragment = srcFragment;
            } else {
                List lst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcFragment, (EClass)InteractionPackage.Literals.COMBINED_FRAGMENT);
                for (CapellaElement elt : lst) {
                    if (!elt.eContainer().equals(this.scenario)) continue;
                    tgtFragment = (CombinedFragment)elt;
                }
                if (tgtFragment == null) {
                    tgtFragment = InteractionFactory.eINSTANCE.createCombinedFragment();
                    tgtFragment.setName(srcFragment.getName());
                    tgtFragment.setOperator(srcFragment.getOperator());
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtFragment, (NamedElement)srcFragment, (Namespace)this.scenario);
                    this.addClonedElement((CapellaElement)tgtFragment);
                }
            }
        }
        return tgtFragment;
    }

    private ExecutionEnd cloneExecutionEnd(ExecutionEnd srcExecEnd) {
        ExecutionEnd tgtExecEnd = null;
        if (srcExecEnd != null) {
            if (srcExecEnd.eContainer().equals(this.scenario)) {
                tgtExecEnd = srcExecEnd;
            } else {
                List lst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcExecEnd, (EClass)InteractionPackage.Literals.EXECUTION_END);
                for (CapellaElement elt : lst) {
                    if (elt.eContainer() == null || !elt.eContainer().equals(this.scenario)) continue;
                    tgtExecEnd = (ExecutionEnd)elt;
                }
                if (tgtExecEnd == null) {
                    tgtExecEnd = InteractionFactory.eINSTANCE.createExecutionEnd();
                    ExecutionEvent execEvt = InteractionFactory.eINSTANCE.createExecutionEvent();
                    tgtExecEnd.setEvent((Event)execEvt);
                    this.scenario.getOwnedEvents().add((Object)execEvt);
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtExecEnd, (NamedElement)srcExecEnd, (Namespace)this.scenario);
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)execEvt, (NamedElement)srcExecEnd.getEvent(), (Namespace)this.scenario);
                }
            }
        }
        return tgtExecEnd;
    }

    private void cloneExecutions(ScenarioRepresentation srcTree) {
        EList srcExecLst = srcTree.getScenario().getOwnedTimeLapses();
        for (TimeLapse srcExec : srcExecLst) {
            Execution tgtExec = null;
            for (CapellaElement exec : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcExec, (EClass)InteractionPackage.Literals.EXECUTION)) {
                if (!exec.eContainer().equals(this.scenario)) continue;
                tgtExec = (Execution)exec;
            }
            if (tgtExec != null) continue;
            AbstractEnd startMsgEnd = null;
            AbstractEnd finishMsgEnd = null;
            for (CapellaElement msgEnd : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcExec.getStart(), (EClass)InteractionPackage.Literals.ABSTRACT_END)) {
                if (!msgEnd.eContainer().equals(this.scenario)) continue;
                startMsgEnd = (AbstractEnd)msgEnd;
            }
            for (CapellaElement msgEnd : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcExec.getFinish(), (EClass)InteractionPackage.Literals.ABSTRACT_END)) {
                if (!msgEnd.eContainer().equals(this.scenario)) continue;
                finishMsgEnd = (AbstractEnd)msgEnd;
            }
            if (startMsgEnd != null && finishMsgEnd != null) {
                tgtExec = InteractionFactory.eINSTANCE.createExecution();
                tgtExec.setStart((InteractionFragment)startMsgEnd);
                tgtExec.setFinish(finishMsgEnd);
                this.scenario.getOwnedTimeLapses().add((Object)tgtExec);
                RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtExec, (NamedElement)srcExec, (Namespace)this.scenario);
                continue;
            }
            if (startMsgEnd != null || !(finishMsgEnd instanceof ExecutionEnd)) continue;
            Event execEvt = finishMsgEnd.getEvent();
            CapellaElementExt.cleanTraces((CapellaElement)execEvt);
            execEvt.destroy();
            CapellaElementExt.cleanTraces((CapellaElement)finishMsgEnd);
            finishMsgEnd.destroy();
        }
    }

    private FragmentEnd cloneFragmentEnd(FragmentEnd srcFragmentEnd, AbstractFragment tgtFragment) {
        FragmentEnd tgtFragmentEnd = null;
        if (srcFragmentEnd != null) {
            if (srcFragmentEnd.eContainer().equals(this.scenario)) {
                tgtFragmentEnd = srcFragmentEnd;
            } else {
                List lst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcFragmentEnd, (EClass)InteractionPackage.Literals.FRAGMENT_END);
                for (CapellaElement elt : lst) {
                    if (elt.eContainer() == null || !elt.eContainer().equals(this.scenario)) continue;
                    tgtFragmentEnd = (FragmentEnd)elt;
                }
                if (tgtFragmentEnd == null) {
                    tgtFragmentEnd = InteractionFactory.eINSTANCE.createFragmentEnd();
                    tgtFragmentEnd.setName(srcFragmentEnd.getName());
                    FragmentEndExt.FRAGMENT_END_TYPE type = FragmentEndExt.getFragmentEndType((FragmentEnd)srcFragmentEnd);
                    switch (type) {
                        case FINISH: {
                            tgtFragment.setFinish((InteractionFragment)tgtFragmentEnd);
                            break;
                        }
                        case START: {
                            tgtFragment.setStart((InteractionFragment)tgtFragmentEnd);
                            break;
                        }
                    }
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtFragmentEnd, (NamedElement)srcFragmentEnd, (Namespace)this.scenario);
                    this.addClonedElement((CapellaElement)tgtFragmentEnd);
                }
            }
        }
        return tgtFragmentEnd;
    }

    private InstanceRole cloneInstanceRole(InstanceRole srcRole, AbstractInstance abstractInstance, NamedElement tgtElement) {
        InstanceRole tgtRole = null;
        if (srcRole != null) {
            if (srcRole.eContainer().equals(this.scenario)) {
                tgtRole = srcRole;
            } else {
                List rolesLst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcRole, (EClass)InteractionPackage.Literals.INSTANCE_ROLE);
                for (CapellaElement role : rolesLst) {
                    InstanceRole instRole = (InstanceRole)role;
                    AbstractInstance cpntInst = instRole.getRepresentedInstance();
                    if (!instRole.eContainer().equals(this.scenario) || abstractInstance != null && !cpntInst.equals(abstractInstance) && !(cpntInst instanceof SignalInstance)) continue;
                    tgtRole = instRole;
                }
                if (tgtRole == null) {
                    for (InstanceRole instRole : this.scenario.getOwnedInstanceRoles()) {
                        AbstractInstance cpntInst = instRole.getRepresentedInstance();
                        if (cpntInst == null || !cpntInst.equals(abstractInstance) || RefinementLinkExt.isLinkedTo((TraceableElement)(tgtRole = instRole), (TraceableElement)srcRole)) continue;
                        RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtRole, (NamedElement)srcRole, (Namespace)this.scenario);
                    }
                }
                if (tgtRole == null && abstractInstance != null) {
                    tgtRole = InteractionFactory.eINSTANCE.createInstanceRole();
                    tgtRole.setRepresentedInstance(abstractInstance);
                    tgtRole.setName(abstractInstance.getName());
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtRole, (NamedElement)srcRole, (Namespace)this.scenario);
                    this.addClonedElement((CapellaElement)tgtRole);
                }
            }
        }
        return tgtRole;
    }

    private List<InstanceRole> cloneInstanceRoles(List<InstanceRole> srcRoles, AbstractInstance abstractInstance, NamedElement tgtElement) {
        ArrayList<InstanceRole> tgtRoles = new ArrayList<InstanceRole>();
        for (InstanceRole srcRole : srcRoles) {
            if (!(tgtElement instanceof Component)) continue;
            for (Partition part : ((Component)tgtElement).getOwnedPartitions()) {
                InstanceRole tgtRole;
                if (!(part instanceof Part) || (tgtRole = this.cloneInstanceRole(srcRole, (AbstractInstance)part, tgtElement)) == null) continue;
                if (!tgtRoles.contains(tgtRole)) {
                    tgtRoles.add(tgtRole);
                }
                if (this.scenario.getOwnedInstanceRoles().contains((Object)tgtRole)) continue;
                this.scenario.getOwnedInstanceRoles().add((Object)tgtRole);
            }
        }
        return tgtRoles;
    }

    private InteractionOperand cloneInteractionOperand(InteractionOperand srcOperand) {
        InteractionOperand tgtOperand = null;
        if (srcOperand != null) {
            if (srcOperand.eContainer().equals(this.scenario)) {
                tgtOperand = srcOperand;
            } else {
                List lst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcOperand, (EClass)InteractionPackage.Literals.INTERACTION_OPERAND);
                for (CapellaElement elt : lst) {
                    if (elt.eContainer() == null || !elt.eContainer().equals(this.scenario)) continue;
                    tgtOperand = (InteractionOperand)elt;
                }
                if (tgtOperand == null) {
                    tgtOperand = InteractionFactory.eINSTANCE.createInteractionOperand();
                    tgtOperand.setName(srcOperand.getName());
                    tgtOperand.setGuard(srcOperand.getGuard());
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtOperand, (NamedElement)srcOperand, (Namespace)this.scenario);
                    this.addClonedElement((CapellaElement)tgtOperand);
                }
            }
        }
        return tgtOperand;
    }

    private InteractionUse cloneInteractionUse(InteractionUse srcUse) {
        InteractionUse tgtUse = null;
        if (srcUse != null) {
            if (srcUse.eContainer().equals(this.scenario)) {
                tgtUse = srcUse;
            } else {
                List lst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcUse, (EClass)InteractionPackage.Literals.INTERACTION_USE);
                for (CapellaElement elt : lst) {
                    if (!elt.eContainer().equals(this.scenario)) continue;
                    tgtUse = (InteractionUse)elt;
                }
                if (tgtUse == null) {
                    tgtUse = InteractionFactory.eINSTANCE.createInteractionUse();
                    tgtUse.setName(srcUse.getName());
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtUse, (NamedElement)srcUse, (Namespace)this.scenario);
                    this.addClonedElement((CapellaElement)tgtUse);
                }
            }
        }
        return tgtUse;
    }

    private MessageEnd cloneMessageEnd(MessageEnd srcMsgEnd, SequenceMessage tgtMsg) {
        MessageEnd tgtMsgEnd = null;
        if (srcMsgEnd != null) {
            if (srcMsgEnd.eContainer().equals(this.scenario)) {
                tgtMsgEnd = srcMsgEnd;
            } else {
                List lst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcMsgEnd, (EClass)InteractionPackage.Literals.MESSAGE_END);
                for (CapellaElement elt : lst) {
                    if (elt.eContainer() == null || !elt.eContainer().equals(this.scenario)) continue;
                    tgtMsgEnd = (MessageEnd)elt;
                }
                if (tgtMsgEnd == null) {
                    tgtMsgEnd = InteractionFactory.eINSTANCE.createMessageEnd();
                    MessageEndExt.COMPONENT_TYPE type = MessageEndExt.getMessageEndType((MessageEnd)srcMsgEnd);
                    switch (type) {
                        case RECEIVER: {
                            tgtMsgEnd.setName(MessageFormat.format(Messages.MessageEndReceiverNamePattern, tgtMsg.getName(), tgtMsg.getKind()));
                            tgtMsg.setReceivingEnd(tgtMsgEnd);
                            EventSentOperation srcEvt = srcMsgEnd.getEvent();
                            if (srcEvt == null) break;
                            if (srcEvt instanceof EventReceiptOperation) {
                                AbstractEventOperation op = ((EventReceiptOperation)srcEvt).getOperation();
                                AbstractEventOperation srcOp = this.getOperation(srcMsgEnd, tgtMsg, op);
                                if (srcOp == null) break;
                                EventReceiptOperation rcvOp = InteractionFactory.eINSTANCE.createEventReceiptOperation();
                                rcvOp.setOperation(srcOp);
                                tgtMsgEnd.setEvent((Event)rcvOp);
                                rcvOp.setName(EcoreUtil2.getUniqueName((EObject)rcvOp, (EObject)this.scenario, (EStructuralFeature)InteractionPackage.Literals.SCENARIO__OWNED_EVENTS, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)MessageFormat.format(Messages.EventReceiptOperationNamePattern, tgtMsg.getName(), tgtMsg.getKind())));
                                this.scenario.getOwnedEvents().add((Object)rcvOp);
                                RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)rcvOp, (NamedElement)srcMsgEnd.getEvent(), (Namespace)this.scenario);
                                this.addClonedElement((CapellaElement)rcvOp);
                                break;
                            }
                            if (!(srcEvt instanceof CreationEvent)) break;
                            CreationEvent rcvOp = InteractionFactory.eINSTANCE.createCreationEvent();
                            tgtMsgEnd.setEvent((Event)rcvOp);
                            rcvOp.setName(EcoreUtil2.getUniqueName((EObject)rcvOp, (EObject)this.scenario, (EStructuralFeature)InteractionPackage.Literals.SCENARIO__OWNED_EVENTS, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)MessageFormat.format(Messages.CreationEventNamePattern, tgtMsg.getName(), tgtMsg.getKind())));
                            this.scenario.getOwnedEvents().add((Object)rcvOp);
                            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)rcvOp, (NamedElement)srcMsgEnd.getEvent(), (Namespace)this.scenario);
                            this.addClonedElement((CapellaElement)rcvOp);
                            break;
                        }
                        case SENDER: {
                            tgtMsgEnd.setName(MessageFormat.format(Messages.MessageEndSenderNamePattern, tgtMsg.getName(), tgtMsg.getKind()));
                            EventSentOperation srcEvt = (EventSentOperation)srcMsgEnd.getEvent();
                            if (srcEvt == null) break;
                            EventSentOperation sndOp = InteractionFactory.eINSTANCE.createEventSentOperation();
                            AbstractEventOperation op = srcEvt.getOperation();
                            AbstractEventOperation srcOp = this.getOperation(srcMsgEnd, tgtMsg, op);
                            if (srcOp != null) {
                                sndOp.setOperation(srcOp);
                            }
                            tgtMsgEnd.setEvent((Event)sndOp);
                            tgtMsg.setSendingEnd(tgtMsgEnd);
                            sndOp.setName(EcoreUtil2.getUniqueName((EObject)sndOp, (EObject)this.scenario, (EStructuralFeature)InteractionPackage.Literals.SCENARIO__OWNED_EVENTS, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)MessageFormat.format(Messages.EventSentOperationNamePattern, tgtMsg.getName(), tgtMsg.getKind())));
                            this.scenario.getOwnedEvents().add((Object)sndOp);
                            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)sndOp, (NamedElement)srcMsgEnd.getEvent(), (Namespace)this.scenario);
                            this.addClonedElement((CapellaElement)sndOp);
                            break;
                        }
                    }
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtMsgEnd, (NamedElement)srcMsgEnd, (Namespace)this.scenario);
                    this.addClonedElement((CapellaElement)tgtMsgEnd);
                }
            }
        }
        return tgtMsgEnd;
    }

    public Node<InteractionFragment> cloneNode(Node<InteractionFragment> srcElt, AbstractInstance part, NamedElement tgtElement) {
        Node<Object> clonedElt = null;
        if (srcElt != null) {
            clonedElt = new Node<Object>(null);
            InteractionFragment interactionFragment = srcElt.getData();
            if (interactionFragment instanceof AbstractEnd) {
                InstanceRole tgtRole;
                AbstractEnd abstractEnd = (AbstractEnd)interactionFragment;
                if (part != null && (tgtRole = this.cloneInstanceRole(abstractEnd.getCovered(), part, tgtElement)) != null) {
                    if (!this.scenario.getOwnedInstanceRoles().contains((Object)tgtRole)) {
                        this.scenario.getOwnedInstanceRoles().add((Object)tgtRole);
                    }
                    if (abstractEnd instanceof MessageEnd) {
                        MessageEnd tgtMsgEnd;
                        MessageEnd srcMsgEnd = (MessageEnd)abstractEnd;
                        SequenceMessage tgtMsg = this.cloneSequenceMessage(srcMsgEnd.getMessage());
                        if (tgtMsg != null && !this.scenario.getOwnedMessages().contains((Object)tgtMsg)) {
                            this.scenario.getOwnedMessages().add((Object)tgtMsg);
                        }
                        if ((tgtMsgEnd = this.cloneMessageEnd(srcMsgEnd, tgtMsg)) != null) {
                            tgtMsgEnd.getCoveredInstanceRoles().add((Object)tgtRole);
                            if (!this.scenario.getOwnedInteractionFragments().contains((Object)tgtMsgEnd)) {
                                this.scenario.getOwnedInteractionFragments().add((Object)tgtMsgEnd);
                            }
                        }
                        clonedElt.setData(tgtMsgEnd);
                    } else if (abstractEnd instanceof ExecutionEnd) {
                        ExecutionEnd srcExecEnd = (ExecutionEnd)abstractEnd;
                        ExecutionEnd tgtExecEnd = this.cloneExecutionEnd(srcExecEnd);
                        tgtExecEnd.getCoveredInstanceRoles().add((Object)tgtRole);
                        if (!this.scenario.getOwnedInteractionFragments().contains((Object)tgtExecEnd)) {
                            this.scenario.getOwnedInteractionFragments().add((Object)tgtExecEnd);
                        }
                        clonedElt.setData(tgtExecEnd);
                    }
                }
            } else if (interactionFragment instanceof FragmentEnd) {
                FragmentEnd srcFragmentEnd = (FragmentEnd)interactionFragment;
                AbstractFragment srcFragment = srcFragmentEnd.getAbstractFragment();
                CombinedFragment tgtFragment = null;
                if (srcFragment instanceof CombinedFragment) {
                    tgtFragment = this.cloneCombinedFragment((CombinedFragment)srcFragment);
                } else if (srcFragment instanceof InteractionUse) {
                    tgtFragment = this.cloneInteractionUse((InteractionUse)srcFragment);
                }
                if (tgtFragment != null && !this.scenario.getOwnedTimeLapses().contains((Object)tgtFragment)) {
                    this.scenario.getOwnedTimeLapses().add((Object)tgtFragment);
                }
                FragmentEnd tgtFragmentEnd = this.cloneFragmentEnd(srcFragmentEnd, (AbstractFragment)tgtFragment);
                if (tgtFragment instanceof InteractionUse) {
                    List<InstanceRole> tgtRoles = this.cloneInstanceRoles((List<InstanceRole>)srcFragmentEnd.getCoveredInstanceRoles(), part, tgtElement);
                    tgtFragmentEnd.getCoveredInstanceRoles().addAll(tgtRoles);
                }
                if (!this.scenario.getOwnedInteractionFragments().contains((Object)tgtFragmentEnd)) {
                    this.scenario.getOwnedInteractionFragments().add((Object)tgtFragmentEnd);
                }
                clonedElt.setData(tgtFragmentEnd);
            } else if (interactionFragment instanceof InteractionOperand) {
                InteractionOperand srcOperand = (InteractionOperand)interactionFragment;
                InteractionOperand tgtOperand = this.cloneInteractionOperand(srcOperand);
                if (!this.scenario.getOwnedInteractionFragments().contains((Object)tgtOperand)) {
                    this.scenario.getOwnedInteractionFragments().add((Object)tgtOperand);
                }
                clonedElt.setData(tgtOperand);
            }
            clonedElt.relatedNode = srcElt;
            srcElt.relatedNode = clonedElt;
            if (srcElt.oppositeNode != null) {
                clonedElt.oppositeNode = srcElt.oppositeNode.relatedNode;
                if (clonedElt.oppositeNode != null) {
                    clonedElt.oppositeNode.oppositeNode = clonedElt;
                }
            }
        }
        return clonedElt;
    }

    private SequenceMessage cloneSequenceMessage(SequenceMessage srcMsg) {
        SequenceMessage tgtMsg = null;
        if (srcMsg != null) {
            if (srcMsg.eContainer().equals(this.scenario)) {
                tgtMsg = srcMsg;
            } else {
                List lst = RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)srcMsg, (EClass)InteractionPackage.Literals.SEQUENCE_MESSAGE);
                for (CapellaElement elt : lst) {
                    if (!elt.eContainer().equals(this.scenario)) continue;
                    tgtMsg = (SequenceMessage)elt;
                }
                if (tgtMsg == null) {
                    tgtMsg = InteractionFactory.eINSTANCE.createSequenceMessage();
                    tgtMsg.setKind(srcMsg.getKind());
                    tgtMsg.setName(srcMsg.getName());
                    RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)tgtMsg, (NamedElement)srcMsg, (Namespace)this.scenario);
                    this.addClonedElement((CapellaElement)tgtMsg);
                }
            }
        }
        return tgtMsg;
    }

    private void export(Node<InteractionFragment> currentNode, List<InteractionFragment> list) {
        Node<InteractionFragment> childNode = currentNode.getFirstChildNode();
        while (childNode != null) {
            InteractionFragment interactionFragment = childNode.getData();
            if (interactionFragment instanceof MessageEnd) {
                MessageEnd messageEnd = (MessageEnd)interactionFragment;
                if (childNode.oppositeNode.getData() != null) {
                    String abstractEndName = messageEnd.getName();
                    if (abstractEndName != null) {
                        messageEnd.setName(EcoreUtil2.getUniqueName((EObject)messageEnd, (EObject)this.scenario, (EStructuralFeature)InteractionPackage.Literals.SCENARIO__OWNED_INTERACTION_FRAGMENTS, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)messageEnd.getName()));
                    }
                    list.add((InteractionFragment)messageEnd);
                } else {
                    Event evt;
                    SequenceMessage msg = messageEnd.getMessage();
                    if (msg != null) {
                        CapellaElementExt.cleanTraces((CapellaElement)msg);
                        msg.destroy();
                    }
                    if ((evt = messageEnd.getEvent()) != null) {
                        CapellaElementExt.cleanTraces((CapellaElement)evt);
                        evt.destroy();
                    }
                    CapellaElementExt.cleanTraces((CapellaElement)messageEnd);
                    messageEnd.destroy();
                }
            } else if (interactionFragment instanceof ExecutionEnd) {
                list.add(interactionFragment);
            } else if (interactionFragment instanceof FragmentEnd && interactionFragment.eContainer() != null) {
                list.add(interactionFragment);
            } else if (interactionFragment instanceof InteractionOperand && interactionFragment.eContainer() != null) {
                list.add(interactionFragment);
            }
            this.export(childNode, list);
            childNode = childNode.getNextNode();
        }
    }

    public void export(ScenarioRepresentation srcTree) {
        if (this.scenario != null) {
            ArrayList<InteractionFragment> newList = new ArrayList<InteractionFragment>();
            this.export(this.getRootNode(), newList);
            this.scenario.getOwnedInteractionFragments().clear();
            this.scenario.getOwnedInteractionFragments().addAll(newList);
            this.cloneExecutions(srcTree);
            this.fillCombinedFragment();
        }
    }

    private void fillCombinedFragment() {
        ArrayList<CombinedFragment> emptyCBToBeRemoved = new ArrayList<CombinedFragment>();
        for (TimeLapse timeLapse : this.scenario.getOwnedTimeLapses()) {
            List coveredInstanceRoles;
            FragmentEnd tgtFinish;
            FragmentEnd tgtStart;
            Object srcFinish;
            FragmentEnd srcStart;
            if (timeLapse instanceof InteractionUse) {
                InteractionUse tgtInteractionUse = (InteractionUse)timeLapse;
                InteractionUse srcInteractionUse = (InteractionUse)CapellaElementExt.getRefinementTgtElement((CapellaElement)tgtInteractionUse, (EClass)InteractionPackage.Literals.INTERACTION_USE);
                if (srcInteractionUse == null) continue;
                srcStart = (FragmentEnd)srcInteractionUse.getStart();
                srcFinish = (FragmentEnd)srcInteractionUse.getFinish();
                tgtStart = (FragmentEnd)CapellaElementExt.getRefinementSrcElement((CapellaElement)srcStart, (EClass)InteractionPackage.Literals.FRAGMENT_END, (EObject)this.scenario);
                tgtFinish = (FragmentEnd)CapellaElementExt.getRefinementSrcElement((CapellaElement)srcFinish, (EClass)InteractionPackage.Literals.FRAGMENT_END, (EObject)this.scenario);
                if (tgtStart == null || tgtFinish == null) continue;
                coveredInstanceRoles = AbstractFragmentExt.getCoveredInstanceRoles((AbstractFragment)srcInteractionUse, (Scenario)this.scenario);
                tgtStart.getCoveredInstanceRoles().clear();
                tgtStart.getCoveredInstanceRoles().addAll((Collection)coveredInstanceRoles);
                tgtFinish.getCoveredInstanceRoles().clear();
                tgtFinish.getCoveredInstanceRoles().addAll((Collection)coveredInstanceRoles);
                continue;
            }
            if (!(timeLapse instanceof CombinedFragment)) continue;
            if (AbstractFragmentExt.isEmpty((CombinedFragment)((CombinedFragment)timeLapse), (Scenario)this.scenario)) {
                emptyCBToBeRemoved.add((CombinedFragment)timeLapse);
                continue;
            }
            CombinedFragment tgtCombinedFragment = (CombinedFragment)timeLapse;
            CombinedFragment srcCombinedFragment = (CombinedFragment)CapellaElementExt.getRefinementTgtElement((CapellaElement)tgtCombinedFragment, (EClass)InteractionPackage.Literals.COMBINED_FRAGMENT);
            if (srcCombinedFragment == null) continue;
            for (InteractionOperand srcOperand : srcCombinedFragment.getReferencedOperands()) {
                InteractionOperand tgtOperand = (InteractionOperand)CapellaElementExt.getRefinementSrcElement((CapellaElement)srcOperand, (EClass)InteractionPackage.Literals.INTERACTION_OPERAND, (EObject)this.scenario);
                if (tgtOperand == null) continue;
                tgtCombinedFragment.getReferencedOperands().add((Object)tgtOperand);
            }
            srcStart = (FragmentEnd)srcCombinedFragment.getStart();
            srcFinish = (FragmentEnd)srcCombinedFragment.getFinish();
            tgtStart = (FragmentEnd)CapellaElementExt.getRefinementSrcElement((CapellaElement)srcStart, (EClass)InteractionPackage.Literals.FRAGMENT_END, (EObject)this.scenario);
            tgtFinish = (FragmentEnd)CapellaElementExt.getRefinementSrcElement((CapellaElement)srcFinish, (EClass)InteractionPackage.Literals.FRAGMENT_END, (EObject)this.scenario);
            if (tgtStart == null || tgtFinish == null) continue;
            coveredInstanceRoles = AbstractFragmentExt.getCoveredInstanceRoles((FragmentEnd)tgtStart, (FragmentEnd)tgtFinish, (Scenario)this.scenario);
            for (InteractionOperand operand : tgtCombinedFragment.getReferencedOperands()) {
                operand.getCoveredInstanceRoles().clear();
                operand.getCoveredInstanceRoles().addAll((Collection)coveredInstanceRoles);
            }
            tgtStart.getCoveredInstanceRoles().clear();
            tgtStart.getCoveredInstanceRoles().addAll((Collection)coveredInstanceRoles);
            tgtFinish.getCoveredInstanceRoles().clear();
            tgtFinish.getCoveredInstanceRoles().addAll((Collection)coveredInstanceRoles);
        }
        for (CombinedFragment combinedFragment : emptyCBToBeRemoved) {
            this.removeEmptyCombinedFragment(combinedFragment);
        }
    }

    private void fillTree(List<InteractionFragment> msgList, Node<InteractionFragment> node) {
        Node<InteractionFragment> currentNode = node;
        for (InteractionFragment interactionFragment : msgList) {
            Node<InteractionFragment> childNode;
            if (interactionFragment instanceof MessageEnd && currentNode != null) {
                Node<InteractionFragment> oppositeMsgEndNode;
                SequenceMessage msg = ((MessageEnd)interactionFragment).getMessage();
                if (msg == null) continue;
                MessageKind kind = msg.getKind();
                String loggedMsg = MessageFormat.format(Messages.DebugScenarioContent, this.scenario.getName(), msg.getName(), kind);
                this.logger.debug((Object)new EmbeddedMessage(loggedMsg, "Refinement", (Object)this.scenario));
                Node<InteractionFragment> childNode2 = new Node<InteractionFragment>(currentNode, interactionFragment);
                this.addLastChild(currentNode, childNode2);
                MessageEnd oppositeMsgEnd = MessageEndExt.getOppositeMessageEnd((MessageEnd)((MessageEnd)interactionFragment));
                if (oppositeMsgEnd != null && (oppositeMsgEndNode = this.getNodeByData((InteractionFragment)oppositeMsgEnd)) != null) {
                    oppositeMsgEndNode.oppositeNode = childNode2;
                    childNode2.oppositeNode = oppositeMsgEndNode;
                }
                if (kind != MessageKind.REPLY) {
                    if ((kind.equals((Object)MessageKind.CREATE) || kind.equals((Object)MessageKind.DELETE)) && MessageEndExt.getMessageEndType((MessageEnd)((MessageEnd)interactionFragment)).equals((Object)MessageEndExt.COMPONENT_TYPE.RECEIVER)) {
                        currentNode = currentNode.getParent();
                        continue;
                    }
                    currentNode = childNode2;
                    continue;
                }
                currentNode = currentNode.getParent();
                continue;
            }
            if (interactionFragment instanceof ExecutionEnd && currentNode != null) {
                childNode = new Node<InteractionFragment>(currentNode, interactionFragment);
                this.addLastChild(currentNode, childNode);
                currentNode = currentNode.getParent();
                if (currentNode == null) continue;
                currentNode = currentNode.getParent();
                continue;
            }
            if (interactionFragment instanceof FragmentEnd && currentNode != null) {
                childNode = new Node<InteractionFragment>(currentNode, interactionFragment);
                FragmentEndExt.FRAGMENT_END_TYPE type = FragmentEndExt.getFragmentEndType((FragmentEnd)((FragmentEnd)interactionFragment));
                if (!type.equals((Object)FragmentEndExt.FRAGMENT_END_TYPE.FINISH)) {
                    this.addLastChild(currentNode, childNode);
                    currentNode = childNode;
                    continue;
                }
                Node<InteractionFragment> parentNode = currentNode.getFirstParentInstanceOf(InteractionPackage.Literals.FRAGMENT_END);
                if (parentNode != null) {
                    this.addLastChild(parentNode, childNode);
                } else {
                    this.addLastChild(currentNode, childNode);
                }
                currentNode = currentNode.getParent();
                continue;
            }
            if (interactionFragment instanceof InteractionOperand && currentNode != null) {
                childNode = new Node<InteractionFragment>(currentNode, interactionFragment);
                Node<InteractionFragment> parentNode = currentNode.getFirstParentInstanceOf(InteractionPackage.Literals.FRAGMENT_END);
                if (parentNode != null) {
                    this.addLastChild(parentNode, childNode);
                } else {
                    this.addLastChild(currentNode, childNode);
                }
                currentNode = childNode;
                continue;
            }
            if (!(interactionFragment instanceof InteractionState) || currentNode == null) continue;
            childNode = new Node<InteractionFragment>(currentNode, interactionFragment);
            this.addLastChild(currentNode, childNode);
        }
    }

    public Node<InteractionFragment> getChildBranchContainingNode(Node<InteractionFragment> commonNode, Node<InteractionFragment> eltNode) {
        Node<InteractionFragment> childNode = null;
        Node<InteractionFragment> returnedNode = null;
        if (commonNode != null && eltNode != null) {
            childNode = commonNode.getFirstChildNode();
            while (childNode != null && returnedNode == null) {
                if (this.getNodeByData(childNode, eltNode.getData()) != null) {
                    returnedNode = childNode;
                }
                childNode = childNode.getNextNode();
            }
        }
        return returnedNode;
    }

    public Node<InteractionFragment> getNodeByData(InteractionFragment nodeData) {
        for (Node<InteractionFragment> node : this.walk()) {
            if (node.getData() != nodeData) continue;
            return node;
        }
        return null;
    }

    private Node<InteractionFragment> getNodeByData(Node<InteractionFragment> currentNode, InteractionFragment nodeData) {
        for (Node<InteractionFragment> node : this.messageTree.walk(currentNode)) {
            if (node.getData() != nodeData) continue;
            return node;
        }
        return null;
    }

    private AbstractEventOperation getOperation(MessageEnd srcMsgEnd, SequenceMessage tgtMsg, AbstractEventOperation currentOp) {
        AbstractEventOperation finalOp = null;
        if (currentOp != null) {
            finalOp = RefinementServices.getDelegatedOperation((CapellaElement)srcMsgEnd, (CapellaElement)tgtMsg, currentOp);
        }
        return finalOp;
    }

    public Node<InteractionFragment> getRootNode() {
        if (this.messageTree != null) {
            return this.messageTree.getRootElement();
        }
        return null;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    private void removeEmptyCombinedFragment(CombinedFragment combinedFragment) {
        for (InteractionOperand operand : AbstractFragmentExt.getOwnedOperands((CombinedFragment)combinedFragment, (Scenario)this.scenario)) {
            CapellaElementExt.cleanTraces((CapellaElement)operand);
            operand.destroy();
        }
        CapellaElementExt.cleanTraces((CapellaElement)combinedFragment.getStart());
        combinedFragment.getStart().destroy();
        CapellaElementExt.cleanTraces((CapellaElement)combinedFragment.getFinish());
        combinedFragment.getFinish().destroy();
        CapellaElementExt.cleanTraces((CapellaElement)combinedFragment);
        combinedFragment.destroy();
    }

    public String toString() {
        if (this.messageTree != null) {
            return this.messageTree.toString();
        }
        return super.toString();
    }

    public void unChainCurrentNodeMessage(Node<InteractionFragment> currentNode) {
        if (this.messageTree != null) {
            this.messageTree.unChainCurrentNodeMessage(currentNode);
            this.updateListeners();
        }
    }

    private void updateListeners() {
        for (IScenarioRepresentationListener listener : this.listeners) {
            listener.scenarioChanged(this.messageTree);
        }
    }

    public void updateOperationNode(Node<InteractionFragment> srcNode, Node<InteractionFragment> tgtNode) {
        InteractionFragment srcAbstractEnd = srcNode.getData();
        InteractionFragment tgtAbstractEnd = tgtNode.getData();
        if (srcAbstractEnd instanceof MessageEnd && tgtAbstractEnd != null) {
            MessageEnd srcMsgEnd = (MessageEnd)srcAbstractEnd;
            MessageEnd tgtMsgEnd = (MessageEnd)tgtAbstractEnd;
            MessageEndExt.COMPONENT_TYPE type = MessageEndExt.getMessageEndType((MessageEnd)srcMsgEnd);
            switch (type) {
                case RECEIVER: {
                    Event srcEvt = srcMsgEnd.getEvent();
                    if (!(srcEvt instanceof EventReceiptOperation)) break;
                    AbstractEventOperation targetOp = null;
                    AbstractEventOperation srcOp = ((EventReceiptOperation)srcEvt).getOperation();
                    AbstractEventOperation deletegatedOp = this.getOperation(srcMsgEnd, tgtMsgEnd.getMessage(), srcOp);
                    EventReceiptOperation eventReceiptOp = (EventReceiptOperation)tgtMsgEnd.getEvent();
                    if (eventReceiptOp != null) {
                        targetOp = eventReceiptOp.getOperation();
                    }
                    if (targetOp == deletegatedOp || eventReceiptOp == null) break;
                    eventReceiptOp.setOperation(deletegatedOp);
                    SequenceMessage tgtSeqMsg = tgtMsgEnd.getMessage();
                    tgtSeqMsg.setName(srcMsgEnd.getMessage().getName());
                    break;
                }
                case SENDER: {
                    EventSentOperation srcEvt = (EventSentOperation)srcMsgEnd.getEvent();
                    if (srcEvt == null) break;
                    AbstractEventOperation targetOp = null;
                    AbstractEventOperation srcOp = srcEvt.getOperation();
                    AbstractEventOperation delegatedOp = this.getOperation(srcMsgEnd, tgtMsgEnd.getMessage(), srcOp);
                    EventSentOperation eventSentOp = (EventSentOperation)tgtMsgEnd.getEvent();
                    if (eventSentOp != null) {
                        targetOp = eventSentOp.getOperation();
                    }
                    if (targetOp == delegatedOp || eventSentOp == null) break;
                    eventSentOp.setOperation(delegatedOp);
                    SequenceMessage tgtSeqMsg = tgtMsgEnd.getMessage();
                    tgtSeqMsg.setName(srcMsgEnd.getMessage().getName());
                    break;
                }
            }
        }
    }

    public List<Node<InteractionFragment>> walk() {
        if (this.messageTree != null) {
            return this.messageTree.walk(this.messageTree.getRootElement());
        }
        return Collections.emptyList();
    }
}

