/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.scenarios.core.datastructures;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.Node;

public class Tree<T> {
    private Node<T> rootElement = null;

    public Node<T> getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(Node<T> rootElement) {
        this.rootElement = rootElement;
    }

    public String toString() {
        return this.walk(this.rootElement).toString();
    }

    public List<Node<T>> walk(Node<T> element) {
        ArrayList<Node<T>> list = new ArrayList<Node<T>>();
        list.add(element);
        for (Node<T> data : element.getChildren()) {
            list.addAll(this.walk(data));
        }
        return list;
    }

    public void unChainCurrentNodeMessage(Node<T> currentNode) {
        for (Node<T> node : this.walk(this.rootElement)) {
            if (node != currentNode) continue;
            Node nextNode = node.next;
            Node parentNode = node.parent;
            Node previousNode = node.previous;
            if (previousNode != null) {
                previousNode.next = nextNode;
            }
            if (nextNode != null) {
                nextNode.previous = previousNode;
            }
            if (parentNode != null && parentNode.head == node) {
                parentNode.head = previousNode != null ? previousNode : nextNode;
            }
            node.next = null;
            node.previous = null;
            node.parent = null;
            return;
        }
    }
}

