/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.common.re.handlers.scope.DefaultDependenciesHandler;
import org.polarsys.capella.common.re.ui.handlers.uihead.UIHeadHandler;
import org.polarsys.capella.core.re.commands.CreateRecCommand;
import org.polarsys.capella.core.re.commands.UpdateCurCommand;
import org.polarsys.capella.core.re.project.ReProjectScope;
import org.polarsys.capella.core.re.project.handlers.Messages;
import org.polarsys.capella.core.transition.common.commands.CommandHandler;
import org.polarsys.capella.core.transition.common.commands.DefaultCommand;
import org.polarsys.capella.core.transition.common.commands.LauncherCommand;
import org.polarsys.capella.core.transition.common.transposer.SharedWorkflowActivityParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class ProjectRecHandler
extends CommandHandler {
    public Object execute(final Collection<?> selection, String name) throws ExecutionException {
        try {
            LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
            final AtomicReference cmdRef = new AtomicReference();
            IRunnableWithProgress progress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    cmdRef.set(ProjectRecHandler.this.createInterruptableCommand(selection, monitor));
                }
            };
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(true, true, progress);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ICommand cmd = (ICommand)cmdRef.get();
            if (cmd instanceof LauncherCommand) {
                ((LauncherCommand)cmd).setName(name);
            }
            if (cmd != null) {
                TransactionHelper.getExecutionManager((Collection)this.getSemanticObjects(selection)).execute(cmd);
            } else {
                this.handleNullCommand();
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
        return null;
    }

    protected void handleNullCommand() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.ProjectRecHandler_emptyLibraryDialogTitle, (String)Messages.ProjectRecHandler_emtpyLibraryDialogMessage);
        }
    }

    protected ICommand createInterruptableCommand(Collection<?> selection, IProgressMonitor progressMonitor) throws InterruptedException {
        Collection<EObject> scope = ReProjectScope.getScope((EObject)selection.iterator().next(), progressMonitor);
        ICommand result = null;
        if (scope.size() > 0) {
            result = this.createRecProjectCommand(scope);
        }
        return result;
    }

    protected ICommand createCommand(Collection<?> selection, IProgressMonitor progressMonitor) {
        try {
            return this.createInterruptableCommand(selection, progressMonitor);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    protected abstract ICommand createRecProjectCommand(Collection<EObject> var1);

    protected final ICommand customizeParameters(DefaultCommand command, boolean showDiffmerge) {
        UIHeadHandler param = new UIHeadHandler(showDiffmerge);
        param.addSharedParameter(new GenericParameter("DEPENDENCIES_HANDLER", (Object)new DefaultDependenciesHandler(){

            public Collection<EObject> getScopeElements(Collection<EObject> initialScopeElements, Collection<EObject> scopeElements, IContext context) {
                return new ArrayList<EObject>(initialScopeElements);
            }

            public Collection<EObject> getComplementaryScopeElements(Collection<EObject> initialScopeElements, Collection<EObject> scopeElements, IContext context) {
                return new ArrayList<EObject>(initialScopeElements);
            }
        }, Messages.ProjectRecHandler_OptionsHandler));
        command.addParameters((SharedWorkflowActivityParameter)param);
        return command;
    }

    public static class Create
    extends ProjectRecHandler {
        @Override
        protected ICommand createRecProjectCommand(Collection<EObject> elementsForRec) {
            return this.customizeParameters((DefaultCommand)new CreateRecCommand(elementsForRec, (IProgressMonitor)new NullProgressMonitor()), false);
        }
    }

    public static class Update
    extends ProjectRecHandler {
        @Override
        protected ICommand createRecProjectCommand(Collection<EObject> elementsForRec) {
            return this.customizeParameters((DefaultCommand)new UpdateCurCommand(elementsForRec, (IProgressMonitor)new NullProgressMonitor()), true);
        }
    }
}

