/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview.handler;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerView;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.handler.AbstractViewHandler;

public class DeleteHandler
extends AbstractViewHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MarkerView view = this.getView(event);
        boolean oldRefreshState = view.isAutomaticRefresh();
        view.setAutomaticRefresh(false);
        Collection<?> selection = this.getSelection(event);
        view.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        for (Object o : selection) {
            this.delete(view, o);
        }
        view.getViewer().refresh();
        this.getView(event).setAutomaticRefresh(oldRefreshState);
        return null;
    }

    private void delete(MarkerView view, Object element) {
        IMarker m;
        ITreeContentProvider provider = (ITreeContentProvider)view.getViewer().getContentProvider();
        if (provider.hasChildren(element)) {
            view.getViewer().collapseToLevel(element, -1);
            Object[] objectArray = provider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.delete(view, child);
                ++n2;
            }
        }
        if (element instanceof IMarker && (m = (IMarker)element).exists()) {
            try {
                m.delete();
            }
            catch (CoreException exception) {
                MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", exception.getMessage(), (Throwable)exception));
            }
        }
    }
}

