/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.subscenario;

import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.refinement.processor.StructureSynchronizationProcessor;
import org.polarsys.capella.core.refinement.scenarios.core.ScenarioRefinement;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;

public class SubScenarioRefinement
extends ScenarioRefinement {
    private String scenarioName = null;
    private Scenario targetScenario = null;

    public SubScenarioRefinement(Scenario srcDiagram, Scenario tgtDiagram) {
        super(srcDiagram, ScenarioExt.getContainer((Scenario)tgtDiagram), SubScenarioRefinement.isIntraLogicalLayer((CapellaElement)srcDiagram, (CapellaElement)tgtDiagram), false);
        this.targetScenario = tgtDiagram;
    }

    public SubScenarioRefinement(Scenario srcDiagram, ComponentArchitecture arch, String scenarioName) {
        super(srcDiagram, (NamedElement)arch, SubScenarioRefinement.isIntraLogicalLayer((CapellaElement)srcDiagram, (CapellaElement)arch), false);
        this.scenarioName = scenarioName;
    }

    public SubScenarioRefinement(Scenario srcDiagram_, Component component, String scenarioName) {
        super(srcDiagram_, (NamedElement)component, SubScenarioRefinement.isIntraLogicalLayer((CapellaElement)srcDiagram_, (CapellaElement)component), false);
        this.scenarioName = scenarioName;
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        if (this.targetScenario == null) {
            StructureSynchronizationProcessor proc = new StructureSynchronizationProcessor((NamedElement)this.getContext(), this.getTarget(), true);
            proc.execute(progressMonitor);
            this.targetScenario = (Scenario)proc.getResult();
            this.applyNamingRule((NamedElement)this.targetScenario, this.getTarget(), this.scenarioName);
        } else {
            RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)this.targetScenario, (NamedElement)this.getContext());
        }
        this.forceTargetScenario(this.targetScenario);
        super.execute(progressMonitor);
    }

    private static boolean isIntraLogicalLayer(CapellaElement srcDiagram, CapellaElement tgtDiagram) {
        return CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)srcDiagram) && CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)tgtDiagram);
    }
}

