/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.activities;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerFactory;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.command.DeleteStructureCommand;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.CompoundTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.traceability.config.TransformationConfiguration;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeTransformationActivity
extends org.polarsys.capella.core.transition.common.activities.InitializeTransformationActivity {
    public static final String ID = "org.polarsys.capella.core.transition.system.activities.InitializeTransformationActivity";

    protected IHandler createDefaultTraceabilityTransformationHandler() {
        TransformationConfiguration configuration = new TransformationConfiguration();
        return new CompoundTraceabilityHandler((ITraceabilityConfiguration)configuration);
    }

    protected EObject createTargetTransformationContainer(Resource source, IContext context) {
        Project project = (Project)CapellaElementExt.getRoot((CapellaElement)((CapellaElement)source.getContents().get(0)));
        SystemEngineering engineering = this.getEngineering(project, "TRANSFORMED", context);
        if (engineering != null) {
            ArrayList<SystemEngineering> toDelete = new ArrayList<SystemEngineering>();
            toDelete.add(engineering);
            ExecutionManager em = TransactionHelper.getExecutionManager(toDelete);
            DeleteStructureCommand command = new DeleteStructureCommand((EditingDomain)em.getEditingDomain(), toDelete);
            if (context.get((Object)"DIFFMERGE_DISABLE") == null) {
                if (command.canExecute()) {
                    command.execute();
                }
                engineering = null;
            }
        }
        if (engineering == null) {
            engineering = CapellamodellerFactory.eINSTANCE.createSystemEngineering("TRANSFORMED");
            AttachmentHelper.getInstance((IContext)context).createdElement(null, (EObject)engineering, context);
            if (context.get((Object)"DIFFMERGE_DISABLE") != null) {
                project.getOwnedModelRoots().add(1, (Object)engineering);
            }
        }
        return engineering;
    }

    private SystemEngineering getEngineering(Project project, String name, IContext context) {
        for (ModelRoot root : project.getOwnedModelRoots()) {
            if (!(root instanceof SystemEngineering) || !name.equals(((SystemEngineering)root).getName())) continue;
            return (SystemEngineering)root;
        }
        return null;
    }
}

