/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.polarsys.capella.common.helpers.export.AbstractExporter;
import org.polarsys.capella.common.helpers.export.ExportMessages;
import org.polarsys.capella.common.helpers.export.utils.CSVWriter;

public class CSVExporter
extends AbstractExporter {
    protected char delimiter;

    public CSVExporter(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public void export(OutputStream stream, Object data) throws IOException {
        this.export(stream, (List)data);
    }

    public void export(OutputStream stream, List<String[]> data) throws IOException {
        CSVWriter writer = new CSVWriter(stream, this.delimiter);
        for (String[] line : data) {
            if (line == null || line.length == 0) {
                writer.endRecord();
            }
            writer.writeRecord(line);
        }
        writer.flush();
    }

    @Override
    public String getExtension() {
        return "csv";
    }

    @Override
    public String getDescription() {
        return ExportMessages.csvDesc;
    }
}

