/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.OperationalAnalysisRealization;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemContext;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSContext;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalContext;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.la.SystemAnalysisRealization;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.oa.OperationalContext;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalContext;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.data.requirement.RequirementFactory;
import org.polarsys.capella.core.data.requirement.RequirementsPkg;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalActorPkgExt;
import org.polarsys.capella.core.model.helpers.LogicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.OperationalAnalysisExt;
import org.polarsys.capella.core.model.helpers.PhysicalActorPkgExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class BlockArchitectureExt {
    public static Type getBlockArchitectureType(BlockArchitecture block) {
        if (block instanceof OperationalAnalysis) {
            return Type.OA;
        }
        if (block instanceof SystemAnalysis) {
            return Type.SA;
        }
        if (block instanceof LogicalArchitecture) {
            return Type.LA;
        }
        if (block instanceof PhysicalArchitecture) {
            return Type.PA;
        }
        if (block instanceof EPBSArchitecture) {
            return Type.EPBS;
        }
        return null;
    }

    public static BlockArchitecture getBlockArchitecture(Type type, Project project) {
        SystemEngineering system = SystemEngineeringExt.getSystemEngineering(project);
        switch (type) {
            case OA: {
                return SystemEngineeringExt.getOperationalAnalysis(system);
            }
            case SA: {
                return SystemEngineeringExt.getSystemAnalysis(system);
            }
            case LA: {
                return SystemEngineeringExt.getLogicalArchitecture(system);
            }
            case PA: {
                return SystemEngineeringExt.getPhysicalArchitecture(system);
            }
            case EPBS: {
                return SystemEngineeringExt.getEPBSArchitecture(system);
            }
        }
        return null;
    }

    public static BlockArchitecture getBlockArchitecture(EClass clazz, Project project) {
        SystemEngineering system = SystemEngineeringExt.getSystemEngineering(project);
        if (OaPackage.Literals.OPERATIONAL_ANALYSIS.equals(clazz)) {
            return SystemEngineeringExt.getOperationalAnalysis(system);
        }
        if (CtxPackage.Literals.SYSTEM_ANALYSIS.equals(clazz)) {
            return SystemEngineeringExt.getSystemAnalysis(system);
        }
        if (LaPackage.Literals.LOGICAL_ARCHITECTURE.equals(clazz)) {
            return SystemEngineeringExt.getLogicalArchitecture(system);
        }
        if (PaPackage.Literals.PHYSICAL_ARCHITECTURE.equals(clazz)) {
            return SystemEngineeringExt.getPhysicalArchitecture(system);
        }
        if (EpbsPackage.Literals.EPBS_ARCHITECTURE.equals(clazz)) {
            return SystemEngineeringExt.getEPBSArchitecture(system);
        }
        return null;
    }

    public static Collection<BlockArchitecture> getAllAllocatedArchitectures(BlockArchitecture architecture) {
        LinkedList<BlockArchitecture> listArchitectures = new LinkedList<BlockArchitecture>();
        HashSet<BlockArchitecture> allocatedArchitectures = new HashSet<BlockArchitecture>();
        if (architecture != null) {
            listArchitectures.add(architecture);
            while (listArchitectures.size() > 0) {
                BlockArchitecture current = (BlockArchitecture)listArchitectures.removeFirst();
                allocatedArchitectures.add(current);
                for (BlockArchitecture allocated : current.getAllocatedArchitectures()) {
                    if (allocated == null || allocatedArchitectures.contains(allocated)) continue;
                    listArchitectures.addLast(allocated);
                }
            }
        }
        return allocatedArchitectures;
    }

    public static Collection<BlockArchitecture> getAllAllocatingArchitectures(BlockArchitecture architecture) {
        LinkedList<BlockArchitecture> listArchitectures = new LinkedList<BlockArchitecture>();
        HashSet<BlockArchitecture> allocatingArchitectures = new HashSet<BlockArchitecture>();
        if (architecture != null) {
            listArchitectures.add(architecture);
            while (listArchitectures.size() > 0) {
                BlockArchitecture current = (BlockArchitecture)listArchitectures.removeFirst();
                allocatingArchitectures.add(current);
                for (BlockArchitecture allocated : current.getAllocatingArchitectures()) {
                    if (allocated == null || allocatingArchitectures.contains(allocated)) continue;
                    listArchitectures.addLast(allocated);
                }
            }
        }
        return allocatingArchitectures;
    }

    public static List<ExchangeItem> getAllExchangeItems(BlockArchitecture architecture) {
        ArrayList<ExchangeItem> result = new ArrayList<ExchangeItem>();
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((CapellaElement)architecture);
        TreeIterator allContents = se.eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (object instanceof ExchangeItem) {
                result.add((ExchangeItem)object);
            }
            if (!(object instanceof BlockArchitecture) || se.getOwnedArchitectures().indexOf((Object)object) <= se.getOwnedArchitectures().indexOf((Object)architecture)) continue;
            return result;
        }
        return result;
    }

    public static List<ComponentExchange> getAllComponentExchanges(BlockArchitecture architecture) {
        ArrayList<ComponentExchange> instList = new ArrayList<ComponentExchange>();
        for (EObject obj : EObjectExt.getAll((EObject)architecture, (EClass)FaPackage.Literals.COMPONENT_EXCHANGE)) {
            instList.add((ComponentExchange)obj);
        }
        return instList;
    }

    public static BlockArchitecture getRootBlockArchitecture(EObject context) {
        EObject currentElement = context;
        while (currentElement != null) {
            if (currentElement instanceof BlockArchitecture) {
                return (BlockArchitecture)currentElement;
            }
            currentElement = currentElement.eContainer();
        }
        return null;
    }

    public static List<BlockArchitecture> getPreviousBlockArchitectures(BlockArchitecture anArchitecture) {
        PhysicalArchitecture pa;
        LogicalArchitecture la;
        SystemAnalysis sa;
        ArrayList<BlockArchitecture> returnedList = new ArrayList<BlockArchitecture>();
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)anArchitecture);
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis(sysEng);
        if (oa != null && anArchitecture.equals(oa)) {
            return returnedList;
        }
        if (oa != null) {
            returnedList.add((BlockArchitecture)oa);
        }
        if ((sa = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng)) != null && anArchitecture.equals(sa)) {
            return returnedList;
        }
        if (sa != null) {
            returnedList.add((BlockArchitecture)sa);
        }
        if ((la = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng)) != null && anArchitecture.equals(la)) {
            return returnedList;
        }
        if (la != null) {
            returnedList.add((BlockArchitecture)la);
        }
        if ((pa = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng)) != null && anArchitecture.equals(pa)) {
            return returnedList;
        }
        if (pa != null) {
            returnedList.add((BlockArchitecture)pa);
        }
        return returnedList;
    }

    public static List<BlockArchitecture> getRootAndPreviousBlockArchitectures(EObject context) {
        ArrayList<BlockArchitecture> returnedList = new ArrayList<BlockArchitecture>();
        BlockArchitecture root = BlockArchitectureExt.getRootBlockArchitecture(context);
        if (root == null) {
            return returnedList;
        }
        returnedList.add(root);
        returnedList.addAll(BlockArchitectureExt.getPreviousBlockArchitectures(root));
        return returnedList;
    }

    public static Structure getActorPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getActorPkg(architecture, true);
    }

    public static Structure getActorPkg(BlockArchitecture blockArchitecture1, boolean create) {
        if (blockArchitecture1 instanceof SystemAnalysis) {
            SystemAnalysis architecture = (SystemAnalysis)blockArchitecture1;
            if (architecture.getOwnedActorPkg() == null && create) {
                ActorPkg pkg = CtxFactory.eINSTANCE.createActorPkg(NamingConstants.CreateSysAnalysisCmd_actors_pkg_name);
                architecture.setOwnedActorPkg(pkg);
            }
            return architecture.getOwnedActorPkg();
        }
        if (blockArchitecture1 instanceof LogicalArchitecture) {
            LogicalArchitecture architecture = (LogicalArchitecture)blockArchitecture1;
            if (architecture.getOwnedLogicalActorPkg() == null && create) {
                LogicalActorPkg pkg = LaFactory.eINSTANCE.createLogicalActorPkg(NamingConstants.CreateLogicalArchCmd_actors_pkg_name);
                architecture.setOwnedLogicalActorPkg(pkg);
            }
            return architecture.getOwnedLogicalActorPkg();
        }
        if (blockArchitecture1 instanceof PhysicalArchitecture) {
            PhysicalArchitecture architecture = (PhysicalArchitecture)blockArchitecture1;
            if (architecture.getOwnedPhysicalActorPkg() == null && create) {
                PhysicalActorPkg pkg = PaFactory.eINSTANCE.createPhysicalActorPkg(NamingConstants.CreatePhysicalArchCmd_actors_pkg_name);
                architecture.setOwnedPhysicalActorPkg(pkg);
            }
            return architecture.getOwnedPhysicalActorPkg();
        }
        return null;
    }

    public static boolean isDefaultNameActorPkg(AbstractNamedElement pkg) {
        if (NamingConstants.CreateSysAnalysisCmd_actors_pkg_name.equals(pkg.getName())) {
            return true;
        }
        if (NamingConstants.CreateLogicalArchCmd_actors_pkg_name.equals(pkg.getName())) {
            return true;
        }
        return NamingConstants.CreatePhysicalArchCmd_actors_pkg_name.equals(pkg.getName());
    }

    public static DataPkg getDataPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedDataPkg() == null && create) {
            DataPkg pkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
            architecture.setOwnedDataPkg(pkg);
        }
        return architecture.getOwnedDataPkg();
    }

    public static boolean isDefaultNameDataPkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateCommonCmd_data_pkg_name.equals(pkg.getName());
    }

    public static DataPkg getDataPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getDataPkg(architecture, true);
    }

    public static Structure getRequirementsPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedRequirementPkgs().size() == 0 && create) {
            RequirementsPkg pkg = RequirementFactory.eINSTANCE.createRequirementsPkg(NamingConstants.CreateCommonCmd_requirements_pkg_name);
            architecture.getOwnedRequirementPkgs().add((Object)pkg);
        }
        if (architecture.getOwnedRequirementPkgs().isEmpty()) {
            return null;
        }
        return (Structure)architecture.getOwnedRequirementPkgs().get(0);
    }

    public static boolean isDefaultNameRequirementsPkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateCommonCmd_requirements_pkg_name.equals(pkg.getName());
    }

    public static Structure getRequirementsPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getRequirementsPkg(architecture, true);
    }

    public static AbstractCapabilityPkg getAbstractCapabilityPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getAbstractCapabilityPkg(architecture, true);
    }

    public static AbstractCapabilityPkg getAbstractCapabilityPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedAbstractCapabilityPkg() == null && create) {
            OperationalCapabilityPkg pkg = null;
            if (architecture instanceof OperationalAnalysis) {
                pkg = OaFactory.eINSTANCE.createOperationalCapabilityPkg(NamingConstants.CreateOpAnalysisCmd_operationalCapabilities_pkg_name);
            } else if (architecture instanceof SystemAnalysis) {
                pkg = CtxFactory.eINSTANCE.createCapabilityPkg(NamingConstants.CreateSysAnalysisCmd_capabilities_pkg_name);
            } else if (architecture instanceof LogicalArchitecture) {
                pkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
            } else if (architecture instanceof PhysicalArchitecture) {
                pkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
            } else if (architecture instanceof EPBSArchitecture) {
                pkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
            }
            architecture.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)pkg);
        }
        return architecture.getOwnedAbstractCapabilityPkg();
    }

    public static boolean isDefaultNameAbstractCapabilityPkg(AbstractNamedElement pkg) {
        if (NamingConstants.CreateOpAnalysisCmd_operationalCapabilities_pkg_name.equals(pkg.getName())) {
            return true;
        }
        if (NamingConstants.CreateSysAnalysisCmd_capabilities_pkg_name.equals(pkg.getName())) {
            return true;
        }
        return NamingConstants.CreateCommonCmd_capability_realisation_pkg_name.equals(pkg.getName());
    }

    public static InterfacePkg getInterfacePkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getInterfacePkg(architecture, true);
    }

    public static boolean isDefaultNameInterfacePkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateCommonCmd_interfaces_pkg_name.equals(pkg.getName());
    }

    public static InterfacePkg getInterfacePkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedInterfacePkg() == null && create) {
            InterfacePkg pkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
            architecture.setOwnedInterfacePkg(pkg);
        }
        return architecture.getOwnedInterfacePkg();
    }

    public static Component getContext(BlockArchitecture architecture) {
        return BlockArchitectureExt.getContext(architecture, true);
    }

    public static Component getContext(BlockArchitecture architecture, boolean create) {
        OperationalContext context = null;
        if (architecture instanceof OperationalAnalysis) {
            context = ((OperationalAnalysis)architecture).getOwnedOperationalContext();
            if (context == null && create) {
                context = OaFactory.eINSTANCE.createOperationalContext(NamingConstants.CreateOpAnalysisCmd_operational_context_name);
                ((OperationalAnalysis)architecture).setOwnedOperationalContext(context);
            }
        } else if (architecture instanceof SystemAnalysis) {
            context = ((SystemAnalysis)architecture).getOwnedSystemContext();
            if (context == null && create) {
                context = CtxFactory.eINSTANCE.createSystemContext(NamingConstants.CreateSysAnalysisCmd_system_context_name);
                ((SystemAnalysis)architecture).setOwnedSystemContext((SystemContext)context);
            }
        } else if (architecture instanceof LogicalArchitecture) {
            context = ((LogicalArchitecture)architecture).getOwnedLogicalContext();
            if (context == null && create) {
                context = LaFactory.eINSTANCE.createLogicalContext(NamingConstants.CreateLogicalArchCmd_logicalContext_name);
                ((LogicalArchitecture)architecture).setOwnedLogicalContext((LogicalContext)context);
            }
        } else if (architecture instanceof PhysicalArchitecture) {
            context = ((PhysicalArchitecture)architecture).getOwnedPhysicalContext();
            if (context == null && create) {
                context = PaFactory.eINSTANCE.createPhysicalContext(NamingConstants.CreatePhysicalArchCmd_physicalContext_name);
                ((PhysicalArchitecture)architecture).setOwnedPhysicalContext((PhysicalContext)context);
            }
        } else if (architecture instanceof EPBSArchitecture && (context = ((EPBSArchitecture)architecture).getOwnedEPBSContext()) == null && create) {
            context = EpbsFactory.eINSTANCE.createEPBSContext(NamingConstants.CreateEPBSArchCmd_epbsContext_name);
            ((EPBSArchitecture)architecture).setOwnedEPBSContext((EPBSContext)context);
        }
        return context;
    }

    public static FunctionPkg getFunctionPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getFunctionPkg(architecture, true);
    }

    public static FunctionPkg getFunctionPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedFunctionPkg() == null && create) {
            OperationalActivityPkg pkg = null;
            if (architecture instanceof OperationalAnalysis) {
                pkg = OaFactory.eINSTANCE.createOperationalActivityPkg(NamingConstants.CreateOpAnalysisCmd_operationalActivities_pkg_name);
            } else if (architecture instanceof SystemAnalysis) {
                pkg = CtxFactory.eINSTANCE.createSystemFunctionPkg(NamingConstants.CreateSysAnalysisCmd_system_functions_pkg_name);
            } else if (architecture instanceof LogicalArchitecture) {
                pkg = LaFactory.eINSTANCE.createLogicalFunctionPkg(NamingConstants.CreateLogicalArchCmd_logicalFunctions_pkg_name);
            } else if (architecture instanceof PhysicalArchitecture) {
                pkg = PaFactory.eINSTANCE.createPhysicalFunctionPkg(NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name);
            }
            architecture.setOwnedFunctionPkg((FunctionPkg)pkg);
        }
        return architecture.getOwnedFunctionPkg();
    }

    public static boolean isDefaultNameFunctionPkg(AbstractNamedElement pkg) {
        if (NamingConstants.CreateOpAnalysisCmd_operationalActivities_pkg_name.equals(pkg.getName())) {
            return true;
        }
        if (NamingConstants.CreateSysAnalysisCmd_system_functions_pkg_name.equals(pkg.getName())) {
            return true;
        }
        if (NamingConstants.CreateLogicalArchCmd_logicalFunctions_pkg_name.equals(pkg.getName())) {
            return true;
        }
        return NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name.equals(pkg.getName());
    }

    public static AbstractFunction getRootFunction(BlockArchitecture architecture) {
        return BlockArchitectureExt.getRootFunction(architecture, true);
    }

    public static AbstractFunction getRootFunction(BlockArchitecture architecture, boolean create) {
        AbstractFunction function = null;
        if (architecture != null) {
            FunctionPkg pkg = BlockArchitectureExt.getFunctionPkg(architecture, create);
            if (pkg == null) {
                return function;
            }
            if (architecture instanceof OperationalAnalysis) {
                OperationalActivityPkg spkg = (OperationalActivityPkg)pkg;
                if (!spkg.getOwnedOperationalActivities().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedOperationalActivities().get(0);
                } else if (create) {
                    function = OaFactory.eINSTANCE.createOperationalActivity(NamingConstants.CreateOpAnalysisCmd_operationalActivity_root_name);
                    spkg.getOwnedOperationalActivities().add((Object)((OperationalActivity)function));
                }
            } else if (architecture instanceof SystemAnalysis) {
                SystemFunctionPkg spkg = (SystemFunctionPkg)pkg;
                if (!spkg.getOwnedSystemFunctions().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedSystemFunctions().get(0);
                } else if (create) {
                    function = CtxFactory.eINSTANCE.createSystemFunction(NamingConstants.CreateSysAnalysisCmd_system_function_root_name);
                    spkg.getOwnedSystemFunctions().add((Object)((SystemFunction)function));
                }
            } else if (architecture instanceof LogicalArchitecture) {
                LogicalFunctionPkg spkg = (LogicalFunctionPkg)pkg;
                if (!spkg.getOwnedLogicalFunctions().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedLogicalFunctions().get(0);
                } else if (create) {
                    function = LaFactory.eINSTANCE.createLogicalFunction(NamingConstants.CreateLogicalArchCmd_logicalFunction_root_name);
                    spkg.getOwnedLogicalFunctions().add((Object)((LogicalFunction)function));
                }
            } else if (architecture instanceof PhysicalArchitecture) {
                PhysicalFunctionPkg spkg = (PhysicalFunctionPkg)pkg;
                if (!spkg.getOwnedPhysicalFunctions().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedPhysicalFunctions().get(0);
                } else if (create) {
                    function = PaFactory.eINSTANCE.createPhysicalFunction(NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name);
                    spkg.getOwnedPhysicalFunctions().add((Object)((PhysicalFunction)function));
                }
            }
        }
        return function;
    }

    public static boolean isDefaultNameRootFunction(AbstractNamedElement element) {
        if (NamingConstants.CreateOpAnalysisCmd_operationalActivity_root_name.equals(element.getName())) {
            return true;
        }
        if (NamingConstants.CreateSysAnalysisCmd_system_function_root_name.equals(element.getName())) {
            return true;
        }
        if (NamingConstants.CreateLogicalArchCmd_logicalFunction_root_name.equals(element.getName())) {
            return true;
        }
        return NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name.equals(element.getName());
    }

    public static Component getFirstComponent(ModellingArchitecture architecture, boolean create) {
        System first = null;
        if (architecture instanceof SystemAnalysis) {
            first = ((SystemAnalysis)architecture).getOwnedSystem();
            if (first == null && create) {
                first = CtxFactory.eINSTANCE.createSystem(NamingConstants.CreateSysAnalysisCmd_system_name);
                ((SystemAnalysis)architecture).setOwnedSystem(first);
            }
        } else if (architecture instanceof LogicalArchitecture) {
            first = ((LogicalArchitecture)architecture).getOwnedLogicalComponent();
            if (first == null && create) {
                first = LaFactory.eINSTANCE.createLogicalComponent(NamingConstants.CreateLogicalArchCmd_logicalComponent_name);
                ((LogicalArchitecture)architecture).setOwnedLogicalComponent((LogicalComponent)first);
            }
        } else if (architecture instanceof PhysicalArchitecture) {
            first = ((PhysicalArchitecture)architecture).getOwnedPhysicalComponent();
            if (first == null && create) {
                first = PaFactory.eINSTANCE.createPhysicalComponent(NamingConstants.CreatePhysicalArchCmd_physicalComponent_name);
                ((PhysicalArchitecture)architecture).setOwnedPhysicalComponent((PhysicalComponent)first);
            }
        } else if (architecture instanceof EPBSArchitecture && (first = ((EPBSArchitecture)architecture).getOwnedConfigurationItem()) == null && create) {
            first = EpbsFactory.eINSTANCE.createConfigurationItem(NamingConstants.CreateEPBSArchCmd_configurationItem_name);
            ((EPBSArchitecture)architecture).setOwnedConfigurationItem((ConfigurationItem)first);
        }
        return first;
    }

    public static boolean isDefaultNameFirstComponent(AbstractNamedElement element) {
        if (NamingConstants.CreateSysAnalysisCmd_system_name.equals(element.getName())) {
            return true;
        }
        if (NamingConstants.CreateLogicalArchCmd_logicalComponent_name.equals(element.getName())) {
            return true;
        }
        if (NamingConstants.CreatePhysicalArchCmd_physicalComponent_name.equals(element.getName())) {
            return true;
        }
        return NamingConstants.CreateEPBSArchCmd_configurationItem_name.equals(element.getName());
    }

    public static Component getFirstComponent(ModellingArchitecture architecture) {
        return BlockArchitectureExt.getFirstComponent(architecture, true);
    }

    public static boolean isRootComponent(Component component) {
        return component.eContainer() instanceof BlockArchitecture;
    }

    public static void getAllStatesAndModesFromBlockArchitecture(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        if (blockArch != null) {
            if (blockArch instanceof OperationalAnalysis) {
                BlockArchitectureExt.getAllStatesAndModesFromOperationalAnalysisLayer(blockArch, availableElements);
            } else if (blockArch instanceof SystemAnalysis) {
                BlockArchitectureExt.getAllStatesAndModesFromSystemAnalysisLayer(blockArch, availableElements);
            } else if (blockArch instanceof LogicalArchitecture) {
                BlockArchitectureExt.getAllStatesAndModesFromLogicalLayer(blockArch, availableElements);
            } else if (blockArch instanceof PhysicalArchitecture) {
                BlockArchitectureExt.getAllStatesAndModesFromPhysicalLayer(blockArch, availableElements);
            } else if (blockArch instanceof EPBSArchitecture) {
                BlockArchitectureExt.getAllStatesAndModesFromEPBSLayer(blockArch, availableElements);
            }
        }
    }

    public static void getAllStatesAndModesFromOperationalAnalysisLayer(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        OperationalAnalysis oa = (OperationalAnalysis)blockArch;
        EntityPkg ownedEntityPkg = oa.getOwnedEntityPkg();
        List<Entity> allEntity = OperationalAnalysisExt.getAllEntity(ownedEntityPkg);
        for (Entity entity : allEntity) {
            availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)entity));
        }
    }

    public static void getAllStatesAndModesFromSystemAnalysisLayer(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        SystemAnalysis ca = (SystemAnalysis)blockArch;
        SystemContext ownedSystemContext = ca.getOwnedSystemContext();
        availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)ownedSystemContext));
        System ownedSystem = ca.getOwnedSystem();
        availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)ownedSystem));
        ActorPkg ownedActorPkg = ca.getOwnedActorPkg();
        List allActors = ActorPkgExt.getAllActors((ActorPkg)ownedActorPkg);
        for (Actor actor : allActors) {
            availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)actor));
        }
    }

    public static void getAllStatesAndModesFromLogicalLayer(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        LogicalArchitecture logArch = (LogicalArchitecture)blockArch;
        LogicalContext ownedLogicalContext = logArch.getOwnedLogicalContext();
        availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)ownedLogicalContext));
        List<LogicalComponent> allLCsFromLogicalArchitectureLayer = LogicalArchitectureExt.getAllLCsFromLogicalArchitectureLayer(logArch);
        for (LogicalComponent logicalComponent : allLCsFromLogicalArchitectureLayer) {
            availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)logicalComponent));
        }
        List<LogicalActor> allLAsFromLAPkg = LogicalActorPkgExt.getAllLAsFromLAPkg(logArch.getOwnedLogicalActorPkg());
        for (LogicalActor logicalActor : allLAsFromLAPkg) {
            availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)logicalActor));
        }
    }

    public static void getAllStatesAndModesFromPhysicalLayer(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        PhysicalArchitecture phyArch = (PhysicalArchitecture)blockArch;
        PhysicalContext ownedPhysicalContext = phyArch.getOwnedPhysicalContext();
        availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)ownedPhysicalContext));
        List<PhysicalComponent> allPhysicalComponents = PhysicalArchitectureExt.getAllPhysicalComponents(phyArch);
        for (PhysicalComponent physicalComponent : allPhysicalComponents) {
            availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)physicalComponent));
        }
        List<PhysicalActor> allPAsFromPAPkg = PhysicalActorPkgExt.getAllPAsFromPAPkg(phyArch.getOwnedPhysicalActorPkg());
        for (PhysicalActor physicalActor : allPAsFromPAPkg) {
            availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)physicalActor));
        }
    }

    public static void getAllStatesAndModesFromEPBSLayer(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        EPBSArchitecture epbsArch = (EPBSArchitecture)blockArch;
        EPBSContext ownedEPBSContext = epbsArch.getOwnedEPBSContext();
        availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)ownedEPBSContext));
        List<ConfigurationItem> allConfigurationItems = SystemEngineeringExt.getAllConfigurationItems((CapellaElement)epbsArch);
        for (ConfigurationItem configurationItem : allConfigurationItems) {
            availableElements.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)configurationItem));
        }
    }

    public static Collection<Component> getAllComponents(BlockArchitecture blockArch) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (blockArch != null) {
            Set epbsSet = EObjectExt.getAll((EObject)blockArch, (EClass)CsPackage.Literals.COMPONENT);
            for (EObject cp : epbsSet) {
                if (!(cp instanceof Component)) continue;
                result.add((Component)cp);
            }
        }
        return result;
    }

    public static void getAllComponentsFromBlockArchitecture(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        if (blockArch != null) {
            if (blockArch instanceof OperationalAnalysis) {
                BlockArchitectureExt.getAllComponentsFromOA(blockArch, availableElements);
            } else if (blockArch instanceof SystemAnalysis) {
                BlockArchitectureExt.getAllComponentsFromSA(blockArch, availableElements);
            } else if (blockArch instanceof LogicalArchitecture) {
                BlockArchitectureExt.getAllComponentsFromLA(blockArch, availableElements);
            } else if (blockArch instanceof PhysicalArchitecture) {
                BlockArchitectureExt.getAllComponentsFromPA(blockArch, availableElements);
            } else if (blockArch instanceof EPBSArchitecture) {
                BlockArchitectureExt.getAllComponentsFromEPBS(blockArch, availableElements);
            }
        }
    }

    public static void getAllComponentsFromOA(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        if (blockArch != null && blockArch instanceof OperationalAnalysis) {
            OperationalAnalysis arch = (OperationalAnalysis)blockArch;
            OperationalContext context = arch.getOwnedOperationalContext();
            if (context != null) {
                availableElements.add((CapellaElement)context);
            }
            availableElements.addAll(OperationalAnalysisExt.getAllEntity(arch));
        }
    }

    public static void getAllComponentsFromSA(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        if (blockArch != null && blockArch instanceof SystemAnalysis) {
            System ownedSystem;
            SystemAnalysis ca = (SystemAnalysis)blockArch;
            SystemContext ownedSystemContext = ca.getOwnedSystemContext();
            if (ownedSystemContext != null) {
                availableElements.add((CapellaElement)ownedSystemContext);
            }
            if ((ownedSystem = ca.getOwnedSystem()) != null) {
                availableElements.add((CapellaElement)ownedSystem);
            }
            ActorPkg ownedActorPkg = ca.getOwnedActorPkg();
            availableElements.addAll(ActorPkgExt.getAllActors((ActorPkg)ownedActorPkg));
        }
    }

    public static void getAllComponentsFromLA(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        if (blockArch != null && blockArch instanceof LogicalArchitecture) {
            LogicalArchitecture logArch = (LogicalArchitecture)blockArch;
            LogicalContext ownedLogicalContext = logArch.getOwnedLogicalContext();
            if (ownedLogicalContext != null) {
                availableElements.add((CapellaElement)ownedLogicalContext);
            }
            availableElements.addAll(LogicalArchitectureExt.getAllLCsFromLogicalArchitectureLayer(logArch));
            availableElements.addAll(LogicalActorPkgExt.getAllLAsFromLAPkg(logArch.getOwnedLogicalActorPkg()));
        }
    }

    public static void getAllComponentsFromPA(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        if (blockArch != null && blockArch instanceof PhysicalArchitecture) {
            PhysicalArchitecture phyArch = (PhysicalArchitecture)blockArch;
            PhysicalContext ownedPhysicalContext = phyArch.getOwnedPhysicalContext();
            if (ownedPhysicalContext != null) {
                availableElements.add((CapellaElement)ownedPhysicalContext);
            }
            availableElements.addAll(PhysicalArchitectureExt.getAllPhysicalComponents(phyArch));
            availableElements.addAll(PhysicalActorPkgExt.getAllPAsFromPAPkg(phyArch.getOwnedPhysicalActorPkg()));
        }
    }

    public static void getAllComponentsFromEPBS(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        if (blockArch != null && blockArch instanceof EPBSArchitecture) {
            EPBSArchitecture epbsArch = (EPBSArchitecture)blockArch;
            EPBSContext ownedEPBSContext = epbsArch.getOwnedEPBSContext();
            if (ownedEPBSContext != null) {
                availableElements.add((CapellaElement)ownedEPBSContext);
            }
            availableElements.addAll(SystemEngineeringExt.getAllConfigurationItems((CapellaElement)epbsArch));
        }
    }

    public static List<Component> getFirstComponents(ModellingArchitecture architecture) {
        ConfigurationItem ci;
        SystemAnalysis arch;
        ArrayList<Component> result = new ArrayList<Component>(1);
        if (architecture instanceof OperationalAnalysis) {
            OperationalAnalysis archi = (OperationalAnalysis)architecture;
            EntityPkg ownedEntityPkg = archi.getOwnedEntityPkg();
            result.addAll((Collection<Component>)ownedEntityPkg.getOwnedEntities());
        }
        if (architecture instanceof SystemAnalysis) {
            ActorPkg ownedActorPkg;
            arch = (SystemAnalysis)architecture;
            System ownedSystem = arch.getOwnedSystem();
            if (ownedSystem != null) {
                result.add((Component)ownedSystem);
            }
            if ((ownedActorPkg = arch.getOwnedActorPkg()) != null) {
                result.addAll((Collection<Component>)ownedActorPkg.getOwnedActors());
            }
        } else if (architecture instanceof LogicalArchitecture) {
            LogicalActorPkg ownedActorPkg;
            arch = (LogicalArchitecture)architecture;
            LogicalComponent lc = arch.getOwnedLogicalComponent();
            if (lc != null) {
                result.add((Component)lc);
            }
            if ((ownedActorPkg = arch.getOwnedLogicalActorPkg()) != null) {
                result.addAll((Collection<Component>)ownedActorPkg.getOwnedLogicalActors());
            }
        } else if (architecture instanceof PhysicalArchitecture) {
            PhysicalActorPkg ownedActorPkg;
            arch = (PhysicalArchitecture)architecture;
            PhysicalComponent pc = arch.getOwnedPhysicalComponent();
            if (pc != null) {
                result.add((Component)pc);
            }
            if ((ownedActorPkg = arch.getOwnedPhysicalActorPkg()) != null) {
                result.addAll((Collection<Component>)ownedActorPkg.getOwnedPhysicalActors());
            }
        } else if (architecture instanceof EPBSArchitecture && (ci = (arch = (EPBSArchitecture)architecture).getOwnedConfigurationItem()) != null) {
            result.add((Component)ci);
        }
        return result;
    }

    public static List<BlockArchitecture> getPreviousBlockArchitecture(BlockArchitecture anArchitecture) {
        ArrayList<BlockArchitecture> result = new ArrayList<BlockArchitecture>();
        if (anArchitecture != null) {
            if (anArchitecture instanceof OperationalAnalysis) {
                return result;
            }
            result.addAll(BlockArchitectureExt.getPreviousBlockArchitectureByFunctinoalWay(anArchitecture));
            if (result.isEmpty()) {
                result.addAll(BlockArchitectureExt.getPreviousBlockArchitectureByClassicWay(anArchitecture));
            }
        }
        return result;
    }

    public static List<BlockArchitecture> getPreviousBlockArchitectureByFunctinoalWay(BlockArchitecture anArchitecture) {
        ArrayList<BlockArchitecture> result;
        block5: {
            block7: {
                block6: {
                    block4: {
                        result = new ArrayList<BlockArchitecture>();
                        if (!(anArchitecture instanceof SystemAnalysis)) break block4;
                        SystemAnalysis sa = (SystemAnalysis)anArchitecture;
                        EList allocatedOperationalAnalysisRealizations = sa.getAllocatedOperationalAnalysisRealizations();
                        for (OperationalAnalysisRealization oaRealization : allocatedOperationalAnalysisRealizations) {
                            BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)oaRealization);
                        }
                        break block5;
                    }
                    if (!(anArchitecture instanceof LogicalArchitecture)) break block6;
                    LogicalArchitecture la = (LogicalArchitecture)anArchitecture;
                    EList saRealizations = la.getAllocatedSystemAnalysisRealizations();
                    for (SystemAnalysisRealization saRealization : saRealizations) {
                        BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)saRealization);
                    }
                    break block5;
                }
                if (!(anArchitecture instanceof PhysicalArchitecture)) break block7;
                PhysicalArchitecture pa = (PhysicalArchitecture)anArchitecture;
                EList laRealizations = pa.getAllocatedLogicalArchitectureRealizations();
                for (LogicalArchitectureRealization laRealization : laRealizations) {
                    BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)laRealization);
                }
                break block5;
            }
            if (!(anArchitecture instanceof EPBSArchitecture)) break block5;
            EPBSArchitecture pa = (EPBSArchitecture)anArchitecture;
            EList paRealizations = pa.getAllocatedPhysicalArchitectureRealizations();
            for (PhysicalArchitectureRealization paRealization : paRealizations) {
                BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)paRealization);
            }
        }
        return result;
    }

    private static void addAllocatedArchitecture(List<BlockArchitecture> returnedList, ArchitectureAllocation archAllocation) {
        BlockArchitecture allocatedArch = archAllocation.getAllocatedArchitecture();
        if (allocatedArch != null) {
            returnedList.add(allocatedArch);
        }
    }

    public static List<BlockArchitecture> getPreviousBlockArchitectureByClassicWay(BlockArchitecture anArchitecture) {
        ArrayList<BlockArchitecture> result = new ArrayList<BlockArchitecture>();
        if (anArchitecture != null) {
            PhysicalArchitecture pa;
            SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)anArchitecture);
            if (anArchitecture instanceof SystemAnalysis) {
                OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis(sysEng);
                if (oa != null) {
                    result.add((BlockArchitecture)oa);
                }
            } else if (anArchitecture instanceof LogicalArchitecture) {
                SystemAnalysis sa = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng);
                if (sa != null) {
                    result.add((BlockArchitecture)sa);
                }
            } else if (anArchitecture instanceof PhysicalArchitecture) {
                LogicalArchitecture la = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng);
                if (la != null) {
                    result.add((BlockArchitecture)la);
                }
            } else if (anArchitecture instanceof EPBSArchitecture && (pa = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng)) != null) {
                result.add((BlockArchitecture)pa);
            }
        }
        return result;
    }

    public static List<EObject> getAllConstraints(EObject anElement) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (anElement == null) {
            return result;
        }
        for (EObject obj : EObjectExt.getAll((EObject)anElement, (EClass)CapellacorePackage.Literals.CONSTRAINT)) {
            result.add(obj);
        }
        return result;
    }

    public static enum Type {
        OA,
        SA,
        LA,
        PA,
        EPBS;

    }
}

