/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Relationship;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.communication.CommunicationFactory;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;

public class ComponentExt {
    public static void addImplementedInterface(Component component, Interface interf) {
        if (component != null && interf != null && !ComponentExt.getImplementedInterfaces(component).contains(interf)) {
            InterfaceImplementation impl = CsFactory.eINSTANCE.createInterfaceImplementation();
            impl.setImplementedInterface(interf);
            component.getOwnedInterfaceImplementations().add((Object)impl);
        }
    }

    public static void addProvidedInterface(Component component, Interface interf) {
        ComponentPort stdPort = null;
        if (component != null && interf != null) {
            for (Partition partition : component.getOwnedPartitions()) {
                if (!(partition instanceof ComponentPort)) continue;
                stdPort = (ComponentPort)partition;
                break;
            }
            if (stdPort == null) {
                stdPort = PortExt.createStandardPort();
                component.getOwnedFeatures().add((Object)stdPort);
            }
            stdPort.getProvidedInterfaces().add((Object)interf);
        }
    }

    public static void addRequiredInterface(Component component, Interface interf) {
        ComponentPort stdPort = null;
        if (component != null && interf != null) {
            for (Partition partition : component.getOwnedPartitions()) {
                if (!(partition instanceof ComponentPort)) continue;
                stdPort = (ComponentPort)partition;
                break;
            }
            if (stdPort == null) {
                stdPort = PortExt.createStandardPort();
                component.getOwnedFeatures().add((Object)stdPort);
            }
            stdPort.getRequiredInterfaces().add((Object)interf);
        }
    }

    public static void addUsedInterface(Component component, Interface interf) {
        if (component != null && interf != null && !ComponentExt.getUsedInterfaces(component).contains(interf)) {
            InterfaceUse use = CsFactory.eINSTANCE.createInterfaceUse();
            use.setUsedInterface(interf);
            component.getOwnedInterfaceUses().add((Object)use);
        }
    }

    public static void addCommunicationLink(Component component, CommunicationLink communicationLink) {
        if (component != null && communicationLink != null && !ComponentExt.getExchangeItems(component).contains(communicationLink.getExchangeItem())) {
            CommunicationLink lnk = CommunicationFactory.eINSTANCE.createCommunicationLink();
            lnk.setKind(communicationLink.getKind());
            lnk.setProtocol(communicationLink.getProtocol());
            lnk.setExchangeItem(communicationLink.getExchangeItem());
            component.getOwnedCommunicationLinks().add((Object)lnk);
        }
    }

    public static List<AbstractExchangeItem> getExchangeItems(Component component) {
        ArrayList<AbstractExchangeItem> result = new ArrayList<AbstractExchangeItem>();
        if (component != null) {
            for (CommunicationLink lnk : component.getOwnedCommunicationLinks()) {
                ExchangeItem exchangeItem = lnk.getExchangeItem();
                if (exchangeItem == null) continue;
                result.add((AbstractExchangeItem)exchangeItem);
            }
        }
        return result;
    }

    public static Set<AbstractExchangeItem> getAllocatedFunctionExchangeItems(Component component) {
        Set<Object> componentFunctionExchangeItems = new HashSet<AbstractExchangeItem>();
        Set allocatedFunctions = (Set)ComponentExt.getAllocatedFunctions(component);
        for (AbstractFunction abstractFunction : allocatedFunctions) {
            componentFunctionExchangeItems = (Set)AbstractFunctionExt.getAllExchangeItems(abstractFunction);
        }
        return componentFunctionExchangeItems;
    }

    public static void removeCommunicationLink(Component component, CommunicationLink communicationLink) {
        CommunicationLink link = null;
        if (communicationLink != null) {
            ListIterator it = component.getOwnedCommunicationLinks().listIterator();
            while (it.hasNext()) {
                CommunicationLink lnk = (CommunicationLink)it.next();
                if (!lnk.getExchangeItem().equals(communicationLink.getExchangeItem()) || !lnk.getProtocol().equals((Object)communicationLink.getProtocol()) || !lnk.getKind().equals((Object)communicationLink.getKind())) continue;
                link = lnk;
            }
        }
        if (link != null) {
            link.destroy();
        }
    }

    public static void ensureUseAndImplementsForOperation(SequenceMessage message, ExchangeItemAllocation selectedOperation, boolean portStrategie, EObject targetOnExchangeItem) {
        ComponentPort port;
        AbstractInstance roleSource = message.getSendingEnd() == null ? null : message.getSendingEnd().getCovered().getRepresentedInstance();
        AbstractInstance roleTarget = message.getReceivingEnd() == null ? null : message.getReceivingEnd().getCovered().getRepresentedInstance();
        Component src = null;
        Component tgt = null;
        if (roleSource != null && roleSource.getAbstractType() instanceof Component) {
            src = (Component)roleSource.getAbstractType();
        }
        if (roleTarget != null && roleTarget.getAbstractType() instanceof Component) {
            tgt = (Component)roleTarget.getAbstractType();
        }
        if ((src == null || tgt == null) && roleTarget instanceof ExchangeItemInstance && (targetOnExchangeItem instanceof Execution || targetOnExchangeItem instanceof InstanceRole) && MessageKind.SYNCHRONOUS_CALL == message.getKind()) {
            Component temp = src;
            src = tgt;
            tgt = temp;
        }
        Interface interf = selectedOperation.getAllocatingInterface();
        HashSet<? extends Interface> allUsedInterfaces = new HashSet<Interface>();
        for (Component comp : ComponentExt.getAllAncestors(src)) {
            allUsedInterfaces.addAll((Collection<? extends Interface>)comp.getUsedInterfaces());
            for (Feature f : comp.getOwnedFeatures()) {
                if (!(f instanceof ComponentPort)) continue;
                ComponentPort port2 = (ComponentPort)f;
                allUsedInterfaces.addAll((Collection<? extends Interface>)port2.getRequiredInterfaces());
            }
        }
        HashSet<? extends Interface> allImplementedInterfaces = new HashSet<Interface>();
        for (Component comp : ComponentExt.getAllAncestors(tgt)) {
            allImplementedInterfaces.addAll((Collection<? extends Interface>)comp.getImplementedInterfaces());
            for (Feature f : comp.getOwnedFeatures()) {
                if (!(f instanceof ComponentPort)) continue;
                ComponentPort port3 = (ComponentPort)f;
                allImplementedInterfaces.addAll((Collection<? extends Interface>)port3.getProvidedInterfaces());
            }
        }
        allUsedInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(allUsedInterfaces));
        allImplementedInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(allImplementedInterfaces));
        if (src != null && !allUsedInterfaces.contains(interf)) {
            if (portStrategie) {
                port = FaFactory.eINSTANCE.createComponentPort("Requires " + interf.getName());
                port.getRequiredInterfaces().add((Object)interf);
                src.getOwnedFeatures().add((Object)port);
            } else {
                InterfaceUse usage = CsFactory.eINSTANCE.createInterfaceUse();
                src.getOwnedInterfaceUses().add((Object)usage);
                usage.setUsedInterface(interf);
            }
        }
        if (tgt != null && !allImplementedInterfaces.contains(interf)) {
            if (portStrategie) {
                port = FaFactory.eINSTANCE.createComponentPort("Provides " + interf.getName());
                port.getProvidedInterfaces().add((Object)interf);
                tgt.getOwnedFeatures().add((Object)port);
            } else {
                InterfaceImplementation impl = CsFactory.eINSTANCE.createInterfaceImplementation();
                tgt.getOwnedInterfaceImplementations().add((Object)impl);
                impl.setImplementedInterface(interf);
            }
        }
    }

    public static List<Component> getAllAncestors(Component component) {
        ArrayList<Component> result = new ArrayList<Component>();
        Object container = component;
        while (container != null) {
            EList parents;
            if (container instanceof Component) {
                result.add((Component)container);
            }
            container = (parents = container.getSuper()).size() == 0 ? null : (GeneralizableElement)parents.get(0);
        }
        return result;
    }

    public static List<Part> getAllComponentInstances(Component cpnt) {
        ArrayList<Part> instList = new ArrayList<Part>();
        for (EObject obj : EObjectExt.getAll((EObject)cpnt, (EClass)CsPackage.Literals.PART)) {
            instList.add((Part)obj);
        }
        return instList;
    }

    public static List<Interface> getAllImplementedAndProvidedInterfaces(Component cpnt) {
        ArrayList<Interface> implementedAndProvidedItf = new ArrayList<Interface>();
        if (cpnt != null) {
            List superComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cpnt);
            superComponents.add(cpnt);
            for (GeneralizableElement element : superComponents) {
                if (!(element instanceof Component)) continue;
                for (InterfaceImplementation impl : ((Component)element).getImplementedInterfaceLinks()) {
                    Interface itf = impl.getImplementedInterface();
                    if (itf == null || implementedAndProvidedItf.contains(itf)) continue;
                    implementedAndProvidedItf.add(itf);
                    for (GeneralizableElement elt : GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)itf)) {
                        if (implementedAndProvidedItf.contains(elt)) continue;
                        implementedAndProvidedItf.add((Interface)elt);
                    }
                }
                for (Interface abstractItf : ((Component)element).getProvidedInterfaces()) {
                    if (implementedAndProvidedItf.contains(abstractItf)) continue;
                    implementedAndProvidedItf.add(abstractItf);
                    for (GeneralizableElement elt : GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)abstractItf)) {
                        if (implementedAndProvidedItf.contains(elt)) continue;
                        implementedAndProvidedItf.add((Interface)elt);
                    }
                }
            }
        }
        return implementedAndProvidedItf;
    }

    public static List<Interface> getAllImplementedInterfaces(Component cpnt) {
        ArrayList<Interface> implementedInterfaces = new ArrayList<Interface>();
        if (cpnt != null) {
            List superComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cpnt);
            superComponents.add(cpnt);
            for (GeneralizableElement element : superComponents) {
                if (!(element instanceof Component)) continue;
                for (InterfaceImplementation impl : ((Component)element).getImplementedInterfaceLinks()) {
                    Interface itf = impl.getImplementedInterface();
                    if (itf == null || implementedInterfaces.contains(itf)) continue;
                    implementedInterfaces.add(itf);
                }
            }
        }
        return implementedInterfaces;
    }

    public static List<Relationship> getAllIncomingRelationships(Component cpnt) {
        ArrayList<Relationship> ret = new ArrayList<Relationship>();
        return ret;
    }

    public static List<Relationship> getAllOutgoingRelationships(Component cpnt) {
        ArrayList<Relationship> ret = new ArrayList<Relationship>();
        ret.addAll((Collection<Relationship>)cpnt.getUsedInterfaceLinks());
        ret.addAll((Collection<Relationship>)cpnt.getImplementedInterfaceLinks());
        return ret;
    }

    public static List<Interface> getAllProvidedInterfaces(Component cpnt) {
        ArrayList<Interface> requiredItf = new ArrayList<Interface>();
        if (cpnt != null) {
            List superComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cpnt);
            superComponents.add(cpnt);
            for (GeneralizableElement element : superComponents) {
                if (!(element instanceof Component)) continue;
                for (Interface abstractItf : ((Component)element).getProvidedInterfaces()) {
                    if (requiredItf.contains(abstractItf)) continue;
                    requiredItf.add(abstractItf);
                }
            }
        }
        return requiredItf;
    }

    public static Collection<ComponentExchange> getAllRelatedComponentExchange(Part part) {
        return ComponentExt.getAllRelatedComponentExchange(part, false);
    }

    public static Collection<ComponentExchange> getAllRelatedComponentExchange(Part part, boolean includePortOfType) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        if (part.getAbstractType() != null && part.getAbstractType() instanceof Component) {
            EList informationFlows = part.getInformationFlows();
            for (AbstractInformationFlow abstractInformationFlow : informationFlows) {
                if (!(abstractInformationFlow instanceof ComponentExchange)) continue;
                result.add((ComponentExchange)abstractInformationFlow);
            }
            for (ComponentExchangeEnd end : FunctionalExt.getRelatedComponentExchangeEnds((Part)part)) {
                EObject owner = end.eContainer();
                if (!(owner instanceof ComponentExchange)) continue;
                result.add((ComponentExchange)owner);
            }
            if (includePortOfType) {
                List<ComponentPort> ownedComponentPort = ComponentExt.getOwnedComponentPort((Component)part.getAbstractType());
                for (ComponentPort componentPort : ownedComponentPort) {
                    result.addAll((Collection<ComponentExchange>)componentPort.getComponentExchanges());
                }
            }
        }
        return result;
    }

    public static Collection<ComponentExchange> getAllRelatedComponentExchange(Component component) {
        return ComponentExt.getAllRelatedComponentExchange(component, true);
    }

    public static Collection<ComponentExchange> getAllRelatedComponentExchange(Component component, boolean addRelatedOfParts) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        List<ComponentPort> ownedComponentPort = ComponentExt.getOwnedComponentPort(component);
        for (ComponentPort componentPort : ownedComponentPort) {
            result.addAll((Collection<ComponentExchange>)componentPort.getComponentExchanges());
        }
        if (component instanceof Entity) {
            for (AbstractInformationFlow flow : ((Entity)component).getInformationFlows()) {
                if (!(flow instanceof CommunicationMean)) continue;
                result.add((ComponentExchange)((CommunicationMean)flow));
            }
        }
        if (addRelatedOfParts) {
            EList abstractTypedElements = component.getAbstractTypedElements();
            for (AbstractTypedElement abstractTypedElement : abstractTypedElements) {
                if (!(abstractTypedElement instanceof Part)) continue;
                Part part = (Part)abstractTypedElement;
                result.addAll(ComponentExt.getAllRelatedComponentExchange(part, false));
            }
        }
        return result;
    }

    public static Collection<ComponentExchange> getAllRelatedConnectionByKind(Component component, ComponentExchangeKind kind) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        if (component == null) {
            return null;
        }
        Collection<ComponentExchange> allRelatedConnection = ComponentExt.getAllRelatedComponentExchange(component);
        result.addAll(allRelatedConnection);
        if (kind != null) {
            for (ComponentExchange connection : allRelatedConnection) {
                if (connection.getKind() == kind) continue;
                result.remove(connection);
            }
        }
        return result;
    }

    public static List<Interface> getAllRequiredInterfaces(Component cpnt) {
        ArrayList<Interface> providedItf = new ArrayList<Interface>();
        if (cpnt != null) {
            List superComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cpnt);
            superComponents.add(cpnt);
            for (GeneralizableElement element : superComponents) {
                if (!(element instanceof Component)) continue;
                for (Interface abstractItf : ((Component)element).getRequiredInterfaces()) {
                    if (providedItf.contains(abstractItf)) continue;
                    providedItf.add(abstractItf);
                }
            }
        }
        return providedItf;
    }

    public static List<CapellaElement> getAllStatesAndModesFromComponent(Component comp) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(1);
        if (comp != null) {
            EList ownedStateMachines = comp.getOwnedStateMachines();
            for (StateMachine stateMachine : ownedStateMachines) {
                TreeIterator allContents = EcoreUtil.getAllContents((EObject)stateMachine, (boolean)false);
                while (allContents.hasNext()) {
                    Object object = allContents.next();
                    if (!(object instanceof State)) continue;
                    result.add((CapellaElement)object);
                }
            }
        }
        return result;
    }

    public static Collection<Part> getAllSubUsedParts(Component component, boolean useDeploymentLinks) {
        HashSet<Part> result = new HashSet<Part>();
        for (Partition partition : component.getRepresentingPartitions()) {
            if (!(partition instanceof Part)) continue;
            result.add((Part)partition);
        }
        return ComponentExt.getAllSubUsedParts(result, useDeploymentLinks);
    }

    public static Collection<Part> getAllSubUsedParts(Part part, boolean useDeploymentLinks) {
        return ComponentExt.getAllSubUsedParts(Collections.singletonList(part), useDeploymentLinks);
    }

    private static Collection<Part> getAllSubUsedParts(Collection<Part> parts, boolean useDeploymentLinks) {
        HashSet<Part> comps = new HashSet<Part>();
        ArrayList<Part> visited = new ArrayList<Part>();
        LinkedList<Part> subs = new LinkedList<Part>();
        LinkedList<Part> initial = new LinkedList<Part>();
        initial.addAll(parts);
        subs.addAll(parts);
        while (subs.size() > 0) {
            List<Part> internal;
            Part sub = (Part)subs.removeFirst();
            if (visited.contains(sub)) continue;
            visited.add(sub);
            if (sub.getAbstractType() != null && sub.getAbstractType() instanceof Component) {
                internal = ComponentExt.getSubParts((Component)sub.getAbstractType(), false);
                comps.addAll(internal);
                subs.addAll(internal);
            }
            if (!useDeploymentLinks) continue;
            internal = PartExt.getDeployedParts(sub);
            comps.addAll(internal);
            subs.addAll(internal);
        }
        return comps;
    }

    public static Collection<Component> getAllSubUsedComponents(Component component) {
        HashSet<Component> comps = new HashSet<Component>();
        ArrayList<Component> visited = new ArrayList<Component>();
        LinkedList<Component> subs = new LinkedList<Component>();
        subs.add(component);
        while (subs.size() > 0) {
            Component sub = (Component)subs.removeFirst();
            if (visited.contains(sub)) continue;
            visited.add(sub);
            List<Component> internal = ComponentExt.getSubUsedComponents(sub);
            comps.addAll(internal);
            subs.addAll(internal);
        }
        return comps;
    }

    public static List<Interface> getAllUsedAndRequiredInterfaces(Component cpnt) {
        ArrayList<Interface> usedAndRequiredItf = new ArrayList<Interface>();
        if (cpnt != null) {
            List superComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cpnt);
            superComponents.add(cpnt);
            for (GeneralizableElement element : superComponents) {
                if (!(element instanceof Component)) continue;
                for (InterfaceUse use : ((Component)element).getUsedInterfaceLinks()) {
                    Interface itf = use.getUsedInterface();
                    if (itf == null || usedAndRequiredItf.contains(itf)) continue;
                    usedAndRequiredItf.add(itf);
                    for (GeneralizableElement elt : GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)itf)) {
                        if (usedAndRequiredItf.contains(elt)) continue;
                        usedAndRequiredItf.add((Interface)elt);
                    }
                }
                for (Interface abstractItf : ((Component)element).getRequiredInterfaces()) {
                    if (usedAndRequiredItf.contains(abstractItf)) continue;
                    usedAndRequiredItf.add(abstractItf);
                    for (GeneralizableElement elt : GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)abstractItf)) {
                        if (usedAndRequiredItf.contains(elt)) continue;
                        usedAndRequiredItf.add((Interface)elt);
                    }
                }
            }
        }
        return usedAndRequiredItf;
    }

    public static List<Interface> getAllUsedInterfaces(Component cpnt) {
        ArrayList<Interface> usedInterfaces = new ArrayList<Interface>();
        if (cpnt != null) {
            List superComponents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)cpnt);
            superComponents.add(cpnt);
            for (GeneralizableElement element : superComponents) {
                if (!(element instanceof Component)) continue;
                for (InterfaceUse use : ((Component)element).getUsedInterfaceLinks()) {
                    Interface itf = use.getUsedInterface();
                    if (itf == null || usedInterfaces.contains(itf)) continue;
                    usedInterfaces.add(itf);
                }
            }
        }
        return usedInterfaces;
    }

    public static Collection<Component> getAvailableComponentsByNamespace(EObject component) {
        HashSet<Component> components = new HashSet<Component>();
        EObject rootComponent = component;
        while (rootComponent != null) {
            if (rootComponent instanceof BlockArchitecture) {
                components.addAll(ComponentExt.getSubDefinedComponents((BlockArchitecture)rootComponent));
            } else if (rootComponent instanceof Component) {
                components.addAll(ComponentExt.getSubDefinedComponents((Component)rootComponent));
            }
            rootComponent = rootComponent.eContainer();
        }
        return components;
    }

    public static Collection<EObject> getAvailableComponentsByNamespaceOfParts(Deque<EObject> ownerParts) {
        HashSet<EObject> components = new HashSet<EObject>();
        while (ownerParts.size() > 0) {
            EObject owner = ownerParts.removeFirst();
            EObject parent = owner;
            if (parent == null || components.contains(parent)) continue;
            if (parent instanceof BlockArchitecture) {
                BlockArchitecture parentArchitecture = (BlockArchitecture)parent;
                components.addAll(ComponentExt.getSubDefinedComponents(parentArchitecture));
                components.addAll(ComponentExt.getSubDefinedActors(parentArchitecture));
            } else if (parent instanceof Component) {
                Component parentComponent = (Component)parent;
                components.add((EObject)parentComponent);
                components.addAll(ComponentExt.getSubDefinedComponents(parentComponent));
            }
            ownerParts.addLast(parent.eContainer());
        }
        return components;
    }

    public static Collection<EObject> getAvailableComponentsByNamespaceOfParts(Part part) {
        LinkedList<EObject> ownerParts = new LinkedList<EObject>();
        ownerParts.add((EObject)part);
        return ComponentExt.getAvailableComponentsByNamespaceOfParts(ownerParts);
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    public static Component getCommonComponentAncestor(Component c1, Component c2) {
        ancestor = c1;
        if (!ComponentExt.isComponentAncestor(c2, ancestor)) ** GOTO lbl6
        return c2;
        while (ancestor.getAbstractTypedElements().get(0) instanceof Part && (parentAncestor = ComponentExt.getDirectParent((Partition)(ancestorPart = (Part)ancestor.getAbstractTypedElements().get(0)))) instanceof Component) {
            ancestor = parentAncestor;
lbl6:
            // 2 sources

            if (!ComponentExt.isComponentAncestor(ancestor, c2)) continue;
        }
        return ancestor;
    }

    public static List<Component> getComponentsFromComponent(Component component) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Object obj : component.eContents()) {
            if (obj instanceof Component) {
                list.add((Component)obj);
                continue;
            }
            if (!(obj instanceof Structure)) continue;
            for (Object content : ((Structure)obj).eContents()) {
                if (!(content instanceof Component)) continue;
                list.add((Component)content);
                list.addAll(ComponentExt.getComponentsFromComponent((Component)content));
            }
        }
        return list;
    }

    public static List<Part> getDecompositionPartInvolved(Component lc) {
        ArrayList<Part> decompPartInvolved = new ArrayList<Part>();
        for (Partition partition : lc.getOwnedPartitions()) {
            AbstractType currentLc = partition.getAbstractType();
            if (!(currentLc instanceof Component) || decompPartInvolved.contains(partition)) continue;
            decompPartInvolved.add((Part)partition);
        }
        return decompPartInvolved;
    }

    public static List<Component> getDirectCommonParent(Component componentA, Component componentB) {
        ArrayList<Component> lstDirCommonParents = new ArrayList<Component>();
        List<Component> parentsComponents_A = ComponentExt.getDirectParents(componentA);
        for (Component parentB : ComponentExt.getDirectParents(componentB)) {
            if (!parentsComponents_A.contains(parentB)) continue;
            lstDirCommonParents.add(parentB);
        }
        return lstDirCommonParents;
    }

    public static Component getDirectParent(Partition part) {
        return (Component)EcoreUtil2.getFirstContainer((EObject)part, (EClass)CsPackage.Literals.COMPONENT);
    }

    public static List<Component> getDirectParents(Component component) {
        ArrayList<Component> parentsComponents = new ArrayList<Component>();
        for (Partition partition : component.getRepresentingPartitions()) {
            Component partitionanableElt = (Component)EcoreUtil2.getFirstContainer((EObject)partition, (EClass)CsPackage.Literals.COMPONENT);
            parentsComponents.add(partitionanableElt);
        }
        return parentsComponents;
    }

    public static EObject getFirstCommonComponentAncestor(EObject source, EObject target, boolean useDeployementLinks) {
        if (source == null || target == null) {
            return null;
        }
        EObject src = source;
        EObject tgt = target;
        EObject result = null;
        LinkedList<EObject> sourceList = new LinkedList<EObject>();
        HashSet<EObject> sourceListVisited = new HashSet<EObject>();
        ArrayList<EObject> targetList = new ArrayList<EObject>();
        HashSet<EObject> targetListVisited = new HashSet<EObject>();
        int i = 0;
        targetList.add(tgt);
        while (i < targetList.size()) {
            EObject targetA = (EObject)targetList.get(i);
            targetListVisited.add(targetA);
            ++i;
            for (EObject related : ComponentExt.getRelatedElementsForCommonAncestor(targetA, useDeployementLinks)) {
                if (related == null || targetListVisited.contains(related)) continue;
                targetList.add(related);
            }
        }
        sourceList.add(src);
        while (sourceList.size() > 0) {
            EObject sourceContainer = (EObject)sourceList.removeFirst();
            if (sourceContainer == null) continue;
            sourceListVisited.add(sourceContainer);
            for (EObject targetContainer : targetList) {
                if (sourceContainer != targetContainer) continue;
                result = sourceContainer;
                break;
            }
            if (result != null) break;
            for (EObject related : ComponentExt.getRelatedElementsForCommonAncestor(sourceContainer, useDeployementLinks)) {
                if (sourceListVisited.contains(related)) continue;
                sourceList.add(related);
            }
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Port) {
            result = result.eContainer();
        }
        if (result instanceof Part) {
            result = ((Part)result).getAbstractType();
        }
        return result;
    }

    public static EObject getFirstCommonComponentAncestor(EObject source, EObject target) {
        return ComponentExt.getFirstCommonComponentAncestor(source, target, false);
    }

    public static Component getFirstCommonComponentAncestor(List<Component> components) {
        if (components == null || components.isEmpty()) {
            return null;
        }
        Component commonAncestor = components.get(0);
        int i = 1;
        while (i < components.size()) {
            if ((commonAncestor = (Component)ComponentExt.getFirstCommonComponentAncestor((EObject)commonAncestor, (EObject)components.get(i), true)) == null) {
                return null;
            }
            ++i;
        }
        return commonAncestor;
    }

    public static List<Interface> getImplementedAndProvidedInterfaces(Component component) {
        List<Interface> implementedAndProvidedItf = ComponentExt.getImplementedInterfaces(component);
        for (Interface itfProvided : component.getProvidedInterfaces()) {
            if (implementedAndProvidedItf.contains(itfProvided)) continue;
            implementedAndProvidedItf.add(itfProvided);
        }
        return implementedAndProvidedItf;
    }

    public static List<Interface> getImplementedInterfaces(Component component) {
        ArrayList<Interface> implementedInterfaces = new ArrayList<Interface>();
        if (component != null) {
            EList implementationSet = component.getImplementedInterfaceLinks();
            for (InterfaceImplementation impl : implementationSet) {
                Interface itf = impl.getImplementedInterface();
                if (itf == null) continue;
                implementedInterfaces.add(itf);
            }
        }
        return implementedInterfaces;
    }

    public static List<Interface> getImplementedInterfacesFiltered(Component currentComp, Component component) {
        ArrayList<Interface> interfaceList = new ArrayList<Interface>();
        boolean isCheckRequired = !component.equals(currentComp);
        for (InterfaceImplementation interfaceImpl : currentComp.getImplementedInterfaceLinks()) {
            Interface inter = interfaceImpl.getImplementedInterface();
            if (inter == null || isCheckRequired && ComponentExt.isImplementingInterface(component, inter)) continue;
            interfaceList.add(inter);
        }
        return interfaceList;
    }

    public static DataPkg getDataPkg(Component component, boolean create) {
        if (component.getOwnedInterfacePkg() == null && create) {
            DataPkg pkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
            component.setOwnedDataPkg(pkg);
        }
        return component.getOwnedDataPkg();
    }

    public static DataPkg getDataPkg(Component component) {
        return ComponentExt.getDataPkg(component, true);
    }

    public static InterfacePkg getInterfacePkg(Component component, boolean create) {
        if (component.getOwnedInterfacePkg() == null && create) {
            InterfacePkg pkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
            component.setOwnedInterfacePkg(pkg);
        }
        return component.getOwnedInterfacePkg();
    }

    public static InterfacePkg getInterfacePkg(Component component) {
        return ComponentExt.getInterfacePkg(component, true);
    }

    public static List<Interface> getInterfacesFromComponentParentHierarchy(Component component) {
        ArrayList<Interface> list = new ArrayList<Interface>();
        BlockArchitecture arch = ComponentExt.getRootBlockArchitecture((ModelElement)component);
        if (arch != null) {
            list.addAll(InterfacePkgExt.getAllInterfaces(arch.getOwnedInterfacePkg()));
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(arch));
        }
        for (Component ancestor : ComponentExt.getComponentAncestors(component)) {
            list.addAll(InterfacePkgExt.getAllInterfaces(ancestor.getOwnedInterfacePkg()));
        }
        return list;
    }

    public static List<ComponentPort> getOwnedComponentPort(Component component) {
        ArrayList<ComponentPort> returnedList = new ArrayList<ComponentPort>();
        for (Feature aFeature : component.getOwnedFeatures()) {
            if (!(aFeature instanceof ComponentPort)) continue;
            returnedList.add((ComponentPort)aFeature);
        }
        return returnedList;
    }

    public static List<ComponentPort> getOwnedFlowPort(Component component) {
        ArrayList<ComponentPort> returnedList = new ArrayList<ComponentPort>();
        for (Feature aFeature : component.getOwnedFeatures()) {
            if (!PortExt.isFlowPort((EObject)aFeature)) continue;
            returnedList.add((ComponentPort)aFeature);
        }
        return returnedList;
    }

    public static List<ComponentPort> getOwnedInFlowPort(Component component) {
        ArrayList<ComponentPort> returnedList = new ArrayList<ComponentPort>();
        for (Feature aFeature : component.getOwnedFeatures()) {
            if (!PortExt.isIn((ComponentPort)aFeature) || !PortExt.isFlowPort((EObject)aFeature)) continue;
            returnedList.add((ComponentPort)aFeature);
        }
        return returnedList;
    }

    public static List<ComponentPort> getOwnedOutFlowPort(Component component) {
        ArrayList<ComponentPort> returnedList = new ArrayList<ComponentPort>();
        for (Feature aFeature : component.getOwnedFeatures()) {
            if (!(aFeature instanceof ComponentPort) || !PortExt.isOut((ComponentPort)aFeature) || !PortExt.isFlowPort((EObject)aFeature)) continue;
            returnedList.add((ComponentPort)aFeature);
        }
        return returnedList;
    }

    public static List<PhysicalPort> getOwnedPhysicalPort(Component component) {
        ArrayList<PhysicalPort> returnedList = new ArrayList<PhysicalPort>();
        for (Feature aFeature : component.getOwnedFeatures()) {
            if (!(aFeature instanceof PhysicalPort)) continue;
            returnedList.add((PhysicalPort)aFeature);
        }
        return returnedList;
    }

    public static boolean hasPhysicalPort(Component component) {
        return !ComponentExt.getOwnedPhysicalPort(component).isEmpty();
    }

    public static List<Port> getOwnedPort(Component component) {
        ArrayList<Port> returnedList = new ArrayList<Port>();
        for (Feature aFeature : component.getOwnedFeatures()) {
            if (!(aFeature instanceof Port)) continue;
            returnedList.add((Port)aFeature);
        }
        return returnedList;
    }

    public static Collection<ComponentExchange> getAllOwnedComponentExchanges(Component modelElement) {
        ArrayList<ComponentExchange> instList = new ArrayList<ComponentExchange>();
        for (EObject obj : EObjectExt.getAll((EObject)modelElement, (EClass)FaPackage.Literals.COMPONENT_EXCHANGE)) {
            instList.add((ComponentExchange)obj);
        }
        return instList;
    }

    public static List<ComponentPort> getOwnedStandardPort(Component component) {
        ArrayList<ComponentPort> returnedList = new ArrayList<ComponentPort>();
        for (Feature aFeature : component.getOwnedFeatures()) {
            if (!PortExt.isStandardPort(aFeature)) continue;
            returnedList.add((ComponentPort)aFeature);
        }
        return returnedList;
    }

    @Deprecated
    public static Component getParent(Component component) {
        Component parent = null;
        for (Partition aPartition : component.getRepresentingPartitions()) {
            if (!(aPartition instanceof Part)) continue;
            Component ownerElement = ComponentExt.getDirectParent(aPartition);
            if (ownerElement == null || !(ownerElement instanceof Component)) {
                return parent;
            }
            return ownerElement;
        }
        return parent;
    }

    public static Collection<Component> getComponentAncestors(Component component) {
        HashSet<Component> result = new HashSet<Component>();
        for (Partition partition : component.getRepresentingPartitions()) {
            if (!(partition instanceof Part)) continue;
            for (Part componentAncestor : ComponentExt.getPartAncestors((Part)partition)) {
                if (componentAncestor.getAbstractType() == null || !(componentAncestor.getAbstractType() instanceof Component)) continue;
                result.add((Component)componentAncestor.getAbstractType());
            }
        }
        return result;
    }

    public static Collection<Part> getPartAncestors(Part child) {
        return ComponentExt.getPartAncestors(child, false);
    }

    public static Collection<Part> getPartAncestors(Part child, boolean addGeneralizationOfParents) {
        ArrayList<Part> result = new ArrayList<Part>();
        HashSet<Part> visited = new HashSet<Part>();
        LinkedList<Part> toVisit = new LinkedList<Part>();
        if (child != null) {
            toVisit.add(child);
            while (toVisit.size() > 0) {
                Part pvisit;
                Component parent;
                Partition visit = (Partition)toVisit.removeFirst();
                if (!(visit instanceof Part) || (parent = ComponentExt.getDirectParent((Partition)(pvisit = (Part)visit))) == null || !(parent instanceof PartitionableElement)) continue;
                ArrayList<Component> container = new ArrayList<Component>();
                container.add(parent);
                if (addGeneralizationOfParents && parent instanceof GeneralizableElement) {
                    List list = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)((GeneralizableElement)parent));
                    container.addAll(list);
                }
                for (EObject eObject : container) {
                    if (!(eObject instanceof PartitionableElement)) continue;
                    for (Partition partition : ((PartitionableElement)eObject).getRepresentingPartitions()) {
                        Part part;
                        if (!(partition instanceof Part) || visited.contains(part = (Part)partition)) continue;
                        toVisit.addLast(part);
                        result.add(part);
                        visited.add(part);
                    }
                }
                for (DeploymentTarget deploymentTarget : PartExt.getDeployingElements(pvisit)) {
                    Part part;
                    if (!(deploymentTarget instanceof Part) || visited.contains(part = (Part)deploymentTarget)) continue;
                    toVisit.addLast(part);
                    result.add(part);
                    visited.add(part);
                }
            }
        }
        return result;
    }

    private static List<EObject> getRelatedElementsForCommonAncestor(EObject eobject, boolean useDeployementLinks) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        if (eobject instanceof Component) {
            for (Partition part : ((Component)eobject).getRepresentingPartitions()) {
                result.add((EObject)part);
            }
        } else if (eobject instanceof Port) {
            result.add(EcoreUtil2.getFirstContainer((EObject)eobject, (EClass)CsPackage.Literals.COMPONENT));
        } else if (eobject instanceof Part) {
            List<DeploymentTarget> elements = PartExt.getDeployingElements((Part)eobject);
            if (useDeployementLinks && elements.size() > 0) {
                for (EObject eObject : elements) {
                    result.add(eObject);
                }
            } else {
                result.add(EcoreUtil2.getFirstContainer((EObject)eobject, (EClass)CsPackage.Literals.COMPONENT));
            }
        }
        return result;
    }

    public static Collection<FunctionalExchange> getRelatedFunctionalExchanges(Component component) {
        HashSet<FunctionalExchange> functionalExchanges = new HashSet<FunctionalExchange>();
        for (Component cpnt : ComponentExt.getAllSubUsedComponents(component)) {
            for (AbstractFunction af : cpnt.getAllocatedFunctions()) {
                functionalExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)af));
                functionalExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)af));
            }
        }
        return functionalExchanges;
    }

    public static Collection<AbstractFunction> getAllocatedFunctions(Component component) {
        HashSet<AbstractFunction> functionalExchanges = new HashSet<AbstractFunction>();
        EList allocatedFunctions = component.getAllocatedFunctions();
        Iterator iterator = allocatedFunctions.iterator();
        while (iterator.hasNext()) {
            AbstractFunction abstractFunction2;
            AbstractFunction abstractFunction = abstractFunction2 = (AbstractFunction)iterator.next();
            functionalExchanges.add(abstractFunction);
        }
        return functionalExchanges;
    }

    public static Collection<Interface> getRelatedInterfaces(Component component) {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (component != null) {
            interfaces.addAll(ComponentExt.getImplementedAndProvidedInterfaces(component));
            interfaces.addAll(ComponentExt.getUsedAndRequiredInterfaces(component));
        }
        return interfaces;
    }

    public static List<Interface> getRelatedInterfacesFromReference(Component cpnt, EReference reference) {
        ArrayList<Interface> providedItf = new ArrayList<Interface>();
        if (cpnt != null) {
            EList list = (EList)cpnt.eGet((EStructuralFeature)reference);
            for (Interface itf : list) {
                if (providedItf.contains(itf)) continue;
                providedItf.add(itf);
            }
        }
        return providedItf;
    }

    public static List<Interface> getRequiredInterfaces(Component cpnt) {
        ArrayList<Interface> requiredItf = new ArrayList<Interface>();
        if (cpnt != null) {
            for (Interface itf : cpnt.getRequiredInterfaces()) {
                if (requiredItf.contains(itf)) continue;
                requiredItf.add(itf);
            }
        }
        return requiredItf;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)modelElement);
    }

    public static Component getRootComponent(Component component) {
        Component rootCpnt = null;
        if (component != null) {
            EObject container = component.eContainer();
            if (container instanceof Component) {
                rootCpnt = (Component)container;
            } else if (container instanceof Structure) {
                rootCpnt = StructureExt.getRootComponent((Structure)container);
            }
        }
        return rootCpnt;
    }

    public static ComponentArchitecture getRootComponentArchitecture(Component component) {
        ComponentArchitecture compArch = null;
        if (component != null) {
            EObject container = component.eContainer();
            if (container instanceof Component) {
                compArch = ComponentExt.getRootComponentArchitecture((Component)container);
            } else if (container instanceof ComponentArchitecture) {
                compArch = (ComponentArchitecture)container;
            } else if (container instanceof Structure) {
                compArch = StructureExt.getRootComponentArchitecture((Structure)container);
            }
        }
        return compArch;
    }

    public static List<? extends Component> getSubDefinedActors(BlockArchitecture architecture) {
        ArrayList<Component> elements = new ArrayList<Component>();
        Component component = BlockArchitectureExt.getContext(architecture, false);
        if (component != null) {
            for (Component compo : ComponentExt.getSubDefinedComponents(component)) {
                if (!(compo instanceof AbstractActor)) continue;
                elements.add(compo);
            }
        }
        if (architecture instanceof SystemAnalysis) {
            elements.addAll(ActorPkgExt.getAllActors((ActorPkg)((SystemAnalysis)architecture).getOwnedActorPkg()));
        } else if (architecture instanceof LogicalArchitecture) {
            elements.addAll(ActorPkgExt.getAllActors((LogicalActorPkg)((LogicalArchitecture)architecture).getOwnedLogicalActorPkg()));
        } else if (architecture instanceof PhysicalArchitecture) {
            elements.addAll(ActorPkgExt.getAllActors((PhysicalActorPkg)((PhysicalArchitecture)architecture).getOwnedPhysicalActorPkg()));
        }
        return elements;
    }

    public static List<Component> getSubDefinedComponents(Component object) {
        ArrayList<Component> elements = new ArrayList<Component>();
        if (object instanceof LogicalComponent) {
            elements.addAll((Collection<Component>)((LogicalComponent)object).getOwnedLogicalComponents());
            for (LogicalComponentPkg pkg : ((LogicalComponent)object).getOwnedLogicalComponentPkgs()) {
                ComponentExt.getSubDefinedComponents(pkg, elements);
            }
        } else if (object instanceof PhysicalComponent) {
            elements.addAll((Collection<Component>)((PhysicalComponent)object).getOwnedPhysicalComponents());
            for (LogicalComponentPkg pkg : ((PhysicalComponent)object).getOwnedPhysicalComponentPkgs()) {
                ComponentExt.getSubDefinedComponents((PhysicalComponentPkg)pkg, elements);
            }
        } else if (object instanceof ConfigurationItem) {
            elements.addAll((Collection<Component>)((ConfigurationItem)object).getOwnedConfigurationItems());
            for (LogicalComponentPkg pkg : ((ConfigurationItem)object).getOwnedConfigurationItemPkgs()) {
                ComponentExt.getSubDefinedComponents((ConfigurationItemPkg)pkg, elements);
            }
        }
        for (Part part : ComponentExt.getSubParts((PartitionableElement)object)) {
            if (part.getOwnedAbstractType() == null || !(part.getOwnedAbstractType() instanceof Component)) continue;
            elements.add((Component)part.getOwnedAbstractType());
            elements.addAll(ComponentExt.getSubDefinedComponents((Component)part.getOwnedAbstractType()));
        }
        return elements;
    }

    private static void getSubDefinedComponents(ConfigurationItemPkg compoPkg, Collection<Component> components) {
        if (compoPkg == null) {
            return;
        }
        components.addAll((Collection<Component>)compoPkg.getOwnedConfigurationItems());
        for (ConfigurationItemPkg pkg : compoPkg.getOwnedConfigurationItemPkgs()) {
            ComponentExt.getSubDefinedComponents(pkg, components);
        }
    }

    private static void getSubDefinedComponents(LogicalComponentPkg compoPkg, Collection<Component> components) {
        if (compoPkg == null) {
            return;
        }
        components.addAll((Collection<Component>)compoPkg.getOwnedLogicalComponents());
        for (LogicalComponentPkg pkg : compoPkg.getOwnedLogicalComponentPkgs()) {
            ComponentExt.getSubDefinedComponents(pkg, components);
        }
    }

    public static List<Component> getSubDefinedComponents(BlockArchitecture object) {
        ArrayList<Component> elements = new ArrayList<Component>();
        Component component = BlockArchitectureExt.getContext(object, false);
        if (component != null) {
            elements.addAll(ComponentExt.getSubDefinedComponents(component));
        }
        if (object instanceof OperationalAnalysis) {
            ComponentExt.getSubDefinedComponents(((OperationalAnalysis)object).getOwnedEntityPkg(), elements);
        }
        if (object instanceof SystemAnalysis) {
            elements.add((Component)((SystemAnalysis)object).getOwnedSystem());
        } else if (object instanceof LogicalArchitecture) {
            elements.add((Component)((LogicalArchitecture)object).getOwnedLogicalComponent());
            ComponentExt.getSubDefinedComponents(((LogicalArchitecture)object).getOwnedLogicalComponentPkg(), elements);
        } else if (object instanceof PhysicalArchitecture) {
            elements.add((Component)((PhysicalArchitecture)object).getOwnedPhysicalComponent());
            ComponentExt.getSubDefinedComponents(((PhysicalArchitecture)object).getOwnedPhysicalComponentPkg(), elements);
        } else if (object instanceof EPBSArchitecture) {
            elements.add((Component)((EPBSArchitecture)object).getOwnedConfigurationItem());
            ComponentExt.getSubDefinedComponents(((EPBSArchitecture)object).getOwnedConfigurationItemPkg(), elements);
        }
        return elements;
    }

    private static void getSubDefinedComponents(EntityPkg entityPkg, Collection<Component> components) {
        if (entityPkg == null) {
            return;
        }
        components.addAll((Collection<Component>)entityPkg.getOwnedEntities());
        for (EntityPkg pkg : entityPkg.getOwnedEntityPkgs()) {
            ComponentExt.getSubDefinedComponents(pkg, components);
        }
    }

    private static void getSubDefinedComponents(PhysicalComponentPkg compoPkg, Collection<Component> components) {
        if (compoPkg == null) {
            return;
        }
        components.addAll((Collection<Component>)compoPkg.getOwnedComponents());
        for (PhysicalComponentPkg pkg : compoPkg.getOwnedPhysicalComponentPkgs()) {
            ComponentExt.getSubDefinedComponents(pkg, components);
        }
    }

    public static List<Component> getSubUsedComponents(Component component) {
        return PartExt.getComponentsOfParts(ComponentExt.getSubParts(component, false));
    }

    public static List<Component> getSubUsedComponents(Component component, boolean useDeploymentLinks) {
        return PartExt.getComponentsOfParts(ComponentExt.getSubParts(component, useDeploymentLinks));
    }

    public static List<Part> getSubParts(PartitionableElement component) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (Partition partition : component.getOwnedPartitions()) {
            if (!(partition instanceof Part)) continue;
            result.add((Part)partition);
        }
        return result;
    }

    public static List<Part> getSubParts(Component component, boolean useDeploymentLinks) {
        ArrayList<Part> result = new ArrayList<Part>();
        if (useDeploymentLinks) {
            for (Partition partition : component.getRepresentingPartitions()) {
                if (!(partition instanceof Part)) continue;
                result.addAll(PartExt.getDeployedParts((Part)partition));
            }
        }
        result.addAll(ComponentExt.getSubParts((PartitionableElement)component));
        return result;
    }

    public static List<Component> getSuperComponents(Component cpnt) {
        ArrayList<Component> superComponents = new ArrayList<Component>();
        for (GeneralizableElement elt : cpnt.getSuper()) {
            if (!(elt instanceof Component)) continue;
            superComponents.add((Component)elt);
        }
        return superComponents;
    }

    public static Collection<Part> getRepresentingParts(Component component) {
        ArrayList<Part> result = new ArrayList<Part>();
        if (component != null) {
            for (Partition partition : component.getRepresentingPartitions()) {
                if (!(partition instanceof Part)) continue;
                result.add((Part)partition);
            }
        }
        return result;
    }

    public static List<Interface> getUsedAndRequiredInterfaces(Component component) {
        List<Interface> usedAndRequiredItf = ComponentExt.getUsedInterfaces(component);
        for (Interface itfRequired : component.getRequiredInterfaces()) {
            if (usedAndRequiredItf.contains(itfRequired)) continue;
            usedAndRequiredItf.add(itfRequired);
        }
        return usedAndRequiredItf;
    }

    public static List<Interface> getUsedInterfaces(Component component) {
        ArrayList<Interface> usedInterfaces = new ArrayList<Interface>();
        if (component != null) {
            EList useSet = component.getUsedInterfaceLinks();
            for (InterfaceUse use : useSet) {
                Interface itf = use.getUsedInterface();
                if (itf == null) continue;
                usedInterfaces.add(itf);
            }
        }
        return usedInterfaces;
    }

    public static List<Interface> getUsedInterfacesFiltered(Component currentComp, Component component) {
        ArrayList<Interface> interfaceList = new ArrayList<Interface>();
        boolean isCheckRequired = !component.equals(currentComp);
        for (InterfaceUse interfaceUse : currentComp.getUsedInterfaceLinks()) {
            Interface inter = interfaceUse.getUsedInterface();
            if (inter == null || isCheckRequired && ComponentExt.isUsingInterface(component, inter)) continue;
            interfaceList.add(inter);
        }
        return interfaceList;
    }

    public static boolean haveDirectCommonParent(Component componentA, Component componentB) {
        List<Component> parentsComponents_A = ComponentExt.getDirectParents(componentA);
        for (Component parentB : ComponentExt.getDirectParents(componentB)) {
            if (!parentsComponents_A.contains(parentB)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnImplementedOrProvidedExchangeItem(Component component, AbstractExchangeItem exchangeItem) {
        List<Interface> itfLst = ComponentExt.getAllImplementedAndProvidedInterfaces(component);
        if (itfLst != null) {
            for (Interface itf : itfLst) {
                if (!itf.getExchangeItems().contains((Object)exchangeItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnUsedOrRequiredExchangeItem(Component component, AbstractExchangeItem exchangeItem) {
        List<Interface> itfLst = ComponentExt.getAllUsedAndRequiredInterfaces(component);
        if (itfLst != null) {
            for (Interface itf : itfLst) {
                if (!itf.getExchangeItems().contains((Object)exchangeItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isComponentAncestor(Component ancestor, Component child) {
        boolean result;
        block16: {
            block19: {
                block18: {
                    block17: {
                        result = false;
                        if (!(ancestor instanceof Entity)) break block17;
                        if (((Entity)ancestor).getSubEntities().isEmpty()) {
                            result = false;
                        } else if (((Entity)ancestor).getSubEntities().contains((Object)child)) {
                            result = true;
                        } else {
                            for (Entity ent : ((Entity)ancestor).getSubEntities()) {
                                if (!ComponentExt.isComponentAncestor((Component)ent, child)) continue;
                                result = true;
                            }
                        }
                        break block16;
                    }
                    if (!(ancestor instanceof LogicalComponent)) break block18;
                    if (((LogicalComponent)ancestor).getSubLogicalComponents().isEmpty()) {
                        result = false;
                    } else if (((LogicalComponent)ancestor).getSubLogicalComponents().contains((Object)child)) {
                        result = true;
                    } else {
                        for (LogicalComponent ent : ((LogicalComponent)ancestor).getSubLogicalComponents()) {
                            if (!ComponentExt.isComponentAncestor((Component)ent, child)) continue;
                            result = true;
                        }
                    }
                    break block16;
                }
                if (!(ancestor instanceof PhysicalComponent)) break block19;
                if (((PhysicalComponent)ancestor).getSubPhysicalComponents().isEmpty()) {
                    result = false;
                } else if (((PhysicalComponent)ancestor).getSubPhysicalComponents().contains((Object)child)) {
                    result = true;
                } else {
                    for (PhysicalComponent ent : ((PhysicalComponent)ancestor).getSubPhysicalComponents()) {
                        if (!ComponentExt.isComponentAncestor((Component)ent, child)) continue;
                        result = true;
                    }
                }
                break block16;
            }
            if (!(ancestor instanceof ComponentContext)) break block16;
            ComponentContext cContext = (ComponentContext)ancestor;
            for (Partition partition : ComponentExt.getSubParts((PartitionableElement)cContext)) {
                Component current;
                if (!(partition.getAbstractType() instanceof Component) || (current = (Component)partition.getAbstractType()) != child && !ComponentExt.isComponentAncestor(current, child)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isComponentRoot(EObject element) {
        if (!(element instanceof Component)) {
            return false;
        }
        return !EcoreUtil2.isContainedBy((EObject)element, (EClass)CsPackage.Literals.COMPONENT);
    }

    public static Collection<Part> getBestPartAncestors(Part currentPart) {
        Component parent;
        LinkedList<Part> parents = new LinkedList<Part>();
        List<DeploymentTarget> e = PartExt.getDeployingElements(currentPart);
        parents.addAll(e);
        if (e.size() == 0 && (parent = ComponentExt.getDirectParent((Partition)currentPart)) != null && parent instanceof Component) {
            parents.addAll((Collection<Part>)parent.getRepresentingPartitions());
        }
        return parents;
    }

    public static Collection<EObject> filterNodes(Collection<EObject> elements) {
        Iterator<EObject> itElement = elements.iterator();
        while (itElement.hasNext()) {
            AbstractType type;
            EObject element = itElement.next();
            if (!(element instanceof Part) || !((type = ((Part)element).getAbstractType()) instanceof PhysicalComponent) || ((PhysicalComponent)type).getNature() != PhysicalComponentNature.NODE) continue;
            itElement.remove();
        }
        return elements;
    }

    public static boolean isBrothers(Part source, Part target) {
        EObject targetContainer2;
        EObject targetContainer;
        EObject sourceContainer2;
        EObject sourceContainer;
        HashSet<DeploymentTarget> deployingSource = new HashSet<DeploymentTarget>();
        deployingSource.addAll(PartExt.getDeployingElements(source));
        if (deployingSource.size() == 0 && (sourceContainer = EcoreUtil2.getFirstContainer((EObject)source, (EClass)CsPackage.Literals.COMPONENT)) != null && sourceContainer instanceof Component && (sourceContainer2 = EcoreUtil2.getFirstContainer((EObject)sourceContainer, (EClass)CsPackage.Literals.COMPONENT)) != null && sourceContainer2 instanceof Component) {
            deployingSource.addAll((Collection<DeploymentTarget>)((PartitionableElement)sourceContainer).getRepresentingPartitions());
        }
        HashSet<DeploymentTarget> deployingTarget = new HashSet<DeploymentTarget>();
        deployingTarget.addAll(PartExt.getDeployingElements(target));
        if (deployingTarget.size() == 0 && (targetContainer = EcoreUtil2.getFirstContainer((EObject)target, (EClass)CsPackage.Literals.COMPONENT)) != null && targetContainer instanceof Component && (targetContainer2 = EcoreUtil2.getFirstContainer((EObject)targetContainer, (EClass)CsPackage.Literals.COMPONENT)) != null && targetContainer2 instanceof Component) {
            deployingTarget.addAll((Collection<DeploymentTarget>)((PartitionableElement)targetContainer).getRepresentingPartitions());
        }
        if (deployingSource.size() == 0 && deployingTarget.size() == 0) {
            return true;
        }
        deployingSource.retainAll(deployingTarget);
        return deployingSource.size() > 0;
    }

    public static boolean isComposite(Component component) {
        for (Partition partition : component.getOwnedPartitions()) {
            if (!(partition instanceof Part) || partition.getType() != null && !(partition.getType() instanceof Component)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplementingInterface(Component component, Interface itf) {
        if (component != null) {
            for (InterfaceImplementation interfaceImpl : component.getImplementedInterfaceLinks()) {
                if (interfaceImpl.getImplementedInterface() == null || !interfaceImpl.getImplementedInterface().equals(itf)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isImplementingInterfaceWithAllSuperType(Component component, Interface itf) {
        List superGeneralizableElements = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)component);
        superGeneralizableElements.add(component);
        for (CapellaElement generalizableElement : superGeneralizableElements) {
            if (!(generalizableElement instanceof Component)) continue;
            for (InterfaceImplementation interfaceImpl : ((Component)generalizableElement).getImplementedInterfaceLinks()) {
                if (interfaceImpl.getImplementedInterface() == null || !interfaceImpl.getImplementedInterface().equals(itf)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLeaf(Component component) {
        return !ComponentExt.isComposite(component);
    }

    public static boolean isSameTypeAndNotRootElement(EObject me1, EObject me2) {
        if (me1 == null || me2 == null) {
            return false;
        }
        if (me1 instanceof LogicalComponent && me2 instanceof LogicalComponent) {
            return ((LogicalComponent)me1).eContainer() instanceof LogicalComponent || !(((LogicalComponent)me2).eContainer() instanceof LogicalComponent);
        }
        if (me1 instanceof PhysicalComponent && me2 instanceof PhysicalComponent) {
            return ((PhysicalComponent)me1).eContainer() instanceof PhysicalComponent || !(((PhysicalComponent)me2).eContainer() instanceof PhysicalComponent);
        }
        return false;
    }

    public static boolean isUsingInterface(Component component, Interface itf) {
        if (component != null) {
            for (InterfaceUse interfaceUse : component.getUsedInterfaceLinks()) {
                if (interfaceUse.getUsedInterface() == null || !interfaceUse.getUsedInterface().equals(itf)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUsingInterfaceWithAllSuperType(Component component, Interface itf) {
        List superGeneralizableElements = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)component);
        superGeneralizableElements.add(component);
        for (CapellaElement generalizableElement : superGeneralizableElements) {
            if (!(generalizableElement instanceof Component)) continue;
            for (InterfaceUse interfaceUse : ((Component)generalizableElement).getUsedInterfaceLinks()) {
                if (interfaceUse.getUsedInterface() == null || !interfaceUse.getUsedInterface().equals(itf)) continue;
                return true;
            }
        }
        return false;
    }

    private static Collection<EObject> createComponentExchangeAndDelegations(LinkedList<Part> sourceResults, ComponentPort sourcePort, Deque<Part> targetResults, ComponentPort targetPort) {
        ComponentExchange delegation;
        HashSet<EObject> results = new HashSet<EObject>();
        boolean isMultipart = false;
        Part finalSourcePart = null;
        Part finalTargetPart = null;
        ComponentPort srcPort = sourcePort;
        ComponentPort tgtPort = targetPort;
        ComponentPortKind sourceKind = ComponentPortKind.FLOW;
        ComponentPortKind targetKind = ComponentPortKind.FLOW;
        OrientationPortKind sourceOrientation = OrientationPortKind.OUT;
        OrientationPortKind targetOrientation = OrientationPortKind.IN;
        if (srcPort != null) {
            sourceKind = srcPort.getKind();
            sourceOrientation = srcPort.getOrientation();
        }
        if (tgtPort != null) {
            targetKind = tgtPort.getKind();
            targetOrientation = tgtPort.getOrientation();
        }
        if (sourceResults.size() > 0) {
            finalSourcePart = sourceResults.removeFirst();
            while (sourceResults.size() > 0) {
                Part source = sourceResults.removeFirst();
                delegation = ComponentExchangeExt.createComponentExchange(source, null, finalSourcePart, srcPort, ComponentExchangeKind.DELEGATION, sourceKind, sourceOrientation, sourceKind, sourceOrientation, isMultipart);
                results.add((EObject)delegation);
                srcPort = (ComponentPort)ComponentExchangeExt.getSourcePort(delegation);
                finalSourcePart = source;
            }
        }
        if (targetResults.size() > 0) {
            finalTargetPart = targetResults.removeFirst();
            while (targetResults.size() > 0) {
                Part target = targetResults.removeFirst();
                delegation = ComponentExchangeExt.createComponentExchange(target, null, finalTargetPart, tgtPort, ComponentExchangeKind.DELEGATION, targetKind, targetOrientation, targetKind, targetOrientation, isMultipart);
                results.add((EObject)delegation);
                tgtPort = (ComponentPort)ComponentExchangeExt.getSourcePort(delegation);
                finalTargetPart = target;
            }
        }
        if (finalSourcePart != null && finalTargetPart != null) {
            ComponentExchange exchange = ComponentExchangeExt.createComponentExchange(finalSourcePart, srcPort, finalTargetPart, tgtPort, ComponentExchangeKind.FLOW, sourceKind, sourceOrientation, targetKind, targetOrientation, isMultipart);
            results.add((EObject)exchange);
        }
        return results;
    }

    public static Collection<EObject> createComponentExchangeThroughDelegations(Part sourcePart, ComponentPort sourcePort, Part targetPart, ComponentPort targetPort) {
        HashSet<EObject> results = new HashSet<EObject>();
        LinkedList<Part> sourceResults = new LinkedList<Part>();
        LinkedList<Part> targetResults = new LinkedList<Part>();
        boolean isBrothers = false;
        LinkedList<EObject> sources = new LinkedList<EObject>();
        sources.add((EObject)sourcePart);
        while (sources.size() > 0) {
            Part source = (Part)sources.removeFirst();
            sourceResults.add(source);
            isBrothers = false;
            LinkedList<EObject> targets = new LinkedList<EObject>();
            targets.addFirst((EObject)targetPart);
            targetResults.clear();
            while (targets.size() > 0) {
                Part target = (Part)targets.removeFirst();
                targetResults.add(target);
                isBrothers = ComponentExt.isBrothers(source, target);
                if (isBrothers) {
                    results.addAll(ComponentExt.createComponentExchangeAndDelegations(new LinkedList<Part>(sourceResults), sourcePort, new LinkedList<Part>(targetResults), targetPort));
                    isBrothers = true;
                    targetResults.remove(target);
                    continue;
                }
                targets.addAll(ComponentExt.getBestPartAncestors(target));
                ComponentExt.filterNodes(targets);
            }
            if (isBrothers) {
                sourceResults.remove(source);
            }
            if (isBrothers) continue;
            sources.addAll(ComponentExt.getBestPartAncestors(source));
            ComponentExt.filterNodes(sources);
        }
        return results;
    }

    public static void removeImplementedInterface(Component component, Interface interf) {
        InterfaceImplementation realizationLink = null;
        ListIterator it = component.getImplementedInterfaceLinks().listIterator();
        while (it.hasNext()) {
            InterfaceImplementation lnk = (InterfaceImplementation)it.next();
            if (!lnk.getImplementedInterface().equals(interf)) continue;
            realizationLink = lnk;
        }
        if (realizationLink != null) {
            realizationLink.destroy();
        }
    }

    public static void removeProvidedInterface(Component component, Interface interf) {
        ComponentPort stdPort = null;
        for (Partition partition : component.getOwnedPartitions()) {
            if (!(partition instanceof ComponentPort) || !((ComponentPort)partition).getProvidedInterfaces().contains((Object)interf)) continue;
            stdPort = (ComponentPort)partition;
            stdPort.getProvidedInterfaces().remove((Object)interf);
            break;
        }
    }

    public static void removeRequiredInterface(Component component, Interface interf) {
        ComponentPort stdPort = null;
        for (Partition partition : component.getOwnedPartitions()) {
            if (!(partition instanceof ComponentPort) || !((ComponentPort)partition).getRequiredInterfaces().contains((Object)interf)) continue;
            stdPort = (ComponentPort)partition;
            stdPort.getRequiredInterfaces().remove((Object)interf);
            break;
        }
    }

    public static void removeUsedInterface(Component component, Interface interf) {
        InterfaceUse useLink = null;
        ListIterator it = component.getUsedInterfaceLinks().listIterator();
        while (it.hasNext()) {
            InterfaceUse lnk = (InterfaceUse)it.next();
            if (!lnk.getUsedInterface().equals(interf)) continue;
            useLink = lnk;
        }
        if (useLink != null) {
            useLink.destroy();
        }
    }

    public static List<PartitionableElement> getAllPartitionableElementAncestors(PartitionableElement current) {
        ArrayList<PartitionableElement> result = new ArrayList<PartitionableElement>();
        EList representingPartitions = current.getRepresentingPartitions();
        ArrayList<Component> ancestors = new ArrayList<Component>();
        for (Partition partition : representingPartitions) {
            Component parent = ComponentExt.getDirectParent(partition);
            if (parent == null) continue;
            ancestors.add(parent);
        }
        result.addAll(ancestors);
        for (PartitionableElement partitionableElement : ancestors) {
            result.addAll(ComponentExt.getAllPartitionableElementAncestors(partitionableElement));
        }
        return result;
    }

    public static boolean isComponentExchangeThroughDelegationsExists(Part sourcePart, Part targetPart, Port sourcePort, Port targetPort) {
        LinkedList<Part> sourceResults = new LinkedList<Part>();
        LinkedList<Part> targetResults = new LinkedList<Part>();
        boolean isBrothers = false;
        boolean canBeBrotherified = false;
        LinkedList<EObject> sources = new LinkedList<EObject>();
        sources.add((EObject)sourcePart);
        while (sources.size() > 0) {
            Part source = (Part)sources.removeFirst();
            sourceResults.add(source);
            isBrothers = false;
            LinkedList<EObject> targets = new LinkedList<EObject>();
            targets.addFirst((EObject)targetPart);
            targetResults.clear();
            while (targets.size() > 0) {
                Part target = (Part)targets.removeFirst();
                targetResults.add(target);
                isBrothers = ComponentExt.isBrothers(source, target);
                if (isBrothers) {
                    canBeBrotherified = true;
                    if (ComponentExt.areLinked(source, target, sourcePort, targetPort)) {
                        return true;
                    }
                    isBrothers = true;
                    targetResults.remove(target);
                }
                targets.addAll(ComponentExt.getBestPartAncestors(target));
                ComponentExt.filterNodes(targets);
            }
            if (isBrothers) {
                sourceResults.remove(source);
            }
            sources.addAll(ComponentExt.getBestPartAncestors(source));
            ComponentExt.filterNodes(sources);
        }
        return !canBeBrotherified;
    }

    private static boolean areLinked(Part source, Part target, Port sourcePort, Port targetPort) {
        Component sourceComponent = (Component)source.getAbstractType();
        Component targetComponent = (Component)target.getAbstractType();
        ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>();
        for (ComponentPort port : ComponentExt.getOwnedComponentPort(targetComponent)) {
            if (port != targetPort && !PortExt.getAllDelegatedComponentPorts(port).contains(targetPort)) continue;
            ports.add(port);
        }
        for (ComponentPort port : ComponentExt.getOwnedComponentPort(sourceComponent)) {
            if (port != sourcePort && !PortExt.getAllDelegatedComponentPorts(port).contains(sourcePort)) continue;
            Collection<ComponentPort> targets = PortExt.getConnectedComponentPortsWithoutDelegation(port);
            targets.retainAll(ports);
            if (targets.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isProvidingInterface(ComponentPort componentPort, Interface interf) {
        if (componentPort != null && interf != null) {
            for (Interface inter : componentPort.getProvidedInterfaces()) {
                if (inter == null || !inter.equals(interf)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRequiringInterface(ComponentPort componentPort, Interface interf) {
        if (componentPort != null && interf != null) {
            for (Interface inter : componentPort.getRequiredInterfaces()) {
                if (inter == null || !inter.equals(interf)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Component> getAllSubUsedAndDeployedComponents(Component component) {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(component);
        for (Component cpnt : ComponentExt.getSubUsedComponents(component)) {
            result.addAll(ComponentExt.getAllSubUsedAndDeployedComponents(cpnt));
        }
        if (component instanceof PhysicalComponent) {
            PhysicalComponent pc = (PhysicalComponent)component;
            for (PhysicalComponent deployedPC : pc.getDeployedPhysicalComponents()) {
                result.addAll(ComponentExt.getAllSubUsedAndDeployedComponents((Component)deployedPC));
            }
        }
        return result;
    }

    public static Collection<Interface> removeDuplicate(EList<Interface> list) {
        ArrayList<Interface> newList = new ArrayList<Interface>();
        for (Interface itf : list) {
            if (newList.contains(itf)) continue;
            newList.add(itf);
        }
        return newList;
    }

    public static IStatus isRequiredorUsedItfDelegated(IValidationContext ctx, LogicalComponent lcomp, Interface itf) {
        boolean found = false;
        if (!ComponentExt.isComposite((Component)lcomp)) {
            return ctx.createSuccessStatus();
        }
        EList ownedPartitions = lcomp.getOwnedPartitions();
        for (Partition next : ownedPartitions) {
            LogicalComponent lson;
            Part part;
            AbstractType abstractType;
            if (!(next instanceof Part) || !((abstractType = (part = (Part)next).getAbstractType()) instanceof LogicalComponent) || !(lson = (LogicalComponent)abstractType).getRequiredInterfaces().contains((Object)itf) && !lson.getUsedInterfaces().contains((Object)itf)) continue;
            found = true;
        }
        if (!found) {
            return ctx.createFailureStatus(new Object[]{lcomp.getName(), itf.getName()});
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus isProvidedorImplementedItfDelegated(IValidationContext ctx, Component lcomp, Interface itf) {
        boolean found = false;
        if (!ComponentExt.isComposite(lcomp)) {
            return ctx.createSuccessStatus();
        }
        EList ownedPartitions = lcomp.getOwnedPartitions();
        for (Partition next : ownedPartitions) {
            Component lson;
            Part part;
            AbstractType abstractType;
            if (!(next instanceof Part) || !((abstractType = (part = (Part)next).getAbstractType()) instanceof Component) || !(lson = (Component)abstractType).getProvidedInterfaces().contains((Object)itf) && !lson.getImplementedInterfaces().contains((Object)itf)) continue;
            found = true;
        }
        if (!found) {
            return ctx.createFailureStatus(new Object[]{lcomp.getName(), itf.getName()});
        }
        return ctx.createSuccessStatus();
    }
}

