/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ListIterator;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.AbstractPhysicalArtifact;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.pa.PhysicalComponent;

public class ConfigurationItemExt {
    public static boolean hasImplementedPC(ConfigurationItem configItem, PhysicalComponent pc) {
        boolean flag = false;
        for (Component cpnt : configItem.getAllocatedComponents()) {
            if (!cpnt.equals(pc)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean hasImplementedAbstractPhysicalArtifacts(ConfigurationItem configItem, AbstractPhysicalArtifact apa) {
        boolean flag = false;
        for (AbstractPhysicalArtifact cpnt : configItem.getAllocatedPhysicalArtifacts()) {
            if (!cpnt.equals(apa)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static void addImplementedPhysicalComponent(ConfigurationItem epbsComponent, PhysicalComponent physicalComponent) {
        PhysicalArtifactRealization impl = EpbsFactory.eINSTANCE.createPhysicalArtifactRealization();
        impl.setSourceElement((TraceableElement)epbsComponent);
        impl.setTargetElement((TraceableElement)physicalComponent);
        epbsComponent.getOwnedPhysicalArtifactRealizations().add((Object)impl);
    }

    public static void removeImplementedPhysicalComponent(ConfigurationItem configurationItem, PhysicalComponent physicalComponent) {
        PhysicalArtifactRealization implementLink = null;
        ListIterator it = configurationItem.getOwnedPhysicalArtifactRealizations().listIterator();
        while (it.hasNext()) {
            PhysicalArtifactRealization lnk = (PhysicalArtifactRealization)it.next();
            if (!lnk.getTargetElement().equals(physicalComponent)) continue;
            implementLink = lnk;
        }
        if (implementLink != null) {
            configurationItem.getOwnedPhysicalArtifactRealizations().remove(implementLink);
            implementLink.destroy();
        }
    }

    public static boolean isLeaf(ConfigurationItem current) {
        if (current == null) {
            return false;
        }
        return current.getOwnedConfigurationItems().isEmpty();
    }
}

