/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.move;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceAllocation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.StateExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

public class MoveHelper {
    private static MoveHelper instance;

    public static MoveHelper getInstance() {
        if (instance == null) {
            instance = new MoveHelper();
        }
        return instance;
    }

    public IStatus checkSemanticRules(List<EObject> selectedElements, EObject inputTargetElement) {
        boolean result = true;
        for (EObject selectedElement : selectedElements) {
            if (!(selectedElement instanceof ModelElement) || !(inputTargetElement instanceof ModelElement)) continue;
            ModelElement elt = (ModelElement)selectedElement;
            ModelElement targetElement = (ModelElement)inputTargetElement;
            if (elt instanceof FunctionPkg && targetElement instanceof FunctionPkg) {
                result = this.areInSameLayer(elt, targetElement) && !(targetElement.eContainer() instanceof BlockArchitecture);
                continue;
            }
            if (elt instanceof AbstractFunction && targetElement instanceof FunctionPkg) {
                result = this.areInSameLayer(elt, targetElement) && !(targetElement.eContainer() instanceof BlockArchitecture);
                continue;
            }
            if (elt instanceof LogicalComponentPkg && targetElement instanceof BlockArchitecture) {
                result = false;
                continue;
            }
            if (elt instanceof PhysicalComponentPkg && targetElement instanceof BlockArchitecture) {
                result = false;
                continue;
            }
            if (elt instanceof Component && elt.eContainer() instanceof BlockArchitecture) {
                result = false;
                continue;
            }
            if (elt instanceof FunctionPkg && targetElement instanceof EPBSArchitecture) {
                result = false;
                continue;
            }
            if (elt instanceof InterfacePkg && targetElement instanceof EPBSArchitecture) {
                result = false;
                continue;
            }
            if (elt instanceof Capability && !EcoreUtil2.isContainedBy((EObject)targetElement, (EClass)CtxPackage.Literals.SYSTEM_ANALYSIS)) {
                result = false;
                continue;
            }
            if (elt instanceof CapabilityRealization && EcoreUtil2.isContainedBy((EObject)targetElement, (EClass)CtxPackage.Literals.SYSTEM_ANALYSIS)) {
                result = false;
                continue;
            }
            if (elt instanceof OperationalCapabilityPkg && !EcoreUtil2.isContainedBy((EObject)targetElement, (EClass)OaPackage.Literals.OPERATIONAL_ANALYSIS)) {
                result = false;
                continue;
            }
            if (elt instanceof CapabilityPkg && !EcoreUtil2.isContainedBy((EObject)targetElement, (EClass)CtxPackage.Literals.SYSTEM_ANALYSIS)) {
                result = false;
                continue;
            }
            if (elt instanceof CapabilityRealizationPkg && !EcoreUtil2.isContainedBy((EObject)targetElement, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE) && !EcoreUtil2.isContainedBy((EObject)targetElement, (EClass)PaPackage.Literals.PHYSICAL_ARCHITECTURE) && !EcoreUtil2.isContainedBy((EObject)targetElement, (EClass)EpbsPackage.Literals.EPBS_ARCHITECTURE)) {
                result = false;
                continue;
            }
            if (elt instanceof AbstractFunction && targetElement instanceof AbstractFunction) {
                if (this.areInSameLayer(elt, targetElement)) continue;
                result = false;
                continue;
            }
            if (elt instanceof Component && targetElement instanceof Component) {
                if (this.areInSameLayer(elt, targetElement)) continue;
                result = false;
                continue;
            }
            if (elt instanceof Interface && targetElement instanceof InterfacePkg) {
                result = this.isLegalInterfaceMode((Interface)elt, (EObject)((InterfacePkg)targetElement));
                continue;
            }
            if (elt instanceof Interface && targetElement instanceof Interface) {
                result = this.isLegalInterfaceMode((Interface)elt, (EObject)((Interface)targetElement));
                continue;
            }
            if (elt instanceof Part) {
                AbstractType type = ((Part)elt).getAbstractType();
                if (type == null || !type.equals(targetElement) && !(targetElement instanceof Class) && !this.isDecomposedBy(targetElement, (ModelElement)type)) continue;
                result = false;
                continue;
            }
            if (elt instanceof EnumerationLiteral) {
                result = targetElement instanceof Enumeration;
                continue;
            }
            if (!(elt instanceof State)) continue;
            result = !(targetElement instanceof Region) ? false : this.canMoveModeState((State)elt, (Region)targetElement);
        }
        if (!result) {
            return new Status(4, "model.helpers", "Semantic rules failed.");
        }
        return Status.OK_STATUS;
    }

    protected boolean isDecomposedBy(ModelElement type1, ModelElement type2) {
        for (EObject obj : EObjectExt.getReferencers((EObject)type1, (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
            ModelElement cpnt;
            if (!(obj instanceof Part) || (cpnt = (ModelElement)obj.eContainer()) == null) continue;
            if (cpnt.equals(type2)) {
                return true;
            }
            if (!this.isDecomposedBy(cpnt, type2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLegalInterfaceMode(Interface interf, EObject targetElement) {
        BlockArchitecture cArchi;
        BlockArchitecture iArchi = BlockArchitectureExt.getRootBlockArchitecture(targetElement);
        for (Component component : interf.getUserComponents()) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        for (Component component : interf.getImplementorComponents()) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        for (Component component : InterfaceExt.getRequireComponent(interf)) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        for (Component component : InterfaceExt.getProviderComponent(interf)) {
            cArchi = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
            if (CapellaElementExt.isLegalArchitecture((ModellingArchitecture)iArchi, (ModellingArchitecture)cArchi)) continue;
            return false;
        }
        ArrayList traces = new ArrayList();
        traces.addAll(interf.getIncomingTraces());
        traces.addAll(interf.getOutgoingTraces());
        for (AbstractTrace abstractTrace : traces) {
            if (!(abstractTrace instanceof InterfaceAllocation)) continue;
            return false;
        }
        return true;
    }

    protected boolean areInSameLayer(ModelElement element1, ModelElement element2) {
        EPackage pkg;
        BlockArchitecture arch2;
        BlockArchitecture arch1 = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)element1, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        if (arch1 == (arch2 = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)element2, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE))) {
            return true;
        }
        return arch1 == null && ((pkg = element1.eClass().getEPackage()).equals(OaPackage.eINSTANCE) && arch2 instanceof OperationalAnalysis || pkg.equals(CtxPackage.eINSTANCE) && arch2 instanceof SystemAnalysis || pkg.equals(LaPackage.eINSTANCE) && arch2 instanceof LogicalArchitecture || pkg.equals(PaPackage.eINSTANCE) && arch2 instanceof PhysicalArchitecture || pkg.equals(EpbsPackage.eINSTANCE) && arch2 instanceof EPBSArchitecture);
    }

    public IStatus checkEMFRules(List<EObject> selectedModelElements, EObject targetElement) {
        EList allReferences;
        IStatus result = Status.OK_STATUS;
        TransactionalEditingDomain targetDomain = TransactionUtil.getEditingDomain((EObject)targetElement);
        if (targetDomain == null) {
            result = Status.CANCEL_STATUS;
        } else {
            for (EObject e : selectedModelElements) {
                TransactionalEditingDomain sourceDomain = TransactionUtil.getEditingDomain((EObject)e);
                if (sourceDomain == null || sourceDomain == targetDomain) continue;
                result = Status.CANCEL_STATUS;
            }
        }
        if (result.isOK() && !this.checkCompatibility(selectedModelElements, (EList<EReference>)(allReferences = targetElement.eClass().getEAllContainments()), targetElement)) {
            result = Status.CANCEL_STATUS;
        }
        return result;
    }

    protected boolean checkCompatibility(List<EObject> modelElements, EList<EReference> references, EObject target) {
        boolean areCompatible = true;
        Iterator<EObject> elementsIterator = modelElements.iterator();
        while (elementsIterator.hasNext() && areCompatible) {
            EObject modelElement = elementsIterator.next();
            boolean isElementCompatible = false;
            Iterator referencesIterator = references.iterator();
            while (referencesIterator.hasNext() && !isElementCompatible) {
                EObjectContainmentEList contList;
                EReference reference = (EReference)referencesIterator.next();
                if (!reference.getEType().isInstance((Object)modelElement) || reference == modelElement) continue;
                Integer upperBound = reference.getUpperBound();
                if (upperBound == -1 || upperBound == 1 && target.eGet((EStructuralFeature)reference) == null && modelElements.size() <= upperBound) {
                    isElementCompatible = true;
                    continue;
                }
                if (upperBound <= 1 || (contList = (EObjectContainmentEList)target.eGet((EStructuralFeature)reference)).size() >= upperBound) continue;
                isElementCompatible = true;
            }
            areCompatible &= isElementCompatible;
        }
        return areCompatible;
    }

    public boolean canMoveModeState(State source, Region targetElement) {
        boolean result = true;
        if (targetElement.eContainer() != null && !(source instanceof FinalState)) {
            EObject targetContainer = targetElement.eContainer();
            if (!CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed()) {
                boolean isSameType = true;
                if (targetContainer instanceof State) {
                    isSameType = targetContainer.eClass() == source.eClass();
                } else if (targetContainer instanceof StateMachine) {
                    List<State> states = MoveHelper.getAllModeState((Region)((StateMachine)targetContainer).getOwnedRegions().get(0));
                    boolean bl = !states.isEmpty() ? states.get(0).eClass() == source.eClass() : (isSameType = true);
                }
                return isSameType && !MoveHelper.isDownwardModeStateHierarchyMixed(source) && !MoveHelper.isModeStateHierarchyMixed(targetContainer);
            }
        }
        return result;
    }

    public static boolean isModeStateHierarchyMixed(EObject container) {
        List<State> stateModeLst = MoveHelper.getModeStateHierarchy(container);
        if (stateModeLst.size() <= 1) {
            return false;
        }
        int i = 0;
        while (i < stateModeLst.size() - 1) {
            if (stateModeLst.get(i).eClass() != stateModeLst.get(i + 1).eClass()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDownwardModeStateHierarchyMixed(State inputState) {
        List<State> stateModeLst = MoveHelper.getDownwardModeStateHierarchy(inputState);
        for (State state : stateModeLst) {
            if (state.eClass() == inputState.eClass()) continue;
            return true;
        }
        return false;
    }

    public static List<State> getModeStateHierarchy(EObject container) {
        ArrayList<State> stateModeLst;
        block4: {
            block3: {
                stateModeLst = new ArrayList<State>();
                if (!(container instanceof State)) break block3;
                TreeIterator iter = EcoreUtil.getAllContents((EObject)container, (boolean)true);
                while (iter.hasNext()) {
                    EObject eObj = (EObject)iter.next();
                    if (!StateExt.isStrictModeState(eObj)) continue;
                    stateModeLst.add((State)eObj);
                }
                stateModeLst.add((State)container);
                EObject parentState = EcoreUtil2.getFirstContainer((EObject)container, (EClass)CapellacommonPackage.eINSTANCE.getState());
                while (parentState != null) {
                    stateModeLst.add((State)parentState);
                    parentState = EcoreUtil2.getFirstContainer((EObject)parentState, (EClass)CapellacommonPackage.eINSTANCE.getState());
                }
                break block4;
            }
            if (!(container instanceof StateMachine)) break block4;
            TreeIterator iter = EcoreUtil.getAllContents((EObject)container, (boolean)true);
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                if (!StateExt.isStrictModeState(eObj)) continue;
                stateModeLst.add((State)eObj);
            }
        }
        return stateModeLst;
    }

    public static List<State> getDownwardModeStateHierarchy(State state) {
        ArrayList<State> stateModeLst = new ArrayList<State>();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)state, (boolean)true);
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!StateExt.isStrictModeState(eObj)) continue;
            stateModeLst.add((State)eObj);
        }
        stateModeLst.add(state);
        return stateModeLst;
    }

    public static List<State> getAllModeState(Region region) {
        ArrayList<State> stateModeLst = new ArrayList<State>();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)region, (boolean)true);
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!StateExt.isStrictModeState(eObj)) continue;
            stateModeLst.add((State)eObj);
        }
        return stateModeLst;
    }
}

