/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSAnnotateBlock;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;

public class AnnotateListener
extends CommandOutputListener {
    ByteArrayOutputStream aStream = new ByteArrayOutputStream();
    List blocks = new ArrayList();
    int lineNumber;

    @Override
    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        CVSAnnotateBlock aBlock;
        String error = null;
        if (!(aBlock = new CVSAnnotateBlock(line, this.lineNumber++)).isValid()) {
            error = line;
        }
        try {
            this.aStream.write(line.substring(aBlock.getSourceOffset()).getBytes());
            if (!line.endsWith("\r") && !line.endsWith("\r\n")) {
                this.aStream.write(System.getProperty("line.separator").getBytes());
            }
        }
        catch (IOException iOException) {}
        this.add(aBlock);
        if (error != null) {
            return new CVSStatus(4, -24, error, commandRoot);
        }
        return OK;
    }

    public InputStream getContents() {
        return new ByteArrayInputStream(this.aStream.toByteArray());
    }

    public List getCvsAnnotateBlocks() {
        return this.blocks;
    }

    private void add(CVSAnnotateBlock aBlock) {
        int size = this.blocks.size();
        if (size == 0) {
            this.blocks.add(aBlock);
        } else {
            CVSAnnotateBlock lastBlock = (CVSAnnotateBlock)this.blocks.get(size - 1);
            if (lastBlock.getRevision().equals(aBlock.getRevision())) {
                lastBlock.setEndLine(aBlock.getStartLine());
            } else {
                this.blocks.add(aBlock);
            }
        }
    }

    @Override
    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (line.startsWith(CVSMessages.AnnotateListener_3)) {
            String error = CVSMessages.AnnotateListener_4;
            return new CVSStatus(4, -10, error, commandRoot);
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }

    public void setContents(InputStream remoteContents) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int n = remoteContents.read(buffer);
            while (n != -1) {
                stream.write(buffer, 0, n);
                n = remoteContents.read(buffer);
            }
            this.aStream = stream;
        }
        catch (IOException e) {
            CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e)));
        }
    }
}

