/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.abstractqueries.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.information.delegates.DataValueHelper;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.CollectionValue;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.MultiplicityElement;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.NumericTypeKind;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.AbstractExpressionValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractStringValue;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.ComplexValue;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.EnumerationReference;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.DataValueExt;
import org.polarsys.capella.core.model.utils.EClassExt;

public class CapellaElementsHelperForBusinessQueries {
    private CapellaElementsHelperForBusinessQueries() {
    }

    public static List<EObject> getOnlyDiscreteDatatypes(List<EObject> elements) {
        ArrayList<EObject> onlyDiscreteDatatypes = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (!(element instanceof DataType) || !((DataType)element).isDiscrete()) continue;
            onlyDiscreteDatatypes.add(element);
        }
        return onlyDiscreteDatatypes;
    }

    public static List<CapellaElement> filterWithAvailableEClass(List<CapellaElement> list, EClass eclass) {
        ArrayList<CapellaElement> returnValue = new ArrayList<CapellaElement>();
        for (CapellaElement element : list) {
            if (!CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs((EObject)element, eclass)) continue;
            returnValue.add(element);
        }
        return returnValue;
    }

    public static List<CapellaElement> getValuesTypedBy(DataPkg dataPkg, GeneralizableElement capellaElement, boolean acceptNoType, boolean acceptSubClassifiers, EClass restrictToInstancesOf, CapellaElement toSkip) {
        ArrayList<EClass> restricToInstancesOf = null;
        if (restrictToInstancesOf != null) {
            restricToInstancesOf = new ArrayList<EClass>();
            restricToInstancesOf.add(restrictToInstancesOf);
        }
        return CapellaElementsHelperForBusinessQueries.getValuesTypedBy(dataPkg, capellaElement, acceptNoType, acceptSubClassifiers, restricToInstancesOf, toSkip);
    }

    public static List<CapellaElement> getValuesTypedBy(DataPkg dataPkg, DataType type, boolean acceptNoType, boolean acceptSubClassifiers, CapellaElement toSkip) {
        ArrayList<EClass> restricToInstancesOf = new ArrayList<EClass>();
        return CapellaElementsHelperForBusinessQueries.getValuesTypedBy(dataPkg, (GeneralizableElement)type, acceptNoType, acceptSubClassifiers, restricToInstancesOf, toSkip);
    }

    public static List<CapellaElement> getValuesTypedBy(DataPkg dataPkg, GeneralizableElement type, boolean acceptNoType, boolean acceptSubClassifiers, List<EClass> restrictToInstancesOf, CapellaElement toSkip) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        if (dataPkg != null) {
            List superClassifiers = GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)type);
            block0: for (Object object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                if (!(object instanceof DataValue)) continue;
                DataValue dataValue = (DataValue)object;
                if ((toSkip == null || dataValue == toSkip) && toSkip != null) continue;
                AbstractType dataValueType = dataValue.getAbstractType();
                if (acceptNoType && dataValueType == null || dataValueType != null && dataValueType == type) {
                    if (restrictToInstancesOf != null && restrictToInstancesOf.size() != 0 && !CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs((EObject)dataValue, restrictToInstancesOf)) continue;
                    availableElements.add((CapellaElement)dataValue);
                    continue;
                }
                if (!acceptSubClassifiers) continue;
                for (CapellaElement superClassifier : superClassifiers) {
                    if (!superClassifier.equals(dataValueType) || restrictToInstancesOf != null && restrictToInstancesOf.size() != 0 && !CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs((EObject)dataValue, restrictToInstancesOf)) continue;
                    availableElements.add((CapellaElement)dataValue);
                    continue block0;
                }
            }
        }
        return availableElements;
    }

    public static List<EObject> getCapellaElementsInstancesOf(DataPkg dataPkg, EClass eclass, CapellaElement capellaElement) {
        return CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf(dataPkg, eclass != null ? Collections.singletonList(eclass) : null, capellaElement);
    }

    public static List<EObject> getCapellaElementsInstancesOf(DataPkg dataPkg, List<EClass> eclasses, CapellaElement capellaElement) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        if (dataPkg != null) {
            Set allElements = new HashSet();
            if (eclasses != null) {
                for (EClass cls : eclasses) {
                    allElements.addAll(EObjectExt.getAll((EObject)dataPkg, (EClass)cls));
                }
            } else {
                allElements = EObjectExt.getAll((EObject)dataPkg, (EClass)CapellacorePackage.Literals.CAPELLA_ELEMENT);
            }
            for (EObject object : allElements) {
                if (!(object instanceof CapellaElement)) continue;
                CapellaElement elt = (CapellaElement)object;
                if (capellaElement != null && elt.equals(capellaElement) || !CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs((EObject)elt, eclasses)) continue;
                returnValue.add((EObject)elt);
            }
        }
        return returnValue;
    }

    public static List<CapellaElement> getDataValuesInstancesOf(DataPkg dataPkg, EClass eClass, boolean nonTyped, boolean typed) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        eClasses.add(eClass);
        return CapellaElementsHelperForBusinessQueries.getDataValuesInstancesOf(dataPkg, eClasses, nonTyped, typed);
    }

    public static List<CapellaElement> getDataValuesInstancesOf(DataPkg dataPkg, List<EClass> eClasses, boolean nonTyped, boolean typed) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        if (dataPkg != null) {
            for (EObject object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                if (!(object instanceof DataValue)) continue;
                DataValue dataValue = (DataValue)object;
                for (EClass eClass : eClasses) {
                    if (!CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs((EObject)dataValue, eClass) || (!nonTyped || dataValue.getAbstractType() != null) && (!typed || dataValue.getAbstractType() == null)) continue;
                    availableElements.add((CapellaElement)dataValue);
                }
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getDataValues(DataPkg dataPkg) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        if (dataPkg != null) {
            for (Object object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                if (!(object instanceof DataValue)) continue;
                availableElements.add((CapellaElement)((DataValue)object));
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getDataValuesTypedWithRootSuperTypesOf(BlockArchitecture blockArchitecture, CapellaElement capellaElement, EClass limitToInstancesOf) {
        DataPkg dataPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        if (capellaElement instanceof DataType && (dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture((BlockArchitecture)blockArchitecture)) != null) {
            List rootSuperClassifiers = GeneralizableElementExt.getRootSupertypes((GeneralizableElement)((DataType)capellaElement));
            block0: for (EObject object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                if (!(object instanceof DataValue)) continue;
                DataValue dataValue = (DataValue)object;
                AbstractType dataValueType = dataValue.getAbstractType();
                for (CapellaElement superClassifier : rootSuperClassifiers) {
                    if (dataValueType != superClassifier) continue;
                    if ((limitToInstancesOf == null || !CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs((EObject)dataValue, limitToInstancesOf)) && limitToInstancesOf != null) continue block0;
                    availableElements.add((CapellaElement)dataValue);
                    continue block0;
                }
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getPropertiesTypedBy(DataPkg dataPkg, GeneralizableElement dataType, boolean acceptNoType) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        if (dataPkg != null) {
            List superClassifiers = GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)dataType);
            for (EObject capellaElement : DataPkgExt.getAllClassifierFromDataPkg((DataPkg)dataPkg)) {
                if (!(capellaElement instanceof Classifier)) continue;
                Classifier classifier = (Classifier)capellaElement;
                EList ownedFeatures = classifier.getOwnedFeatures();
                block1: for (Feature feature : ownedFeatures) {
                    if (!(feature instanceof Property)) continue;
                    Property property = (Property)feature;
                    AbstractType propertyType = property.getAbstractType();
                    if (dataType == null || acceptNoType && propertyType == null || propertyType != null && propertyType == dataType) {
                        availableElements.add((CapellaElement)property);
                        continue;
                    }
                    for (CapellaElement superClassifier : superClassifiers) {
                        if (propertyType != superClassifier) continue;
                        availableElements.add((CapellaElement)property);
                        continue block1;
                    }
                }
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getApplicableValuesForCardinalitiesInLevel(DataPkg dataPkg) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (dataPkg != null) {
            for (Object object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                AbstractType dataValueType;
                DataValue dataValue;
                if (!(object instanceof DataValue) || !((dataValue = (DataValue)object) instanceof NumericValue) && !(dataValue instanceof AbstractExpressionValue) || (dataValueType = dataValue.getAbstractType()) != null && (!(dataValueType instanceof NumericType) || ((NumericType)dataValueType).getKind() != NumericTypeKind.INTEGER || ((NumericType)dataValueType).getOwnedMinValue() == null || DataValueHelper.getValueAsInt((NumericValue)((NumericType)dataValueType).getOwnedMinValue()) < 0)) continue;
                availableElements.add((CapellaElement)dataValue);
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getPositiveIntergerNumValAndExpressionsInLevel(DataPkg dataPkg) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (dataPkg != null) {
            for (Object object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                NumericType dataValueType;
                if (!(object instanceof DataValue)) continue;
                DataValue dataValue = (DataValue)object;
                if (dataValue instanceof NumericValue) {
                    dataValueType = ((NumericValue)dataValue).getNumericType();
                    if (dataValueType == null || !NumericTypeKind.INTEGER.equals((Object)dataValueType.getKind()) || dataValueType.getOwnedMinValue() == null || DataValueHelper.getValueAsInt((NumericValue)dataValueType.getOwnedMinValue()) < 0) continue;
                    availableElements.add((CapellaElement)dataValue);
                    continue;
                }
                if (!(dataValue instanceof AbstractExpressionValue) || (dataValueType = ((AbstractExpressionValue)dataValue).getExpressionType()) == null || !(dataValueType instanceof NumericType) || !NumericTypeKind.INTEGER.equals((Object)dataValueType.getKind()) || dataValueType.getOwnedMinValue() == null || DataValueHelper.getValueAsInt((NumericValue)dataValueType.getOwnedMinValue()) < 0) continue;
                availableElements.add((CapellaElement)dataValue);
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getApplicablePropertiesForStringBorderValuesInLevel(DataPkg dataPkg, CapellaElement capellaElement) {
        ArrayList<CapellaElement> returnValue = new ArrayList<CapellaElement>();
        List<CapellaElement> tempValues = CapellaElementsHelperForBusinessQueries.getApplicablePropertiesForCardinalitiesInLevel(dataPkg);
        for (CapellaElement elemnt : tempValues) {
            if (!(elemnt instanceof Property) || ((Property)elemnt).getType() == capellaElement) continue;
            returnValue.add(elemnt);
        }
        return returnValue;
    }

    public static List<CapellaElement> getApplicableLiteralsInLevel(BlockArchitecture blockArchitecture) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture((BlockArchitecture)blockArchitecture);
        if (dataPkg != null) {
            for (DataType dataType : DataPkgExt.getAllDataTypes((DataPkg)dataPkg)) {
                if (!(dataType instanceof Enumeration)) continue;
                Enumeration enumeration = (Enumeration)dataType;
                for (EnumerationLiteral literal : enumeration.getOwnedLiterals()) {
                    availableElements.add((CapellaElement)literal);
                }
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getApplicablePropertiesForCardinalitiesInLevel(DataPkg dataPkg) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        if (dataPkg != null) {
            for (EObject capellaElement : DataPkgExt.getAllClassifierFromDataPkg((DataPkg)dataPkg)) {
                if (!(capellaElement instanceof Classifier)) continue;
                Classifier classifier = (Classifier)capellaElement;
                EList ownedFeatures = classifier.getOwnedFeatures();
                for (Feature feature : ownedFeatures) {
                    Property property;
                    Type propertyType;
                    if (!(feature instanceof Property) || (propertyType = (property = (Property)feature).getType()) == null || !(propertyType instanceof NumericType) || ((NumericType)propertyType).getKind() != NumericTypeKind.INTEGER || ((NumericType)propertyType).getOwnedMinValue() == null || DataValueHelper.getValueAsInt((NumericValue)((NumericType)propertyType).getOwnedMinValue()) < 0) continue;
                    availableElements.add((CapellaElement)property);
                }
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getStandardApplicableValuesForMultiplicityElementInLevel(DataPkg dataPkg, MultiplicityElement mElement, List<EReference> eReferences) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        AbstractType mulElementType = null;
        if (mElement instanceof Property || mElement instanceof Parameter) {
            TypedElement typedElement = (TypedElement)mElement;
            mulElementType = typedElement.getAbstractType();
        } else if (mElement instanceof Collection) {
            Collection collection = (Collection)mElement;
            mulElementType = collection.getType();
        }
        if (mulElementType == null) {
            return availableElements;
        }
        if (dataPkg != null) {
            for (Object object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                if (!(object instanceof DataValue)) continue;
                DataValue dataValue = (DataValue)object;
                AbstractType dataValueType = dataValue.getAbstractType();
                if (dataValueType != null) {
                    if (mulElementType instanceof StringType && (eReferences.contains(InformationPackage.Literals.MULTIPLICITY_ELEMENT__OWNED_MIN_VALUE) || eReferences.contains(InformationPackage.Literals.MULTIPLICITY_ELEMENT__OWNED_MAX_VALUE))) {
                        if (!(dataValue instanceof AbstractStringValue) || dataValueType != mulElementType) continue;
                        availableElements.add((CapellaElement)dataValue);
                        continue;
                    }
                    if (dataValueType != mulElementType || !(dataValue instanceof NumericValue) && !(dataValue instanceof AbstractStringValue) && !(dataValue instanceof LiteralBooleanValue) && !(dataValue instanceof BooleanReference) && !(dataValue instanceof EnumerationLiteral) && !(dataValue instanceof EnumerationReference) && !(dataValue instanceof AbstractExpressionValue) && !(dataValue instanceof CollectionValue) && !(dataValue instanceof ComplexValue)) continue;
                    availableElements.add((CapellaElement)dataValue);
                    continue;
                }
                if (dataValue instanceof AbstractExpressionValue || mulElementType instanceof Class && dataValue instanceof ComplexValue) {
                    availableElements.add((CapellaElement)dataValue);
                    continue;
                }
                if (!(mulElementType instanceof NumericType && dataValue instanceof NumericValue || mulElementType instanceof StringType && dataValue instanceof AbstractStringValue || mulElementType instanceof BooleanType && (dataValue instanceof LiteralBooleanValue || dataValue instanceof BooleanReference)) && (!(mulElementType instanceof Enumeration) || !(dataValue instanceof EnumerationLiteral) && !(dataValue instanceof EnumerationReference))) continue;
                availableElements.add((CapellaElement)dataValue);
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getApplicableValuesForMultEleConsideringSuperGenElements(DataPkg dataPkg, MultiplicityElement mElement, List<EReference> eReferences) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        AbstractType mulElementType = null;
        if (mElement instanceof Property || mElement instanceof Parameter) {
            TypedElement typedElement = (TypedElement)mElement;
            mulElementType = typedElement.getAbstractType();
        } else if (mElement instanceof Collection) {
            Collection collection = (Collection)mElement;
            mulElementType = collection.getType();
        }
        if (mulElementType == null) {
            return availableElements;
        }
        List superGenEles = new ArrayList();
        if (mElement instanceof GeneralizableElement) {
            superGenEles = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)((GeneralizableElement)mElement));
        }
        if (!superGenEles.isEmpty() && dataPkg != null) {
            for (Object object : EObjectExt.getAll((EObject)dataPkg, (EClass)DatavaluePackage.Literals.DATA_VALUE)) {
                if (!(object instanceof DataValue)) continue;
                DataValue dataValue = (DataValue)object;
                AbstractType dataValueType = dataValue.getAbstractType();
                if (dataValueType != null) {
                    if (mulElementType instanceof StringType && (eReferences.contains(InformationPackage.Literals.MULTIPLICITY_ELEMENT__OWNED_MIN_VALUE) || eReferences.contains(InformationPackage.Literals.MULTIPLICITY_ELEMENT__OWNED_MAX_VALUE))) {
                        if (!(dataValue instanceof AbstractStringValue) || !superGenEles.contains(dataValueType)) continue;
                        availableElements.add((CapellaElement)dataValue);
                        continue;
                    }
                    if (!superGenEles.contains(dataValueType) || !(dataValue instanceof NumericValue) && !(dataValue instanceof AbstractStringValue) && !(dataValue instanceof LiteralBooleanValue) && !(dataValue instanceof BooleanReference) && !(dataValue instanceof EnumerationLiteral) && !(dataValue instanceof EnumerationReference) && !(dataValue instanceof AbstractExpressionValue) && !(dataValue instanceof CollectionValue) && !(dataValue instanceof ComplexValue)) continue;
                    availableElements.add((CapellaElement)dataValue);
                    continue;
                }
                if (dataValue instanceof AbstractExpressionValue || mulElementType instanceof Class && dataValue instanceof ComplexValue) {
                    availableElements.add((CapellaElement)dataValue);
                    continue;
                }
                if (!(mulElementType instanceof NumericType && dataValue instanceof NumericValue || mulElementType instanceof StringType && dataValue instanceof AbstractStringValue || mulElementType instanceof BooleanType && (dataValue instanceof LiteralBooleanValue || dataValue instanceof BooleanReference)) && (!(mulElementType instanceof Enumeration) || !(dataValue instanceof EnumerationLiteral) && !(dataValue instanceof EnumerationReference))) continue;
                availableElements.add((CapellaElement)dataValue);
            }
        }
        return availableElements;
    }

    public static List<CapellaElement> getPropertiesWithTypeOf(DataPkg dataPkg, CapellaElement mElement) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (mElement instanceof TypedElement) {
            TypedElement typedElement = (TypedElement)mElement;
            Type propertyType = typedElement.getType();
            if (propertyType == null) {
                return availableElements;
            }
            if (dataPkg != null) {
                for (EObject capellaElement : DataPkgExt.getAllClassifierFromDataPkg((DataPkg)dataPkg)) {
                    if (!(capellaElement instanceof Classifier)) continue;
                    Classifier classifier = (Classifier)capellaElement;
                    EList ownedFeatures = classifier.getOwnedFeatures();
                    for (Feature feature : ownedFeatures) {
                        Property foundProperty;
                        Type foundPropertyType;
                        if (!(feature instanceof Property) || (foundPropertyType = (foundProperty = (Property)feature).getType()) != propertyType) continue;
                        availableElements.add((CapellaElement)typedElement);
                    }
                }
            }
        }
        return availableElements;
    }

    public static boolean canBeInstanciatedAs(EObject object, EClass eClass) {
        return EClassExt.canBeInstanciatedAs((EObject)object, (EClass)eClass);
    }

    public static boolean canBeInstanciatedAs(EObject object, List<EClass> eClasses) {
        for (EClass eclass : eClasses) {
            if (!CapellaElementsHelperForBusinessQueries.canBeInstanciatedAs(object, eclass)) continue;
            return true;
        }
        return false;
    }

    public static List<CapellaElement> getDataValuesConsistantWithDataType(DataPkg dataPkg, DataType dataType) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(1);
        List<CapellaElement> dataValues = CapellaElementsHelperForBusinessQueries.getDataValues(dataPkg);
        for (CapellaElement dataValue : dataValues) {
            if (!(dataValue instanceof DataValue) || !DataValueExt.isDataValueConsitantWithDataType((DataValue)((DataValue)dataValue), (DataType)dataType)) continue;
            result.add(dataValue);
        }
        return result;
    }
}

