/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.fa;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_Connection_ConnectionFunctionalExchangeAllocations
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<Object> availableElements = new ArrayList<EObject>();
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        if (arch == null) {
            return availableElements;
        }
        if (element instanceof ComponentExchange) {
            ComponentExchange currentCapabilityUseCase = (ComponentExchange)element;
            availableElements.addAll(this.getRuleConnectionConnectionFunctionalExchangeAllocation(arch, currentCapabilityUseCase));
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRuleConnectionConnectionFunctionalExchangeAllocation(BlockArchitecture sysEng, ComponentExchange element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        Component source = null;
        Component target = null;
        InformationsExchanger informationsExchangerSource = element.getSource();
        InformationsExchanger informationsExchangerTarget = element.getTarget();
        if (informationsExchangerSource != null && informationsExchangerTarget != null) {
            source = ComponentExchangeExt.getSourceComponent((ComponentExchange)element);
            target = ComponentExchangeExt.getTargetComponent((ComponentExchange)element);
            availableElements.addAll(AbstractFunctionExt.getAllAllocatedFunctionalExchangeFiltered((AbstractFunctionalBlock)source, (AbstractFunctionalBlock)target));
            availableElements.addAll(AbstractFunctionExt.getAllAllocatedFunctionalExchangeFiltered((AbstractFunctionalBlock)target, (AbstractFunctionalBlock)source));
        }
        ArrayList<CapellaElement> allReadyAllocatedExchanges = new ArrayList<CapellaElement>();
        for (CapellaElement capellaElement : availableElements) {
            if (!(capellaElement instanceof FunctionalExchange)) continue;
            FunctionalExchange exchange = (FunctionalExchange)capellaElement;
            EList incomingTraces = exchange.getIncomingTraces();
            for (AbstractTrace abstractTrace : incomingTraces) {
                if (!(abstractTrace instanceof ComponentExchangeFunctionalExchangeAllocation)) continue;
                allReadyAllocatedExchanges.add(capellaElement);
            }
        }
        availableElements.removeAll(allReadyAllocatedExchanges);
        return availableElements;
    }
}

