/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.ReuseLink;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.sharedmodel.GenericPkg;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.DataValueExt;
import org.polarsys.capella.core.model.helpers.GenericPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;

public class GetAvailable_StringType_Property
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        ArrayList<EObject> availableElements = new ArrayList();
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        boolean isElementFromSharedPkg = false;
        if (systemEngineering == null) {
            SharedPkg sharedPkg = SystemEngineeringExt.getSharedPkg((CapellaElement)element);
            for (ReuseLink link : sharedPkg.getReuseLinks()) {
                if (SystemEngineeringExt.getSystemEngineering((CapellaElement)link) == null) continue;
                systemEngineering = SystemEngineeringExt.getSystemEngineering((CapellaElement)link);
                isElementFromSharedPkg = true;
                break;
            }
            if (systemEngineering == null) {
                return availableElements;
            }
        }
        if (element instanceof StringType) {
            StringType currentBooleanType = (StringType)element;
            if (!isElementFromSharedPkg) {
                availableElements.addAll(this.getRule_MQRY_BooleanValue_Type_11(currentBooleanType));
            }
            availableElements.addAll(this.getRule_MQRY_BooleanValue_Type_13(currentBooleanType, systemEngineering));
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_BooleanValue_Type_11(StringType currentBooleanType) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        List dataPkgList = DataValueExt.getDataPkgsFromParentHierarchy((ModelElement)currentBooleanType);
        for (DataPkg dataPkg : dataPkgList) {
            this.getAllPropertyFromDataPkg(availableElements, dataPkg, (DataType)currentBooleanType);
        }
        availableElements.addAll(this.getRule_MQRY_BooleanValue_Type_11_1(currentBooleanType));
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_BooleanValue_Type_13(StringType currentBooleanType, SystemEngineering systemEngineering) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        for (SharedPkg sharedPkg : SystemEngineeringExt.getSharedPkgs((SystemEngineering)systemEngineering)) {
            GenericPkg pkg = sharedPkg.getOwnedGenericPkg();
            if (pkg == null) continue;
            for (Class object : GenericPkgExt.getAllClasses((GenericPkg)pkg)) {
                this.getAllPropertiesFromClassifier(availableElements, (Classifier)object, (DataType)currentBooleanType);
            }
            for (Class object : GenericPkgExt.getAllExceptions((GenericPkg)pkg)) {
                this.getAllPropertiesFromClassifier(availableElements, (Classifier)object, (DataType)currentBooleanType);
            }
            for (Class object : GenericPkgExt.getAllMessages((GenericPkg)pkg)) {
                this.getAllPropertiesFromClassifier(availableElements, (Classifier)object, (DataType)currentBooleanType);
            }
            for (Class object : GenericPkgExt.getAllSignals((GenericPkg)pkg)) {
                this.getAllPropertiesFromClassifier(availableElements, (Classifier)object, (DataType)currentBooleanType);
            }
        }
        return availableElements;
    }

    private void getAllPropertyFromDataPkg(List<CapellaElement> availableElements, DataPkg dataPkg, DataType type) {
        if (dataPkg != null) {
            for (EObject dataType : DataPkgExt.getAllClassifierFromDataPkg((DataPkg)dataPkg)) {
                if (!(dataType instanceof Classifier)) continue;
                this.getAllPropertiesFromClassifier(availableElements, (Classifier)dataType, type);
            }
        }
    }

    private List<CapellaElement> getRule_MQRY_BooleanValue_Type_11_1(StringType currentBooleanType) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        BlockArchitecture arch = DataPkgExt.getRootBlockArchitecture((ModelElement)currentBooleanType);
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)currentBooleanType);
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
        if (oa != null) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)oa, (DataType)currentBooleanType));
        } else {
            SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ca, (DataType)currentBooleanType));
        }
        if (arch != null) {
            if (oa != null && arch instanceof LogicalArchitecture || arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                SystemAnalysis ctxArch = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ctxArch, (DataType)currentBooleanType));
            }
            if (arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                LogicalArchitecture logArch = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)logArch, (DataType)currentBooleanType));
            }
            if (arch instanceof EPBSArchitecture) {
                PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)physArch, (DataType)currentBooleanType));
            }
        }
        return availableElements;
    }

    private void getAllPropertiesFromClassifier(List<CapellaElement> availableElements, Classifier classifier, DataType type) {
        EList ownedFeatures = classifier.getOwnedFeatures();
        for (Feature feature : ownedFeatures) {
            AbstractType abstractType;
            if (!(feature instanceof Property) || (abstractType = ((Property)feature).getAbstractType()) == null || !(abstractType instanceof StringType)) continue;
            availableElements.add((CapellaElement)feature);
        }
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, DataType type) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (arch != null) {
            DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture((BlockArchitecture)arch);
            this.getAllPropertyFromDataPkg(availableElements, dataPkg, type);
        }
        return availableElements;
    }
}

