/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.business.abstractqueries.helpers.CapellaElementsHelperForBusinessQueries;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.UnionKind;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAvailable_UnionProperty_Qualifiers
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<EObject> returnValue = new ArrayList<EObject>();
        BlockArchitecture currentBlockArchitecture = DataPkgExt.getRootBlockArchitecture((ModelElement)element);
        SystemEngineering systemEngineering = SystemEngineeringExt.getSystemEngineering((CapellaElement)element);
        OperationalAnalysis operationalAnalysis = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
        returnValue.addAll(this.getDataFromLevel((BlockArchitecture)operationalAnalysis, element));
        if (!(currentBlockArchitecture instanceof OperationalAnalysis)) {
            SystemAnalysis systemAnalysis = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
            returnValue.addAll(this.getDataFromLevel((BlockArchitecture)systemAnalysis, element));
            if (!(currentBlockArchitecture instanceof SystemAnalysis)) {
                LogicalArchitecture logicalArchitecture = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
                returnValue.addAll(this.getDataFromLevel((BlockArchitecture)logicalArchitecture, element));
                if (!(currentBlockArchitecture instanceof LogicalArchitecture)) {
                    PhysicalArchitecture physicalArchitecture = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
                    returnValue.addAll(this.getDataFromLevel((BlockArchitecture)physicalArchitecture, element));
                    if (!(currentBlockArchitecture instanceof PhysicalArchitecture)) {
                        EPBSArchitecture epbsArchitecture = SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)systemEngineering);
                        returnValue.addAll(this.getDataFromLevel((BlockArchitecture)epbsArchitecture, element));
                    }
                }
            }
        }
        returnValue.addAll(this.getUnlevelizedData(element));
        returnValue.addAll(this.getDataFromComponentHierarchy(element));
        returnValue.addAll(this.getDataFromRealizedComponentsHierarchy(element));
        returnValue.addAll(this.getTypesFromComponentHierarchy(element));
        returnValue = this.filterUnNamedElements(returnValue);
        return returnValue;
    }

    public List<CapellaElement> getDataFromLevel(DataPkg dataPkg, CapellaElement capellaElement) {
        if (!(capellaElement instanceof UnionProperty)) {
            return Collections.emptyList();
        }
        UnionProperty unionProperty = (UnionProperty)capellaElement;
        AbstractType discriminantType = this.getParentUnionDiscriminantType(unionProperty);
        if (discriminantType instanceof BooleanType) {
            return this.filterAvailableData(this.getApplicableQualifiersForDiscriminantType(dataPkg, (BooleanType)discriminantType), unionProperty);
        }
        if (discriminantType instanceof Enumeration) {
            return this.filterAvailableData(this.getApplicableQualifiersForDiscriminantType(dataPkg, (Enumeration)discriminantType), unionProperty);
        }
        if (discriminantType instanceof DataType) {
            List<CapellaElement> dataValuesCorrespondingToDataType = CapellaElementsHelperForBusinessQueries.getValuesTypedBy(dataPkg, (DataType)discriminantType, false, true, null);
            dataValuesCorrespondingToDataType.addAll(CapellaElementsHelperForBusinessQueries.getPropertiesTypedBy(dataPkg, (GeneralizableElement)((DataType)discriminantType), false));
            return this.filterAvailableData(dataValuesCorrespondingToDataType, unionProperty);
        }
        return Collections.emptyList();
    }

    public List<CapellaElement> getUnlevelizedData(CapellaElement capellaElement) {
        ArrayList<CapellaElement> returnValue = new ArrayList<CapellaElement>();
        if (!(capellaElement instanceof UnionProperty)) {
            return returnValue;
        }
        UnionProperty unionProperty = (UnionProperty)capellaElement;
        AbstractType discriminantType = this.getParentUnionDiscriminantType(unionProperty);
        if (discriminantType instanceof BooleanType) {
            return this.filterAvailableData(this.getApplicableQualifiersForDiscriminantType((BooleanType)discriminantType), unionProperty);
        }
        if (discriminantType instanceof Enumeration) {
            return this.filterAvailableData(this.getApplicableQualifiersForDiscriminantType((Enumeration)discriminantType), unionProperty);
        }
        return returnValue;
    }

    protected AbstractType getParentUnionDiscriminantType(UnionProperty currentProperty) {
        UnionProperty discriminant = GetAvailable_UnionProperty_Qualifiers.getParentUnionDiscriminant(currentProperty);
        if (discriminant != null) {
            return discriminant.getAbstractType();
        }
        return null;
    }

    public List<CapellaElement> filterAvailableData(List<CapellaElement> list, UnionProperty unionProperty) {
        ArrayList<CapellaElement> returnValue = new ArrayList<CapellaElement>();
        for (CapellaElement capellaElement : list) {
            if (!(capellaElement instanceof DataValue) || this.shallBeSkipped((DataValue)capellaElement, unionProperty)) continue;
            returnValue.add(capellaElement);
        }
        return returnValue;
    }

    protected List<CapellaElement> getApplicableQualifiersForDiscriminantType(DataPkg dataPkg, BooleanType booleanType) {
        ArrayList<EClass> booleanReferencesAndExpression = new ArrayList<EClass>();
        booleanReferencesAndExpression.add(DatavaluePackage.Literals.BOOLEAN_REFERENCE);
        booleanReferencesAndExpression.add(DatavaluePackage.Literals.ABSTRACT_EXPRESSION_VALUE);
        return CapellaElementsHelperForBusinessQueries.getValuesTypedBy(dataPkg, (GeneralizableElement)booleanType, false, true, booleanReferencesAndExpression, null);
    }

    protected List<CapellaElement> getApplicableQualifiersForDiscriminantType(DataPkg dataPkg, Enumeration enumeration) {
        List<CapellaElement> returnValue = CapellaElementsHelperForBusinessQueries.getValuesTypedBy(dataPkg, (GeneralizableElement)enumeration, false, true, DatavaluePackage.Literals.ENUMERATION_REFERENCE, null);
        returnValue.addAll(CapellaElementsHelperForBusinessQueries.getValuesTypedBy(dataPkg, (GeneralizableElement)enumeration, false, true, DatavaluePackage.Literals.ABSTRACT_EXPRESSION_VALUE, null));
        return returnValue;
    }

    protected List<CapellaElement> getApplicableQualifiersForDiscriminantType(BooleanType booleanType) {
        ArrayList<CapellaElement> returnValue = new ArrayList<CapellaElement>();
        List rootSuperClassifiers = GeneralizableElementExt.getRootSupertypes((GeneralizableElement)booleanType);
        for (CapellaElement capellaElement : rootSuperClassifiers) {
            if (!(capellaElement instanceof BooleanType)) continue;
            BooleanType rootBooleanType = (BooleanType)capellaElement;
            returnValue.addAll((java.util.Collection<CapellaElement>)rootBooleanType.getOwnedLiterals());
        }
        return returnValue;
    }

    protected List<CapellaElement> getApplicableQualifiersForDiscriminantType(Enumeration enumeration) {
        ArrayList<CapellaElement> returnValue = new ArrayList<CapellaElement>();
        List rootSuperClassifiers = GeneralizableElementExt.getRootSupertypes((GeneralizableElement)enumeration);
        for (CapellaElement capellaElement : rootSuperClassifiers) {
            if (!(capellaElement instanceof Enumeration)) continue;
            Enumeration rootEnumerationType = (Enumeration)capellaElement;
            returnValue.addAll((java.util.Collection<CapellaElement>)rootEnumerationType.getOwnedLiterals());
        }
        return returnValue;
    }

    protected static UnionProperty getParentUnionDiscriminant(UnionProperty currentProperty) {
        EObject container = currentProperty.eContainer();
        if (container instanceof Union) {
            Union union = (Union)container;
            return union.getDiscriminant();
        }
        return null;
    }

    protected boolean shallBeSkipped(DataValue value, UnionProperty unionProperty) {
        if (GetAvailable_UnionProperty_Qualifiers.isParentUnionVariant(unionProperty)) {
            return false;
        }
        List<DataValue> qualifiers = GetAvailable_UnionProperty_Qualifiers.getAllParentUnionUnionPropertiesQualifiers(unionProperty);
        for (DataValue val : qualifiers) {
            if (val != value) continue;
            return true;
        }
        return false;
    }

    protected static boolean isParentUnionVariant(UnionProperty currentProperty) {
        EObject container = currentProperty.eContainer();
        if (container instanceof Union) {
            Union union = (Union)container;
            return union.getKind() == UnionKind.VARIANT;
        }
        return false;
    }

    protected static List<DataValue> getAllParentUnionUnionPropertiesQualifiers(UnionProperty currentProperty) {
        ArrayList<DataValue> returnValue = new ArrayList<DataValue>();
        EObject container = currentProperty.eContainer();
        if (container instanceof Union) {
            Union union = (Union)container;
            EList properties = union.getContainedProperties();
            for (Property property : properties) {
                if (!(property instanceof UnionProperty)) continue;
                UnionProperty uProp = (UnionProperty)property;
                returnValue.addAll((java.util.Collection<DataValue>)uProp.getQualifier());
            }
        }
        return returnValue;
    }

    public List<CapellaElement> getDataFromLevel(BlockArchitecture blockArchitecture, CapellaElement capellaElement) {
        DataPkg dataPkg;
        if (blockArchitecture != null && (dataPkg = blockArchitecture.getOwnedDataPkg()) != null) {
            return this.getDataFromLevel(dataPkg, capellaElement);
        }
        return Collections.emptyList();
    }

    protected List<CapellaElement> getDataFromComponentHierarchy(CapellaElement element) {
        ArrayList<CapellaElement> allDatas = new ArrayList<CapellaElement>();
        for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)element)) {
            DataPkg dataPkg = cpnt.getOwnedDataPkg();
            if (dataPkg == null) continue;
            allDatas.addAll(this.getDataFromLevel(dataPkg, element));
        }
        return allDatas;
    }

    protected List<CapellaElement> getDataFromRealizedComponentsHierarchy(CapellaElement element) {
        Component currentCpnt;
        ArrayList<CapellaElement> allDatas = new ArrayList<CapellaElement>();
        Component component = currentCpnt = element instanceof Component ? (Component)element : null;
        if (currentCpnt == null) {
            currentCpnt = (Component)EcoreUtil2.getFirstContainer((EObject)element, (EClass)CsPackage.Literals.COMPONENT);
        }
        if (currentCpnt != null) {
            for (Component allocatedCpnt : currentCpnt.getAllocatedComponents()) {
                List componentHierarchy = CapellaElementExt.getComponentHierarchy((CapellaElement)allocatedCpnt);
                componentHierarchy.add(allocatedCpnt);
                for (Component cpnt : componentHierarchy) {
                    DataPkg dataPkg = cpnt.getOwnedDataPkg();
                    if (dataPkg == null) continue;
                    for (CapellaElement data : this.getDataFromLevel(dataPkg, element)) {
                        if (allDatas.contains(data)) continue;
                        allDatas.add(data);
                    }
                }
            }
        }
        return allDatas;
    }

    protected List<EObject> getTypesFromComponentHierarchy(CapellaElement element) {
        List<EObject> allDatas = new ArrayList<EObject>();
        for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)element)) {
            DataPkg dataPkg = cpnt.getOwnedDataPkg();
            if (dataPkg == null) continue;
            allDatas.addAll(DataPkgExt.getAllTypesFromDataPkg((DataPkg)dataPkg));
        }
        allDatas = this.removeNonPrimitiveClasses(allDatas);
        allDatas = this.removeNonPrimitiveCollections(allDatas);
        return allDatas;
    }

    protected List<EObject> filterUnNamedElements(List<EObject> list) {
        ArrayList<EObject> result = new ArrayList<EObject>(1);
        for (EObject capellaElement : list) {
            String name;
            if (!(capellaElement instanceof AbstractNamedElement) || (name = ((AbstractNamedElement)capellaElement).getName()) == null || "".equals(name)) continue;
            result.add(capellaElement);
        }
        return result;
    }

    protected List<EObject> removeNonPrimitiveClasses(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveClasses(elements, false);
    }

    protected List<EObject> removeNonPrimitiveCollections(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveCollections(elements, false);
    }

    protected List<EObject> removePrimitiveOrNonPrimitiveClasses(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Class) {
                Class currentClass = (Class)element;
                if ((removePrimitive || !currentClass.isIsPrimitive()) && (!removePrimitive || currentClass.isIsPrimitive())) continue;
                returnValue.add((EObject)currentClass);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }

    protected List<EObject> removePrimitiveOrNonPrimitiveCollections(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Collection) {
                Collection currentCollection = (Collection)element;
                if ((removePrimitive || !currentCollection.isIsPrimitive()) && (!removePrimitive || currentCollection.isIsPrimitive())) continue;
                returnValue.add((EObject)currentCollection);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }
}

