/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.oa;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemContext;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSContext;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalContext;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalContext;
import org.polarsys.capella.core.model.helpers.LogicalActorPkgExt;
import org.polarsys.capella.core.model.helpers.LogicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.OperationalAnalysisExt;
import org.polarsys.capella.core.model.helpers.PhysicalActorPkgExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class GetAvailable_OperationalCapability_AvailableInStates
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        if (systemEngineering == null) {
            return availableElements;
        }
        if (element instanceof AbstractCapability) {
            availableElements.addAll(this.getAvailableElmentsFromCurrentLevel(systemEngineering, element));
        }
        return availableElements;
    }

    protected List<CapellaElement> getAvailableElmentsFromCurrentLevel(SystemEngineering systemEng, CapellaElement ele) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture blockArchitecture = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)ele);
        if (blockArchitecture instanceof OperationalAnalysis) {
            this.getElementsFromOperationalAnalysisLayer(ele, blockArchitecture, availableElements);
        } else if (blockArchitecture instanceof SystemAnalysis) {
            this.getElementsFromSystemAnalysisLayer(ele, blockArchitecture, availableElements);
        } else if (blockArchitecture instanceof LogicalArchitecture) {
            this.getElementsFromLogicalLayer(ele, blockArchitecture, availableElements);
        } else if (blockArchitecture instanceof PhysicalArchitecture) {
            this.getElementsFromPhysicalLayer(ele, blockArchitecture, availableElements);
        } else if (blockArchitecture instanceof EPBSArchitecture) {
            this.getElementsFromEPBSLayer(ele, blockArchitecture, availableElements);
        }
        return availableElements;
    }

    protected void getElementsFromOperationalAnalysisLayer(CapellaElement ele, BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        OperationalAnalysis oa = (OperationalAnalysis)blockArch;
        EntityPkg ownedEntityPkg = oa.getOwnedEntityPkg();
        List allEntity = OperationalAnalysisExt.getAllEntity((EntityPkg)ownedEntityPkg);
        for (Entity entity : allEntity) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((Component)entity, ele));
        }
    }

    protected void getElementsFromSystemAnalysisLayer(CapellaElement ele, BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        SystemAnalysis ca = (SystemAnalysis)blockArch;
        SystemContext ownedSystemContext = ca.getOwnedSystemContext();
        availableElements.addAll(this.getElementsFromBlockArchitecture((Component)ownedSystemContext, ele));
        System ownedSystem = ca.getOwnedSystem();
        availableElements.addAll(this.getElementsFromBlockArchitecture((Component)ownedSystem, ele));
        ActorPkg ownedActorPkg = ca.getOwnedActorPkg();
        List allActors = ActorPkgExt.getAllActors((ActorPkg)ownedActorPkg);
        for (Actor actor : allActors) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((Component)actor, ele));
        }
    }

    protected void getElementsFromLogicalLayer(CapellaElement ele, BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        LogicalArchitecture logArch = (LogicalArchitecture)blockArch;
        LogicalContext ownedLogicalContext = logArch.getOwnedLogicalContext();
        availableElements.addAll(this.getElementsFromBlockArchitecture((Component)ownedLogicalContext, ele));
        List allLCsFromLogicalArchitectureLayer = LogicalArchitectureExt.getAllLCsFromLogicalArchitectureLayer((LogicalArchitecture)logArch);
        for (LogicalComponent logicalComponent : allLCsFromLogicalArchitectureLayer) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((Component)logicalComponent, ele));
        }
        List allLAsFromLAPkg = LogicalActorPkgExt.getAllLAsFromLAPkg((LogicalActorPkg)logArch.getOwnedLogicalActorPkg());
        for (LogicalActor logicalActor : allLAsFromLAPkg) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((Component)logicalActor, ele));
        }
    }

    protected void getElementsFromPhysicalLayer(CapellaElement ele, BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        PhysicalArchitecture phyArch = (PhysicalArchitecture)blockArch;
        PhysicalContext ownedPhysicalContext = phyArch.getOwnedPhysicalContext();
        availableElements.addAll(this.getElementsFromBlockArchitecture((Component)ownedPhysicalContext, ele));
        List allPhysicalComponents = PhysicalArchitectureExt.getAllPhysicalComponents((PhysicalArchitecture)phyArch);
        for (PhysicalComponent physicalComponent : allPhysicalComponents) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((Component)physicalComponent, ele));
        }
        List allPAsFromPAPkg = PhysicalActorPkgExt.getAllPAsFromPAPkg((PhysicalActorPkg)phyArch.getOwnedPhysicalActorPkg());
        for (PhysicalActor physicalActor : allPAsFromPAPkg) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((Component)physicalActor, ele));
        }
    }

    protected void getElementsFromEPBSLayer(CapellaElement ele, BlockArchitecture blockArchitecture, List<CapellaElement> availableElements) {
        EPBSArchitecture epbsArch = (EPBSArchitecture)blockArchitecture;
        EPBSContext ownedEPBSContext = epbsArch.getOwnedEPBSContext();
        availableElements.addAll(this.getElementsFromBlockArchitecture((Component)ownedEPBSContext, ele));
        List allConfigurationItems = SystemEngineeringExt.getAllConfigurationItems((CapellaElement)epbsArch);
        for (ConfigurationItem configurationItem : allConfigurationItems) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((Component)configurationItem, ele));
        }
    }

    protected List<CapellaElement> getElementsFromBlockArchitecture(Component comp, CapellaElement ele) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (comp != null) {
            EList ownedStateMachines = comp.getOwnedStateMachines();
            for (StateMachine stateMachine : ownedStateMachines) {
                TreeIterator allContents = EcoreUtil.getAllContents((EObject)stateMachine, (boolean)false);
                while (allContents.hasNext()) {
                    Object object = allContents.next();
                    if (!(object instanceof State)) continue;
                    availableElements.add((CapellaElement)object);
                }
            }
        }
        List<CapellaElement> currentElements = this.getCurrentElements(ele, false);
        availableElements.removeAll(currentElements);
        return availableElements;
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        if (element instanceof AbstractCapability) {
            AbstractCapability ele = (AbstractCapability)element;
            EList availableInStates = ele.getAvailableInStates();
            for (State abstractStateMode : availableInStates) {
                currentElements.add((CapellaElement)abstractStateMode);
            }
        }
        return currentElements;
    }
}

