/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.services.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.polarsys.capella.common.ui.toolkit.services.validators.AbstractValidator;

public class RegExpValidator
extends AbstractValidator {
    public static final int SUPPORT_EMPTY_VALUE = 1;
    public static final int NONE = 0;
    private Pattern _regExpPattern;
    private int _style;

    public RegExpValidator(String errorMessage, String regularExpression, int style) {
        super(errorMessage);
        this._regExpPattern = Pattern.compile(regularExpression);
        this._style = style;
    }

    public Pattern getPattern() {
        return this._regExpPattern;
    }

    public String isValid(Object value) {
        String val;
        boolean isValid = false;
        if (value instanceof String && (val = (String)value).length() > 0) {
            Matcher matcher = this._regExpPattern.matcher(val);
            isValid = matcher.matches();
        }
        return !isValid && !this.checkEmptyValue(value) ? this.getErrorMessage() : null;
    }

    protected boolean checkEmptyValue(Object value) {
        if ((1 & this._style) != 0 && value instanceof String) {
            return ((String)value).length() == 0;
        }
        return false;
    }
}

