/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.ui.handlers.merge;

import java.util.HashMap;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategory;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategorySet;
import org.eclipse.emf.diffmerge.ui.viewers.categories.DifferenceCategorySet;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategoryItem;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategorySet;
import org.polarsys.capella.core.transition.common.handlers.merge.IMergeHandler;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.DiffCategoryProxy;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeCategoryManager
extends CategoryManager {
    IContext context;
    HashMap<String, IDifferenceCategorySet> sets = new HashMap();

    public MergeCategoryManager(EMFDiffNode node, IContext context) {
        super(node);
        this.context = context;
    }

    public boolean addCategory(ICategoryItem category) {
        IDifferenceCategory squatter = this.getCategory(category.getId());
        if (squatter != null) {
            if (squatter.getParent() != null) {
                squatter.getParent().getChildren().remove((Object)squatter);
            }
            this.removeCategory(category.getId());
        }
        DiffCategoryProxy itemCategory = new DiffCategoryProxy(category);
        if (category.getCategorySet() != null) {
            IDifferenceCategorySet set = this.getCategorySet(category.getCategorySet());
            set.getChildren().add((Object)itemCategory);
        }
        return this.addCategory(itemCategory);
    }

    public IDifferenceCategorySet getCategorySet(String id) {
        if (!this.sets.containsKey(id)) {
            this.sets.put(id, (IDifferenceCategorySet)new DifferenceCategorySet(id));
        }
        return this.sets.get(id);
    }

    public void initialize(IMergeHandler handler) {
        for (IDifferenceCategory category : this.getCategories()) {
            IDifferenceCategorySet set = category.getParent();
            this.sets.put(set.getText(this._node), set);
        }
        for (ICategorySet item : handler.getCategoriesSet(this.context)) {
            this.sets.put(item.getId(), (IDifferenceCategorySet)new DifferenceCategorySet(item.getText(), item.getDescription()));
        }
        for (ICategorySet item : handler.getCategories(this.context)) {
            this.addCategory((ICategoryItem)item);
        }
        this.setDefaultConfiguration();
        this.initializeFromPreferences();
    }

    public void setDefaultConfiguration() {
        if (!this.hasDefaultConfiguration()) {
            super.setDefaultConfiguration();
        }
    }

    protected boolean hasDefaultConfiguration() {
        return !this._defaultConfiguration.isEmpty();
    }

    public void initializeFromPreferences() {
        Object purposeValue = this.context.get((Object)"TRANSPOSER_PURPOSE");
        if (purposeValue instanceof String) {
            String purpose = (String)purposeValue;
            ScopedCapellaPreferencesStore scps = ScopedCapellaPreferencesStore.getInstance((String)"org.polarsys.capella.core.preferences");
            for (IDifferenceCategory category : this.getCategories()) {
                String isActiveKey = this.getIsActiveKey(purpose, category);
                scps.setDefault(isActiveKey, category.isActive());
                if (scps.containsKey(isActiveKey)) {
                    boolean active = scps.getBoolean(isActiveKey);
                    category.setActive(active);
                }
                String inFocusModeKey = this.getIsInFocusModeKey(purpose, category);
                scps.setDefault(inFocusModeKey, category.isInFocusMode());
                if (!scps.containsKey(inFocusModeKey)) continue;
                boolean inFocusMode = scps.getBoolean(inFocusModeKey);
                category.setInFocusMode(inFocusMode);
            }
        }
    }

    public void saveToPreferences() {
        Object purposeValue = this.context.get((Object)"TRANSPOSER_PURPOSE");
        if (purposeValue instanceof String) {
            String purpose = (String)purposeValue;
            ScopedCapellaPreferencesStore scps = ScopedCapellaPreferencesStore.getInstance((String)"org.polarsys.capella.core.preferences");
            for (IDifferenceCategory category : this.getCategories()) {
                String isActiveKey = this.getIsActiveKey(purpose, category);
                scps.setValue(isActiveKey, category.isActive());
                String isInFocusModeKey = this.getIsInFocusModeKey(purpose, category);
                scps.setValue(isInFocusModeKey, category.isInFocusMode());
            }
            scps.save();
        }
    }

    public void update() {
        super.update();
        this.saveToPreferences();
    }

    public String getIsActiveKey(String purpose, IDifferenceCategory category) {
        return String.valueOf(purpose) + "_" + category.getID() + "_isActive";
    }

    public String getIsInFocusModeKey(String purpose, IDifferenceCategory category) {
        return String.valueOf(purpose) + "_" + category.getID() + "_isInFocusMode";
    }
}

