/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.commands;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.transition.common.commands.DefaultCommand;
import org.polarsys.capella.core.transition.system.helpers.SemanticHelper;

public class DeleteReplicaAndRelatedElementsCommand
extends DefaultCommand {
    public DeleteReplicaAndRelatedElementsCommand(Collection<?> selection, IProgressMonitor progressMonitor) {
        super(selection, progressMonitor);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void performTransformation(Collection<?> source) {
        HashSet<CatalogElement> elements = new HashSet<CatalogElement>();
        HashSet<Object> elements_objects = new HashSet<Object>();
        for (Object e : SemanticHelper.getSemanticObjects(source)) {
            if (!(e instanceof EObject)) continue;
            if (e instanceof CatalogElement && ((CatalogElement)e).getKind() != CatalogElementKind.REC) {
                elements.add((CatalogElement)e);
                continue;
            }
            elements.addAll(ReplicableElementExt.getReferencingReplicas((EObject)((EObject)e)));
        }
        for (CatalogElement catalogElement : elements) {
            elements_objects.addAll(elements);
            for (CatalogElementLink elementLink : catalogElement.getOwnedLinks()) {
                if (!(elementLink.getTarget() instanceof ModelElement)) continue;
                elements_objects.add(elementLink.getTarget());
            }
        }
        CapellaDeleteCommand capellaDeleteCommand = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(elements_objects), elements_objects, true, !this.isHeadless(), true);
        capellaDeleteCommand.execute();
    }

    protected boolean isHeadless() {
        return true;
    }
}

