/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaValidateAction;
import org.polarsys.capella.core.validation.ui.CapellaValidationUIActivator;
import org.polarsys.capella.core.validation.ui.actions.EPFValidationAction;

public class ValidationActionProvider
extends CommonActionProvider {
    private ValidateAction defaultValidationAction;
    private List<ValidateAction> userValidationActions = new ArrayList<ValidateAction>();
    private ICommonViewerSite commonViewSite;
    private ImageDescriptor imageDescriptor;

    public void dispose() {
        ISelectionProvider selectionProvider = this.getActionSite().getViewSite().getSelectionProvider();
        if (this.defaultValidationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.defaultValidationAction);
            this.defaultValidationAction = null;
        }
        for (ValidateAction action : this.userValidationActions) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)action);
        }
        this.userValidationActions.clear();
        super.dispose();
    }

    protected boolean filterAction(IAction action) {
        return false;
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.commonViewSite = site.getViewSite();
        if (!(this.commonViewSite instanceof ICommonViewerWorkbenchSite)) {
            return;
        }
    }

    protected ValidateAction createValidationAction(boolean isRootAction, IFile file, ISelectionProvider selectionProvider, ImageDescriptor imageDescriptor) {
        EPFValidationAction validationAction = new EPFValidationAction(isRootAction, file);
        validationAction.setImageDescriptor(imageDescriptor);
        validationAction.setActiveWorkbenchPart(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)validationAction);
        ISelection selection = selectionProvider.getSelection();
        if (!selection.isEmpty()) {
            validationAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selection));
        }
        return validationAction;
    }

    public ValidateAction createDefaultValidation() {
        this.imageDescriptor = CapellaValidationUIActivator.getDefault().getImageDescriptor("capella_validate_16.gif");
        ISelectionProvider selectionProvider = this.commonViewSite.getSelectionProvider();
        CapellaValidateAction validationAction = new CapellaValidateAction();
        validationAction.setImageDescriptor(this.imageDescriptor);
        validationAction.setText("Validate Model");
        validationAction.setActiveWorkbenchPart(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)validationAction);
        ISelection selection = selectionProvider.getSelection();
        if (!selection.isEmpty()) {
            validationAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selection));
        }
        return validationAction;
    }

    public void fillContextMenu(IMenuManager menu) {
        this.initActions();
        if (this.userValidationActions.size() > 0) {
            MenuManager menuManager = new MenuManager("Validate Model", this.imageDescriptor, "ID");
            menu.insertBefore("group.validation", (IContributionItem)menuManager);
            menuManager.add((IAction)this.defaultValidationAction);
            menuManager.add((IContributionItem)new Separator());
            for (ValidateAction action : this.userValidationActions) {
                menuManager.add((IAction)action);
            }
        } else {
            this.imageDescriptor = CapellaValidationUIActivator.getDefault().getImageDescriptor("capella_validate_16.gif");
            this.userValidationActions = new ArrayList<ValidateAction>();
            menu.prependToGroup("group.validation", (IAction)this.defaultValidationAction);
        }
    }

    private void initActions() {
        ISelectionProvider selectionProvider = this.commonViewSite.getSelectionProvider();
        this.imageDescriptor = CapellaValidationUIActivator.getDefault().getImageDescriptor("capella_validate_16.gif");
        this.userValidationActions = new ArrayList<ValidateAction>();
        this.defaultValidationAction = this.createDefaultValidation();
        for (IFile file : PreferencesHelper.retrieveUserDefinedPreferenceFiles((ISelectionProvider)selectionProvider, (String)"epf")) {
            this.userValidationActions.add(this.createValidationAction(false, file, selectionProvider, this.imageDescriptor));
        }
    }

    public void fillActionBars(IActionBars actionBars) {
    }
}

