/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.helpers.interaction.services.ScenarioExt;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MergeLink;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.InstanceRoleHelper;
import org.polarsys.capella.core.refinement.merge.helpers.ScenarioHelper;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.merge.utils.CapellaCopier;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;

public class MergeHelper {
    public static Scenario hasBeenAlreadyMerged(Scenario sc) {
        if (sc == null || !LinkUtils.hasIncomingLinks((TraceableElement)sc, LinkEnum.MERGE_LINK)) {
            return null;
        }
        return (Scenario)LinkUtils.getIncomingLinkTargets((TraceableElement)sc, LinkEnum.MERGE_LINK).get(0);
    }

    public static List<InstanceRole> getDecomposedIR(InstanceRole ir) throws MergeToolException {
        ArrayList<InstanceRole> result = new ArrayList<InstanceRole>();
        InstanceRole instanceRole = null;
        if (!InstanceRoleHelper.isIRrepresentASysyemComponent(ir)) {
            return result;
        }
        SystemComponent sysComponent0 = (SystemComponent)InstanceRoleHelper.getAbstractType(ir);
        List trElts = ScenarioExt.hasLinkOftype((TraceableElement)ir, (EClass)InteractionPackage.Literals.MERGE_LINK, (EStructuralFeature)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT);
        switch (trElts.size()) {
            case 0: {
                instanceRole = ir;
                break;
            }
            case 1: {
                instanceRole = (InstanceRole)trElts.get(0);
                break;
            }
            default: {
                throw new MergeToolException(MergeMessages.genericInternalError);
            }
        }
        SystemComponent sysComponent1 = (SystemComponent)InstanceRoleHelper.getAbstractType(instanceRole);
        if (!sysComponent1.equals(sysComponent0)) {
            throw new MergeToolException(MergeMessages.genericInternalError);
        }
        trElts = ScenarioExt.hasLinkOftype((TraceableElement)instanceRole, (EClass)InteractionPackage.Literals.REFINEMENT_LINK, (EStructuralFeature)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__INCOMING_TRACES, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT);
        for (TraceableElement tr : trElts) {
            InstanceRole current = (InstanceRole)tr;
            if (current.getRepresentedInstance().equals(instanceRole.getRepresentedInstance())) continue;
            result.add(current);
        }
        return result;
    }

    public static InstanceRole addInstanceRole(Scenario sc, InstanceRole ir) throws MergeToolException {
        InstanceRole newIR = null;
        newIR = ScenarioHelper.isPartAlreadyRepresented(sc, ir);
        if (newIR == null) {
            newIR = (InstanceRole)CapellaCopier.copyObject((EObject)ir, true);
            sc.getOwnedInstanceRoles().add((Object)newIR);
            MergeHelper.addMergeLink((CapellaElement)newIR, (CapellaElement)ir);
        }
        return newIR;
    }

    public static Namespace addMergeLink(CapellaElement src, CapellaElement tgt) throws MergeToolException {
        return MergeHelper.addMergeLink(src, tgt, null);
    }

    public static Namespace addMergeLink(CapellaElement src, CapellaElement tgt, Namespace container) throws MergeToolException {
        Namespace owner = container;
        MergeLink mergeLink = MergeHelper.createMergeLink(src, tgt);
        if (owner == null) {
            EClass eNamespace = CapellacorePackage.Literals.NAMESPACE;
            CapellaElement current = src;
            while (current != null && owner == null) {
                if (eNamespace.isSuperTypeOf(current.eClass())) {
                    owner = (Namespace)current;
                }
                current = current.eContainer();
            }
        }
        if (owner != null) {
            owner.getOwnedTraces().add((Object)mergeLink);
        }
        return owner;
    }

    private static MergeLink createMergeLink(CapellaElement src, CapellaElement tgt) throws MergeToolException {
        if (src == null || tgt == null) {
            throw new MergeToolException(MergeMessages.unableToCreateMergeLinkDueToNullElt);
        }
        MergeLink result = InteractionFactory.eINSTANCE.createMergeLink();
        result.setSourceElement((TraceableElement)src);
        result.setTargetElement((TraceableElement)tgt);
        return result;
    }
}

