/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.merger.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.MergeHelper;
import org.polarsys.capella.core.refinement.merge.helpers.ScenarioHelper;
import org.polarsys.capella.core.refinement.merge.merger.internal.AddElementOnScUtils;
import org.polarsys.capella.core.refinement.merge.merger.operations.AbstractMergerOperation;
import org.polarsys.capella.core.refinement.merge.merger.operations.ScenarioDecomposition;
import org.polarsys.capella.core.refinement.merge.utils.CapellaCopier;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;
import org.polarsys.capella.core.refinement.merge.utils.MergeGarbage;
import org.polarsys.capella.core.refinement.merge.utils.MergeNavigator;

public class ScenarioSubstituteIRs
extends AbstractMergerOperation {
    protected ScenarioDecomposition _decompositionOp;
    protected Scenario _target;
    protected MergeNavigator _navigator;

    public ScenarioSubstituteIRs(ScenarioDecomposition decompositionOp) {
        this._decompositionOp = decompositionOp;
        this._target = decompositionOp.getTargetScenario();
    }

    @Override
    public void preOperation() throws MergeToolException {
        Map<InstanceRole, List<InstanceRole>> irToSubstituteMap = this._decompositionOp.getIRsMap();
        InstanceRole newIR = null;
        InstanceRole ir = null;
        for (InstanceRole iRToReplace : irToSubstituteMap.keySet()) {
            for (InstanceRole irToAdd : irToSubstituteMap.get(iRToReplace)) {
                boolean test;
                ir = ScenarioHelper.isPartAlreadyRepresented(this._target, irToAdd);
                boolean bl = test = ir != null && !MergeHelper.getDecomposedIR(ir).isEmpty() && !MergeHelper.getDecomposedIR(irToAdd).isEmpty() && MergeHelper.getDecomposedIR(ir).get(0).eContainer() != MergeHelper.getDecomposedIR(irToAdd).get(0).eContainer();
                if (ir != null && !test) continue;
                newIR = (InstanceRole)CapellaCopier.copyObject((EObject)irToAdd, true);
                this._target.getOwnedInstanceRoles().add((Object)newIR);
                MergeHelper.addMergeLink((CapellaElement)newIR, (CapellaElement)irToAdd);
            }
        }
        this._navigator = new MergeNavigator((EObject)irToSubstituteMap.get(irToSubstituteMap.keySet().iterator().next()).get(0));
    }

    @Override
    public void perform() throws MergeToolException {
        Set<InstanceRole> irsToSubstitute = this._decompositionOp.getIRsMap().keySet();
        HashSet<Scenario> datas = new HashSet<Scenario>();
        AddElementOnScUtils.getInstance().setNavigator(this._navigator);
        Scenario data = null;
        List<List<InteractionFragment>> strands = null;
        for (InstanceRole irToSubstitue : irsToSubstitute) {
            strands = this._decompositionOp.getStrandsForToReplace(irToSubstitue);
            data = (Scenario)strands.get(0).get(0).eContainer();
            if (datas.contains(data)) continue;
            datas.add(data);
            Iterator<List<InteractionFragment>> it = strands.iterator();
            InteractionFragment previousAnchor = null;
            List<InteractionFragment> strand = null;
            while (it.hasNext()) {
                boolean areNewElements;
                strand = it.next();
                boolean bl = areNewElements = !LinkUtils.hasOutgoingLinks((TraceableElement)strand.get(0), LinkEnum.REFINEMENT_LINK);
                if (areNewElements) {
                    this.addNewElements(previousAnchor, strand);
                    continue;
                }
                this.addExistingElements(strand);
                previousAnchor = strand.get(strand.size() - 1);
            }
        }
    }

    @Override
    public void postOperation() throws MergeToolException {
        Set<InstanceRole> irs = this._decompositionOp.getIRsMap().keySet();
        EList irsOwned = null;
        for (InteractionFragment ifrag : this._target.getOwnedInteractionFragments()) {
            if (ifrag.eClass() != InteractionPackage.Literals.INTERACTION_OPERAND && ifrag.eClass() != InteractionPackage.Literals.FRAGMENT_END) continue;
            irsOwned = ifrag.getCoveredInstanceRoles();
            ArrayList<InstanceRole> irsToAdd = new ArrayList<InstanceRole>();
            for (InstanceRole ir : irsOwned) {
                if (!irs.contains(ir)) continue;
                List<InstanceRole> listOnDATA = this._decompositionOp.getIRsMap().get(ir);
                irsToAdd.addAll(AddElementOnScUtils.getTargetIR(this._target, listOnDATA));
            }
            if (irsToAdd.isEmpty()) continue;
            ifrag.getCoveredInstanceRoles().removeAll(irs);
            ifrag.getCoveredInstanceRoles().addAll(irsToAdd);
        }
        for (InstanceRole iRToReplace : irs) {
            this._target.getOwnedInstanceRoles().remove((Object)iRToReplace);
            MergeGarbage.INSTANCE.add((EObject)iRToReplace);
        }
        MergeGarbage.INSTANCE.clear();
    }

    private void addNewElements(InteractionFragment fragment, List<InteractionFragment> strand) throws MergeToolException {
        InteractionFragment anchor = fragment;
        for (InteractionFragment ifrag : strand) {
            AddElementOnScUtils.getInstance().addIFrag(this._target, ifrag, true, anchor);
            anchor = ifrag;
        }
    }

    private void addExistingElements(List<InteractionFragment> strand) throws MergeToolException {
        for (InteractionFragment ifrag : strand) {
            AddElementOnScUtils.getInstance().addIFrag(this._target, ifrag, false, null);
        }
    }
}

