/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.merger.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.TimeLapseHelper;
import org.polarsys.capella.core.refinement.merge.merger.operations.AbstractMergerOperation;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;
import org.polarsys.capella.core.refinement.merge.utils.MergeGarbage;

public class SeekAndRemoveUnmergeableElements
extends AbstractMergerOperation {
    protected Scenario _result;
    protected Set<EObject> _objectsToDelete;
    private Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");

    public Scenario getResult() {
        return this._result;
    }

    public SeekAndRemoveUnmergeableElements(Scenario result) {
        this._result = result;
    }

    @Override
    public void perform() throws MergeToolException {
        if (!this._objectsToDelete.isEmpty()) {
            this._logger.warn((Object)new EmbeddedMessage(MergeMessages.cannotPerformAFullMerge, "Refinement", LinkUtils.getOutgoingLinkTargets((TraceableElement)this._result, LinkEnum.MERGE_LINK)));
            for (EObject eobject : this._objectsToDelete) {
                if (eobject.eClass() != InteractionPackage.Literals.SEQUENCE_MESSAGE) continue;
                this._logger.info((Object)new EmbeddedMessage(NLS.bind((String)MergeMessages.objectRemovedDueToLackOfData, (Object[])new Object[]{eobject.eClass().getName(), ((NamedElement)eobject).getName()}), "Refinement", LinkUtils.getOutgoingLinkTargets((TraceableElement)eobject, LinkEnum.MERGE_LINK)));
            }
        }
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.addAll(this._objectsToDelete);
        MergeGarbage.INSTANCE.delete(list);
    }

    @Override
    public void postOperation() throws MergeToolException {
        this._objectsToDelete.clear();
    }

    @Override
    public void preOperation() throws MergeToolException {
        this._objectsToDelete = new HashSet<EObject>();
        AbstractEnd ae = null;
        for (SequenceMessage sm : this._result.getOwnedMessages()) {
            boolean mustBeRemoved = false;
            AbstractEnd[] aes = new AbstractEnd[]{sm.getSendingEnd(), sm.getReceivingEnd()};
            int i = 0;
            while (i < aes.length) {
                ae = aes[i];
                if (ae.getCovered() == null) {
                    mustBeRemoved = true;
                }
                ++i;
            }
            if (!mustBeRemoved) continue;
            this._objectsToDelete.add((EObject)sm);
            this._objectsToDelete.add((EObject)sm.getSendingEnd());
            this._objectsToDelete.add((EObject)sm.getSendingEnd().getEvent());
            this._objectsToDelete.add((EObject)sm.getReceivingEnd());
            this._objectsToDelete.add((EObject)sm.getReceivingEnd().getEvent());
        }
        ArrayList<Execution> executionsToRemove = new ArrayList<Execution>();
        List<TimeLapse> executions = TimeLapseHelper.getTimeLapseOfType(this._result, InteractionPackage.Literals.EXECUTION);
        for (TimeLapse tl : executions) {
            Execution execution = (Execution)tl;
            if (execution.getCovered() != null && !this._objectsToDelete.contains(execution.getStart()) && !this._objectsToDelete.contains(execution.getFinish())) continue;
            executionsToRemove.add(execution);
        }
        for (Execution execution : executionsToRemove) {
            this._objectsToDelete.add((EObject)execution);
            for (EStructuralFeature feature : TimeLapseHelper.getBoundFeaturesList()) {
                ae = (AbstractEnd)execution.eGet(feature);
                this._objectsToDelete.add((EObject)ae);
                this._objectsToDelete.add((EObject)ae.getEvent());
            }
        }
        ArrayList<StateFragment> stateFragmentToRemove = new ArrayList<StateFragment>();
        List<TimeLapse> stateFragments = TimeLapseHelper.getTimeLapseOfType(this._result, InteractionPackage.Literals.STATE_FRAGMENT);
        for (TimeLapse tl : stateFragments) {
            StateFragment stateFragment = (StateFragment)tl;
            if (stateFragment.getStart() != null && stateFragment.getStart().getCoveredInstanceRoles() != null && !stateFragment.getStart().getCoveredInstanceRoles().isEmpty() && stateFragment.getStart().getCoveredInstanceRoles().get(0) != null && stateFragment.getFinish() != null && stateFragment.getFinish().getCoveredInstanceRoles() != null && !stateFragment.getFinish().getCoveredInstanceRoles().isEmpty() && stateFragment.getFinish().getCoveredInstanceRoles().get(0) != null) continue;
            stateFragmentToRemove.add(stateFragment);
        }
        for (StateFragment stateFragment : stateFragmentToRemove) {
            this._objectsToDelete.add((EObject)stateFragment);
            for (EStructuralFeature feature : TimeLapseHelper.getBoundFeaturesList()) {
                this._objectsToDelete.add((EObject)stateFragment.eGet(feature));
            }
        }
        for (AbstractTrace ir : this._result.getOwnedTraces()) {
            if (this.isValidLinkKind(ir, this._result)) continue;
            this._objectsToDelete.add((EObject)ir);
        }
    }

    public boolean isValidLinkKind(AbstractTrace link, Scenario scenario) {
        TraceableElement sourceType = link.getSourceElement();
        if (sourceType != null) {
            return scenario.equals(sourceType.eContainer()) || scenario.equals(sourceType);
        }
        return true;
    }
}

