/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.update;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.merge.utils.MergeNavigator;

public class UpdateMergedScenario {
    protected Scenario _old;
    protected Scenario _new;
    protected MergeNavigator _navigator;

    public UpdateMergedScenario(Scenario sc) {
        this._old = sc;
        this._navigator = new MergeNavigator((EObject)sc);
    }

    public void update(Scenario newScenario) {
        this._new = newScenario;
        AbstractTrace trace = this.hasLinkToNextLayer();
        if (trace != null) {
            this.performUpdate(trace);
        }
    }

    protected void performUpdate(AbstractTrace trace) {
        Scenario physSc = (Scenario)trace.getSourceElement();
        trace.setTargetElement((TraceableElement)this._new);
        TraceableElement eltOnOldSc = null;
        TraceableElement eltOnLogLayer = null;
        TraceableElement eltOnNewSc = null;
        ArrayList<AbstractTrace> traceToDelete = new ArrayList<AbstractTrace>();
        for (AbstractTrace at : physSc.getOwnedTraces()) {
            boolean isEvent = InteractionPackage.Literals.EVENT.isSuperTypeOf(at.getTargetElement().eClass());
            if (isEvent) continue;
            eltOnOldSc = at.getTargetElement();
            for (AbstractTrace att : eltOnOldSc.getOutgoingTraces()) {
                if (att.eClass() != InteractionPackage.Literals.MERGE_LINK) continue;
                eltOnLogLayer = att.getTargetElement();
                if (eltOnLogLayer != null) {
                    for (AbstractTrace attt : eltOnLogLayer.getIncomingTraces()) {
                        eltOnNewSc = attt.getSourceElement();
                        if (eltOnNewSc == null || eltOnNewSc.eContainer() != this._new) continue;
                        at.setTargetElement(eltOnNewSc);
                    }
                    continue;
                }
                traceToDelete.add(at);
            }
        }
        if (!traceToDelete.isEmpty()) {
            physSc.getOwnedTraces().removeAll(traceToDelete);
        }
    }

    protected AbstractTrace hasLinkToNextLayer() {
        AbstractTrace result = null;
        TraceableElement te = null;
        for (AbstractTrace trace : this._old.getIncomingTraces()) {
            te = trace.getSourceElement();
            if (!this._navigator.isContainedIntoTheNextLayer((EObject)te)) continue;
            result = trace;
            break;
        }
        return result;
    }
}

