/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.helpers.interaction.services.ScenarioExt;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;

public class LinkUtils {
    public static boolean hasOutgoingLinks(TraceableElement tre, LinkEnum linkType) {
        return !LinkUtils.getOutgoingLinkTargets(tre, linkType).isEmpty();
    }

    public static boolean hasIncomingLinks(TraceableElement tre, LinkEnum linkType) {
        return !LinkUtils.getIncomingLinkTargets(tre, linkType).isEmpty();
    }

    public static boolean hasIncomingLinksFrom(TraceableElement tre, LinkEnum linkType, Scenario target) {
        return !LinkUtils.getIncomingLinkTargetsFrom(tre, linkType, target).isEmpty();
    }

    public static List<TraceableElement> getOutgoingLinkTargets(TraceableElement tr, LinkEnum linkType) {
        List list = ScenarioExt.hasLinkOftype((TraceableElement)tr, (EClass)linkType.getEClass(), (EStructuralFeature)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT);
        return list;
    }

    public static List<TraceableElement> getIncomingLinkTargets(TraceableElement tre, LinkEnum linkType) {
        List list = ScenarioExt.hasLinkOftype((TraceableElement)tre, (EClass)linkType.getEClass(), (EStructuralFeature)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__INCOMING_TRACES, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT);
        return list;
    }

    public static List<TraceableElement> getIncomingLinkTargetsFrom(TraceableElement tre, LinkEnum linkType, Scenario target) {
        ArrayList<TraceableElement> result = new ArrayList<TraceableElement>();
        List list = ScenarioExt.hasLinkOftype((TraceableElement)tre, (EClass)linkType.getEClass(), (EStructuralFeature)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__INCOMING_TRACES, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT);
        EObject originator = null;
        for (TraceableElement elt : list) {
            originator = elt.eContainer();
            if (!originator.equals(target)) continue;
            result.add(elt);
        }
        return result;
    }

    public static List<AbstractTrace> getOutgoingLinks(TraceableElement tre, LinkEnum linkType) {
        ArrayList<AbstractTrace> result = new ArrayList<AbstractTrace>();
        for (AbstractTrace at : tre.getOutgoingTraces()) {
            if (!linkType.isSameType(at)) continue;
            result.add(at);
        }
        return result;
    }

    public static List<AbstractTrace> getIncomingLinks(TraceableElement tre, LinkEnum linkType) {
        ArrayList<AbstractTrace> result = new ArrayList<AbstractTrace>();
        for (AbstractTrace at : tre.getIncomingTraces()) {
            if (!linkType.isSameType(at)) continue;
            result.add(at);
        }
        return result;
    }

    public static List<AbstractTrace> getIncomingLinksFrom(TraceableElement tre, LinkEnum linkType, Scenario target) {
        ArrayList<AbstractTrace> result = new ArrayList<AbstractTrace>();
        EObject originator = null;
        for (AbstractTrace at : tre.getIncomingTraces()) {
            originator = at.getSourceElement().eContainer();
            if (!linkType.isSameType(at) || !originator.equals(target)) continue;
            result.add(at);
        }
        return result;
    }

    public static boolean doesMergeLinkAlreadyExist(TraceableElement eltSrc, TraceableElement eltTgt, LinkEnum linkType) {
        boolean result = false;
        for (TraceableElement te : LinkUtils.getOutgoingLinkTargets(eltSrc, linkType)) {
            if (!te.equals(eltTgt)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void removeAllLinksOn(TraceableElement elt) {
        ArrayList<AbstractTrace> list = new ArrayList<AbstractTrace>();
        list.addAll((Collection<AbstractTrace>)elt.getIncomingTraces());
        list.addAll((Collection<AbstractTrace>)elt.getOutgoingTraces());
        LinkUtils.deleteLinks(list);
    }

    public static void deleteLinks(List<AbstractTrace> traces) {
        for (AbstractTrace at : traces) {
            LinkUtils.deleteLink(at);
        }
    }

    public static void deleteLink(AbstractTrace at) {
        EObject eobject = at.eContainer();
        if (eobject != null) {
            Namespace ns = (Namespace)at.eContainer();
            ns.getOwnedTraces().remove((Object)at);
        }
    }
}

