/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.properties.Messages;
import org.polarsys.capella.core.data.information.properties.controllers.UnionPropertyController;
import org.polarsys.capella.core.data.information.properties.sections.PropertySection;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;

public class UnionPropertySection
extends PropertySection {
    private MultipleSemanticField _qualifierField;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this._qualifierField = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("UnionProperty.QualifierLabel"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new UnionPropertyController());
        this._qualifierField.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this._qualifierField.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getUnionProperty_Qualifier());
        this.evaluateButtonStatus((UnionProperty)capellaElement);
    }

    protected void evaluateButtonStatus(UnionProperty unionProperty) {
        super.evaluateButtonStatus((Property)unionProperty);
        if (unionProperty != null && unionProperty.eContainer() instanceof Union) {
            UnionProperty discriminant = ((Union)unionProperty.eContainer()).getDiscriminant();
            if (discriminant != null) {
                Type discriminantType = discriminant.getType();
                if (discriminantType != null) {
                    boolean enable = !(discriminantType instanceof Enumeration) && !(discriminantType instanceof BooleanType);
                    this._qualifierField.enableAddButton(enable);
                    this._qualifierField.enableOpenButton(true);
                } else {
                    this._qualifierField.enableAddButton(false);
                    this._qualifierField.enableOpenButton(false);
                }
            } else {
                this._qualifierField.enableAddButton(false);
                this._qualifierField.enableOpenButton(false);
            }
        }
    }

    @Override
    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest != null && eObjectToTest.eClass() == InformationPackage.eINSTANCE.getUnionProperty();
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this._qualifierField);
        return fields;
    }
}

