/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.controllers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ValueSpecification;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.model.helpers.ConstraintExt;
import org.polarsys.capella.core.ui.properties.controllers.AbstractSimpleEditableSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.SimpleEditableSemanticField;

public class ConstraintController
extends AbstractSimpleEditableSemanticFieldController {
    @Override
    public EObject writeOpenValue(EObject semanticElement, EStructuralFeature semanticFeature, String defaultName, EObject value) {
        semanticElement.eSet(semanticFeature, (Object)value);
        return value;
    }

    @Override
    public EObject loadValue(EObject semanticElement, EStructuralFeature semanticFeature) {
        if (semanticElement instanceof Constraint) {
            return semanticElement;
        }
        return super.loadValue(semanticElement, semanticFeature);
    }

    public EObject getElementToEdit(EObject semanticElement, EStructuralFeature semanticFeature) {
        EObject expectedConstraint = this.loadValue(semanticElement, semanticFeature);
        if (expectedConstraint == null || !(expectedConstraint instanceof Constraint)) {
            return null;
        }
        Constraint constraint = (Constraint)expectedConstraint;
        if (!(semanticElement instanceof Constraint) && constraint.getName() != null && !constraint.getName().isEmpty()) {
            return constraint;
        }
        ValueSpecification expectedOpaqueExpression = constraint.getOwnedSpecification();
        if (expectedOpaqueExpression == null || !(expectedOpaqueExpression instanceof OpaqueExpression)) {
            return null;
        }
        OpaqueExpression opaqueExpression = (OpaqueExpression)expectedOpaqueExpression;
        return opaqueExpression;
    }

    public EObject editValue(EObject semanticElement, EStructuralFeature semanticFeature, String text, boolean isLocalEdit) {
        boolean wasCreatedSpec = false;
        boolean wasCreatedCons = false;
        EObject elementToEdit = this.getElementToEdit(semanticElement, semanticFeature);
        if (elementToEdit instanceof Constraint) {
            ((Constraint)elementToEdit).setName(text);
        } else {
            boolean hasPerformedFinish;
            ValueSpecification specification;
            Constraint constraint = (Constraint)this.loadValue(semanticElement, semanticFeature);
            if (constraint == null) {
                constraint = CapellacoreFactory.eINSTANCE.createConstraint();
                ((CapellaElement)semanticElement).getOwnedConstraints().add((Object)constraint);
                CreationHelper.performContributionCommands((EObject)constraint, (EObject)semanticElement);
                semanticElement.eSet(semanticFeature, (Object)constraint);
                wasCreatedCons = true;
            }
            if ((specification = constraint.getOwnedSpecification()) == null) {
                specification = DatavalueFactory.eINSTANCE.createOpaqueExpression();
                constraint.setOwnedSpecification(specification);
                CreationHelper.performContributionCommands((EObject)specification, (EObject)constraint);
                wasCreatedSpec = true;
            }
            boolean bl = hasPerformedFinish = isLocalEdit || this.editValueWizard((EObject)specification);
            if (!hasPerformedFinish) {
                if (wasCreatedCons) {
                    SimpleEditableSemanticField.deleteContainmentValue((EObject)constraint);
                } else if (wasCreatedSpec) {
                    SimpleEditableSemanticField.deleteContainmentValue((EObject)specification);
                }
            }
            if (isLocalEdit && specification instanceof OpaqueExpression) {
                OpaqueExpression expression = (OpaqueExpression)specification;
                if (expression.getLanguages().isEmpty() || expression.getBodies().isEmpty()) {
                    expression.getLanguages().add((Object)"capella:linkedText");
                    expression.getBodies().add((Object)"");
                }
                expression.getBodies().set(0, (Object)text);
            }
        }
        return (EObject)semanticElement.eGet(semanticFeature);
    }

    @Override
    public EObject editValue(EObject semanticElement, EStructuralFeature semanticFeature, String text) {
        return this.editValue(semanticElement, semanticFeature, text, false);
    }

    public EObject editText(EObject semanticElement, EStructuralFeature semanticFeature, String text) {
        return this.editValue(semanticElement, semanticFeature, text, true);
    }

    public String loadText(EObject semanticElement, EStructuralFeature semanticFeature) {
        String body;
        EObject elementToEdit = this.getElementToEdit(semanticElement, semanticFeature);
        if (elementToEdit instanceof Constraint) {
            return ((Constraint)elementToEdit).getName();
        }
        if (elementToEdit instanceof OpaqueExpression && (body = ConstraintExt.getPrimaryBody((OpaqueExpression)((OpaqueExpression)elementToEdit))) != null) {
            return body;
        }
        return "";
    }
}

