/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.controllers.ConstraintController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.ConstraintReferenceField;

public class ConstraintReferenceGroup {
    private final Map<String, EReference> refs;
    private final Map<EReference, AbstractSemanticField> fields;
    boolean displayOpenButton;

    public ConstraintReferenceGroup(Map<String, EReference> refs) {
        this(refs, true);
    }

    public ConstraintReferenceGroup(Map<String, EReference> refs, boolean displayOpenButton) {
        this.displayOpenButton = displayOpenButton;
        this.refs = refs;
        this.fields = new HashMap<EReference, AbstractSemanticField>();
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory, boolean isDisplayedInWizard) {
        Group referenceGroup = factory.createGroup(parent, "");
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        referenceGroup.setLayoutData((Object)gd);
        referenceGroup.setLayout((Layout)new GridLayout(4 + (this.displayOpenButton ? 1 : 0), false));
        for (Map.Entry<String, EReference> entry : this.refs.entrySet()) {
            ConstraintReferenceField field = new ConstraintReferenceField((Composite)referenceGroup, entry.getKey(), factory, this.displayOpenButton, new ConstraintController());
            field.setDisplayedInWizard(isDisplayedInWizard);
            this.fields.put(entry.getValue(), field);
        }
    }

    public void loadData(EObject element) {
        for (Map.Entry<EReference, AbstractSemanticField> e : this.fields.entrySet()) {
            e.getValue().loadData(element, (EStructuralFeature)e.getKey());
        }
    }

    public Collection<? extends AbstractSemanticField> getFields() {
        return this.fields.values();
    }
}

