/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.viewers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.ui.properties.viewers.AbstractDelegatedViewer;
import org.polarsys.capella.core.ui.properties.viewers.ICellEditorProvider;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;

public class TreeDelegatedViewer
extends AbstractDelegatedViewer {
    protected Tree _tree;

    public TreeDelegatedViewer(TabbedPropertySheetWidgetFactory widgetFactory) {
        this(widgetFactory, null);
    }

    public TreeDelegatedViewer(TabbedPropertySheetWidgetFactory widgetFactory, ICellEditorProvider cellEditorProvider) {
        super(widgetFactory, cellEditorProvider);
    }

    @Override
    public void createContainer(Composite parent) {
        this._tree = this._widgetFactory.createTree(this.getViewerGroup(parent), 67586);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        tableLayoutData.horizontalSpan = 5;
        this._tree.setLayoutData((Object)tableLayoutData);
        this._columnViewer = new TreeViewer(this._tree);
        this._columnViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory()));
        this._columnViewer.setLabelProvider((IBaseLabelProvider)new CapellaElementLabelProvider());
        this.addViewerListeners();
        if (this.createViewerColumns()) {
            this._tree.setHeaderVisible(true);
            this._tree.setLinesVisible(true);
        }
        this.createCellEditors((Composite)this._tree);
    }

    protected TreeViewerColumn createTreeViewerColumn(int colNumber, CellLabelProvider labelProvider) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn((TreeViewer)this.getColumnViewer(), 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(this.getColumnProperties()[colNumber]);
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(true);
        viewerColumn.setLabelProvider(labelProvider);
        return viewerColumn;
    }

    @Override
    public void setInput(final List<EObject> input) {
        if (this._columnViewer != null) {
            this._columnViewer.setInput((Object)new IStructuredItemContentProvider(){

                public Collection<?> getElements(Object object) {
                    return input;
                }
            });
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._tree != null && !this._tree.isDisposed()) {
            this._tree.setEnabled(enabled);
        }
    }
}

