/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.scheduler;

import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.Node;
import org.polarsys.capella.core.refinement.scenarios.core.datastructures.ScenarioRepresentation;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.SchedulerException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IScheduler;

public class StandardScheduler
implements IScheduler {
    public Object getName() {
        return "Standard Scheduler";
    }

    public void doOrdering(ScenarioRepresentation srcTree, ScenarioRepresentation tgtTree, AbstractInstance finalAbstractInstance, Node<InteractionFragment> currentSrcNode, NamedElement tgtElement) throws SchedulerException {
        boolean wrongParentNode = false;
        boolean wrongPreviousNode = false;
        Node currentTgtNode = null;
        Node realPreviousNode = null;
        Node parentNodeFromSource = null;
        Node parentNodeFromTarget = null;
        Node previousNodeFromSource = null;
        Node previousNodeFromTarget = null;
        if (currentSrcNode.relatedNode == null) {
            currentTgtNode = tgtTree.cloneNode(currentSrcNode, finalAbstractInstance, tgtElement);
            tgtTree.addLastChild(tgtTree.getRootNode(), currentTgtNode);
        }
        if (currentSrcNode.relatedNode != null) {
            Node firstLinkedPredecessor;
            currentTgtNode = currentSrcNode.relatedNode;
            tgtTree.updateOperationNode(currentSrcNode, currentTgtNode);
            Node firstLinkedParent = currentSrcNode.getFirstLinkedParent();
            if (firstLinkedParent != null) {
                parentNodeFromSource = firstLinkedParent.relatedNode;
            }
            if ((firstLinkedPredecessor = currentSrcNode.getFirstLinkedPredecessor()) != null) {
                previousNodeFromSource = firstLinkedPredecessor.relatedNode;
            }
            previousNodeFromTarget = currentTgtNode.getFirstLinkedPredecessor();
            parentNodeFromTarget = currentTgtNode.getFirstLinkedParent();
            wrongPreviousNode = previousNodeFromSource != previousNodeFromTarget;
            boolean bl = wrongParentNode = parentNodeFromTarget != parentNodeFromSource;
            if (!wrongParentNode) {
                parentNodeFromSource = currentTgtNode.getParent();
            }
        } else {
            Node firstLinkedPredecessor;
            Node firstLinkedParent = currentSrcNode.getFirstLinkedParent();
            if (firstLinkedParent != null) {
                parentNodeFromSource = firstLinkedParent.relatedNode;
            }
            if ((firstLinkedPredecessor = currentSrcNode.getFirstLinkedPredecessor()) != null) {
                previousNodeFromSource = firstLinkedPredecessor.relatedNode;
            }
            wrongPreviousNode = true;
            wrongParentNode = true;
        }
        if (parentNodeFromSource != null && (wrongParentNode || wrongPreviousNode)) {
            tgtTree.unChainCurrentNodeMessage(currentTgtNode);
            realPreviousNode = srcTree.getChildBranchContainingNode(parentNodeFromSource, previousNodeFromSource);
            tgtTree.addChildAfter(parentNodeFromSource, currentTgtNode, realPreviousNode);
        }
    }
}

