/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.preferences.ConfigurabilityPreferences;
import org.polarsys.capella.core.commands.preferences.service.ConfigurableFieldEditorPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.IAbstractDefaultPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.Messages;
import org.polarsys.capella.core.commands.preferences.service.UserProfileModeEnum;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;

public abstract class AbstractDefaultPreferencePage
extends ConfigurableFieldEditorPreferencePage
implements IAbstractDefaultPreferencePage,
IWorkbenchPreferencePage {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");

    public AbstractDefaultPreferencePage() {
        super(1);
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    public AbstractDefaultPreferencePage(int style) {
        super(style);
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    public AbstractDefaultPreferencePage(String pageId) {
        super(pageId);
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
    }

    protected void setEnable(Composite parent, UserProfileModeEnum userMode) {
        parent.setEnabled(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled("com.thalsegroup.mde.capella.preferences.user.expert.profile"));
        COMPOSITE_FIEL_EDITORS.add(parent);
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    @Override
    public boolean performOk() {
        boolean ok = super.performOk();
        IPreferenceStore store = this.getPreferenceStore();
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                StringBuilder loggerMessage = new StringBuilder(Messages.AbstractDefaultPreferencePage_SavePreferences_ErrorMessage);
                __logger.warn((Object)loggerMessage.toString(), (Throwable)e);
                return false;
            }
        }
        return ok;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    public IPreferenceStore getProjectPreferenceStore() {
        IProject selectedCapellaProject = PreferencesHelper.getSelectedCapellaProject();
        if (selectedCapellaProject != null) {
            return PreferencesHelper.getProjectScope(selectedCapellaProject);
        }
        return super.getPreferenceStore();
    }

    protected Group createGroup(String label_p, String tooltip_p, Composite parent_p) {
        Group group = new Group(parent_p, 0);
        group.setText(label_p);
        group.setToolTipText(tooltip_p);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        group.setLayoutData((Object)gridData);
        return group;
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
    }
}

