/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.transferer;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.ImportExportWizard;
import org.polarsys.capella.core.preferences.transferer.PreferencesImportExportPage;

public class CapellaImportExportPreferences
extends ImportExportWizard {
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private PreferencesImportExportPage importExportPage;
    private String page = null;
    private boolean isPageCompleted;

    public CapellaImportExportPreferences(String pageId) {
        super(pageId);
        this.page = pageId;
    }

    public boolean performFinish() {
        this.importExportPage.saveWidgetValues();
        return true;
    }

    public void addPages() {
        if (!this.page.equals(IMPORT) && this.page.equals(EXPORT)) {
            this.importExportPage = new PreferencesImportExportPage(this.workbench, this.selection);
        }
        if (this.importExportPage != null) {
            this.addPage((IWizardPage)this.importExportPage);
        }
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.workbench = aWorkbench;
        this.selection = currentSelection;
        ImageDescriptor wizardBannerImage = null;
        if (IMPORT.equals(this.page)) {
            wizardBannerImage = WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_IMPORT_WIZ");
            this.setWindowTitle(WorkbenchMessages.ImportWizard_title);
        } else if (EXPORT.equals(this.page)) {
            wizardBannerImage = WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_EXPORT_WIZ");
            this.setWindowTitle(WorkbenchMessages.ExportWizard_title);
        }
        if (wizardBannerImage != null) {
            this.setDefaultPageImageDescriptor(wizardBannerImage);
        }
        this.setNeedsProgressMonitor(true);
    }

    public boolean canFinish() {
        return this.isPageCompleted();
    }

    private boolean isPageCompleted() {
        return this.isPageCompleted;
    }

    public void setPageCompleted(boolean isPageCompleted_p) {
        this.isPageCompleted = isPageCompleted_p;
    }
}

