/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.sequence_message;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.properties.controllers.DataFlowHelper;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;

public class MDCHK_SequenceMessage_FS_OAS_InvokedOperation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx_p) {
        EMFEventType eType = ctx_p.getEventType();
        if (EMFEventType.NULL != eType) {
            return ctx_p.createSuccessStatus();
        }
        EObject eObj = ctx_p.getTarget();
        if (!(eObj instanceof SequenceMessage)) {
            return ctx_p.createSuccessStatus();
        }
        SequenceMessage sequenceMessage = (SequenceMessage)eObj;
        if (sequenceMessage.getKind() == MessageKind.REPLY) {
            return ctx_p.createSuccessStatus();
        }
        if (!ScenarioExt.isFunctionalScenario((Scenario)((Scenario)sequenceMessage.eContainer()))) {
            return ctx_p.createSuccessStatus();
        }
        AbstractEventOperation invokedOperation = sequenceMessage.getInvokedOperation();
        if (invokedOperation == null) {
            return ctx_p.createSuccessStatus();
        }
        if (!(invokedOperation instanceof FunctionalExchange)) {
            return this.createFailureStatus(ctx_p, sequenceMessage, "Sequence Message invoked operation is not a Functional Exchange");
        }
        List availableFunctionalExchanges = DataFlowHelper.getAvailableFonctionalExchangesFromFunctions((SequenceMessage)sequenceMessage);
        if (!availableFunctionalExchanges.contains(invokedOperation)) {
            String exchangeSourceFunctionName = EObjectLabelProviderHelper.getText((EObject)FunctionalExchangeExt.getSourceFunction((FunctionalExchange)((FunctionalExchange)invokedOperation)));
            String exchangeTargetFunctionName = EObjectLabelProviderHelper.getText((EObject)FunctionalExchangeExt.getTargetFunction((FunctionalExchange)((FunctionalExchange)invokedOperation)));
            return this.createFailureStatus(ctx_p, sequenceMessage, "Invoked Functional Exchange (source: " + exchangeSourceFunctionName + ", target: " + exchangeTargetFunctionName + ") is no more available for this Sequence Message");
        }
        return ctx_p.createSuccessStatus();
    }

    public IStatus createFailureStatus(IValidationContext ctx_p, SequenceMessage sequenceMessage_p, String additionalMessage_p) {
        String sequenceMessageName = EObjectLabelProviderHelper.getText((EObject)sequenceMessage_p);
        String sequenceMessageMetaClass = EObjectLabelProviderHelper.getMetaclassLabel((EObject)sequenceMessage_p, (boolean)false);
        String scenarioName = EObjectLabelProviderHelper.getText((EObject)sequenceMessage_p.eContainer());
        String scenarioMetaClass = EObjectLabelProviderHelper.getMetaclassLabel((EObject)sequenceMessage_p.eContainer(), (boolean)false);
        return ctx_p.createFailureStatus(new Object[]{sequenceMessageName, sequenceMessageMetaClass, scenarioName, scenarioMetaClass, additionalMessage_p});
    }
}

