/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.af;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.osgi.framework.Version;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.af.integration.AFIntegrationPlugin;
import org.polarsys.capella.core.af.integration.CapellaMetadataProvider;
import org.polarsys.capella.core.data.migration.capella.Messages;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaFeatureHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class ViewpointMigrationContribution
extends AbstractMigrationContribution {
    @Override
    public IStatus preMigrationExecute(IResource fileToMigrate, MigrationContext context, boolean checkVersion) {
        IFile afm;
        if (fileToMigrate instanceof IFile && MetadataHelper.isMetadataResource((IResource)fileToMigrate)) {
            return this.checkAFM(fileToMigrate, context, checkVersion);
        }
        if (CapellaResourceHelper.isCapellaResource((IResource)fileToMigrate)) {
            IFile afm2 = CapellaMetadataProvider.getAFM((IFile)((IFile)fileToMigrate));
            if (afm2.exists()) {
                return this.checkAFM((IResource)afm2, context, checkVersion);
            }
            return this.checkLegacy((IFile)fileToMigrate, context, checkVersion);
        }
        if (CapellaResourceHelper.isAirdResource((IResource)fileToMigrate, (boolean)true) && (afm = CapellaMetadataProvider.getAFM((IFile)((IFile)fileToMigrate))).exists()) {
            return this.checkAFM((IResource)afm, context, checkVersion);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void dispose(ExecutionManager manager, ResourceSet resourceSet, MigrationContext context) {
        super.dispose(manager, resourceSet, context);
    }

    private IStatus checkLegacy(IFile fileToMigrate, MigrationContext context, boolean checkVersion) {
        Version fileVersion = CapellaFeatureHelper.getFileVersion((IFile)fileToMigrate);
        context.setFileVersion(fileToMigrate, fileVersion);
        if (checkVersion) {
            Version currentVersion = CapellaMetadataProvider.getCurrentVersion();
            return this.isMigrationPossible(fileVersion, currentVersion, context);
        }
        return Status.OK_STATUS;
    }

    private IStatus checkAFM(IResource fileToMigrate, MigrationContext context, boolean checkVersion) {
        MultiStatus status = new MultiStatus(AFIntegrationPlugin.getSymbolicName(), 0, "Some viewpoints are missing", null);
        try {
            if (Version.emptyVersion.equals((Object)context.getFileVersion((IFile)fileToMigrate))) {
                Version currentVersion;
                IStatus version;
                Map viewpointUsages = CapellaMetadataProvider.getViewpointsUsage((IFile)((IFile)fileToMigrate));
                Version fileVersion = (Version)viewpointUsages.get("org.polarsys.capella.core.viewpoint");
                context.setFileVersion((IFile)fileToMigrate, fileVersion);
                if (checkVersion && !(version = this.isMigrationPossible(fileVersion, currentVersion = CapellaMetadataProvider.getCurrentVersion(), context)).isOK()) {
                    return version;
                }
                for (String id : viewpointUsages.keySet()) {
                    if (ViewpointManager.getViewpoint((String)id) != null) continue;
                    status.add((IStatus)new Status(4, AFIntegrationPlugin.getSymbolicName(), "The viewpoint '" + id + "' is missing"));
                }
                return status;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status.add((IStatus)new Status(4, AFIntegrationPlugin.getSymbolicName(), e.getMessage()));
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus isMigrationPossible(Version fileVersion, Version currentVersion, MigrationContext context) {
        if (Version.emptyVersion.equals((Object)fileVersion)) {
            String formattedMessage = NLS.bind((String)Messages.MigrationAction_ErrorDialog_CorruptedMessage, (Object[])new String[]{context.getResourceName()});
            return new Status(4, "org.polarsys.capella.core.data.migration", formattedMessage);
        }
        if (!this.isMigrationPossible(fileVersion, currentVersion)) {
            String formattedMessage = NLS.bind((String)Messages.MigrationAction_ErrorDialog_TooOldMessage, (Object[])new String[]{context.getResourceName(), currentVersion.toString()});
            return new Status(4, "org.polarsys.capella.core.data.migration", formattedMessage);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        Resource resource;
        Resource initMetadata;
        if (CapellaResourceHelper.isAirdResource((IResource)context.getResource(), (boolean)true) && (initMetadata = MetadataHelper.initMetadata((Resource)(resource = resourceSet.getResource(EcoreUtil2.getURI((IFile)context.getResource()), false)))) != null) {
            boolean found = false;
            EObject eObject = (EObject)resource.getContents().get(0);
            if (eObject instanceof DAnalysis) {
                DAnalysis analysis = (DAnalysis)eObject;
                ResourceDescriptor descriptor = new ResourceDescriptor(initMetadata.getURI());
                URI descriptorURI = descriptor.getResourceURI();
                EList semanticResources = analysis.getSemanticResources();
                for (ResourceDescriptor semanticResource : semanticResources) {
                    URI semanticResourceURI = semanticResource.getResourceURI();
                    String str = URI.encodeFragment((String)semanticResourceURI.toString(), (boolean)true);
                    if (!str.equals(descriptorURI.toString())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    semanticResources.add((Object)descriptor);
                }
            }
        }
    }

    private boolean isMigrationPossible(Version fileVersion, Version currentVersion) {
        boolean sameMajor;
        boolean bl = sameMajor = currentVersion.getMajor() == fileVersion.getMajor();
        return sameMajor && currentVersion.getMinor() - fileVersion.getMinor() <= 1;
    }
}

