/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.context;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Version;

public class MigrationContext {
    private boolean _skipConfirmation = false;
    private Shell _shell;
    private IProgressMonitor _monitor = null;
    private String _name;
    private IFile _resource;
    private HashMap<IPath, Version> fileVersions = new HashMap();

    public Version getCurrentVersion() {
        return this.getFileVersion(this._resource);
    }

    public Version getFileVersion(IFile file) {
        IPath path = file.getFullPath().removeFileExtension();
        Version currentVersion = this.fileVersions.containsKey(path) ? this.fileVersions.get(path) : Version.emptyVersion;
        return currentVersion;
    }

    public void setFileVersion(IFile file, Version currentVersion) {
        IPath path = file.getFullPath().removeFileExtension();
        this.fileVersions.put(path, currentVersion);
    }

    public MigrationContext() {
    }

    public MigrationContext(MigrationContext context) {
    }

    public boolean isSkipConfirmation() {
        return this._skipConfirmation;
    }

    public void setSkipConfirmation(boolean skipConfirmation) {
        this._skipConfirmation = skipConfirmation;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this._monitor = monitor;
    }

    public void setShell(Shell shell) {
        this._shell = shell;
    }

    public IProgressMonitor getProgressMonitor() {
        return this._monitor;
    }

    public Shell getShell() {
        return this._shell;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public IFile getResource() {
        return this._resource;
    }

    public String getResourceName() {
        return this.getResource() == null ? this.getName() : this.getResource().getName();
    }

    public void setResource(IFile file) {
        this._resource = file;
    }
}

