/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.internal.representation.DRepresentationDescriptorToDRepresentationLinkManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.osgi.framework.Version;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.migration.Activator;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.data.migration.contribution.Messages;

public class UidFromXmiIdContribution
extends AbstractMigrationContribution {
    HashMap<DRepresentation, String> representationToOriginalUidMap = new HashMap();
    HashMap<String, DRepresentationDescriptor> originalRepPathToDescriptorMap = new HashMap();

    @Override
    public void dispose(MigrationContext context) {
        super.dispose(context);
        this.representationToOriginalUidMap.clear();
        this.originalRepPathToDescriptorMap.clear();
    }

    @Override
    public void updateElement(EObject peekObject, String typeName, EObject result, EStructuralFeature feature, Resource resource, MigrationContext context) {
        String originalRepPath;
        DRepresentationDescriptor descriptor;
        DRepresentation representation;
        String originalUid;
        super.updateElement(peekObject, typeName, result, feature, resource, context);
        if (result instanceof DRepresentation && (originalUid = (representation = (DRepresentation)result).getUid()) != null) {
            this.representationToOriginalUidMap.put(representation, originalUid);
        }
        if (result instanceof DRepresentationDescriptor && (descriptor = (DRepresentationDescriptor)result).getRepPath() != null && (originalRepPath = descriptor.getRepPath().getResourceURI().fragment()) != null) {
            this.originalRepPathToDescriptorMap.put(originalRepPath, descriptor);
        }
    }

    protected boolean isCompatibleVersion(MigrationContext context) {
        Version currentVersion = context.getCurrentVersion();
        if (currentVersion != null) {
            boolean isValidVersion = true;
            isValidVersion &= currentVersion.getMajor() == 1;
            isValidVersion &= currentVersion.getMinor() == 2;
            return isValidVersion &= currentVersion.getMicro() > 0;
        }
        return false;
    }

    @Override
    public void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        super.postMigrationExecute(executionManager, resourceSet, context);
        if (this.isCompatibleVersion(context)) {
            int i = 0;
            for (Map.Entry<DRepresentation, String> entry : this.representationToOriginalUidMap.entrySet()) {
                DRepresentation representation = entry.getKey();
                String originalUid = entry.getValue();
                DRepresentationDescriptor descriptor = this.originalRepPathToDescriptorMap.get(originalUid);
                if (descriptor == null || representation == null) continue;
                representation.setUid(originalUid);
                new DRepresentationDescriptorToDRepresentationLinkManager(descriptor).setRepresentation(representation);
                ((XMIResource)representation.eResource()).setID((EObject)representation, originalUid);
                ++i;
            }
            if (i > 0) {
                Status status = new Status(1, "org.polarsys.capella.core.data.migration", NLS.bind((String)Messages.MigrationAction_UidMigration, (Object)context.getName(), (Object)i));
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

