/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentContext;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationItem;
import org.polarsys.capella.core.data.information.datavalue.DataValueContainer;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalActor;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class TransitionHelper {
    private static TransitionHelper service;

    public static TransitionHelper getService() {
        if (service == null) {
            service = new TransitionHelper();
        }
        return service;
    }

    public boolean isFunctionalTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractFunction || object instanceof FunctionPkg || object instanceof FunctionalExchange || object instanceof FunctionalChain);
    }

    public boolean isInterfaceTransitionAvailable(EObject object) {
        return object instanceof CapellaElement && CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) && (object instanceof Interface || object instanceof InterfacePkg);
    }

    public boolean isExchangeItemTransitionAvailable(EObject object) {
        return !(!(object instanceof CapellaElement) || !CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) && !CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || !(object instanceof ExchangeItem) && !(object instanceof ExchangeItemAllocation));
    }

    public boolean isStateMachineTransitionAvailable(EObject object) {
        return (object instanceof BlockArchitecture || object instanceof Component && !(object instanceof ComponentContext) && ((Component)object).getOwnedStateMachines().size() > 0 || object instanceof Part && ((Part)object).getAbstractType() != null && ((Part)object).getAbstractType() instanceof Component && ((Component)((Part)object).getAbstractType()).getOwnedStateMachines().size() > 0 || object instanceof StateMachine || object instanceof AbstractState || object instanceof StateTransition) && object instanceof CapellaElement && !CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)((CapellaElement)object)) && !CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)((CapellaElement)object));
    }

    public boolean isDataTransitionAvailable(EObject object) {
        return (object instanceof BlockArchitecture || object instanceof Component && !(object instanceof ComponentContext) && ((Component)object).getOwnedDataPkg() != null || object instanceof Part && ((Part)object).getAbstractType() != null && ((Part)object).getAbstractType() instanceof Component && ((Component)((Part)object).getAbstractType()).getOwnedDataPkg() != null || object instanceof DataPkg || object instanceof DataValueContainer || object instanceof Collection || object instanceof CommunicationItem || object instanceof Class) && object instanceof CapellaElement && !CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)((CapellaElement)object)) && !CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)((CapellaElement)object));
    }

    public boolean isFunctionalScenario(Scenario scenario_p) {
        if (scenario_p.getKind() == ScenarioKind.FUNCTIONAL) {
            return true;
        }
        if (scenario_p.getKind() == ScenarioKind.INTERACTION) {
            for (InstanceRole role : scenario_p.getOwnedInstanceRoles()) {
                if (role.getRepresentedInstance() == null || !(role.getRepresentedInstance() instanceof AbstractFunction)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActorTransitionAvailable(EObject object) {
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractActor || object instanceof Part && ((Part)object).getAbstractType() != null && ((Part)object).getAbstractType() instanceof AbstractActor || object instanceof ActorPkg || object instanceof LogicalActorPkg || object instanceof ComponentExchange && ComponentExchangeExt.isLinkToAnActor((ComponentExchange)((ComponentExchange)object)));
    }

    public boolean isSystemTransitionAvailable(EObject object) {
        return false;
    }

    public boolean isLC2PCTransitionAvailable(EObject object) {
        return object instanceof LogicalArchitecture || object instanceof CapellaElement && CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) && (object instanceof LogicalComponent && !(object instanceof ComponentContext) || object instanceof LogicalComponentPkg || object instanceof Part && ((Part)object).getAbstractType() != null && ((Part)object).getAbstractType() instanceof LogicalComponent || object instanceof ComponentExchange && ComponentExchangeExt.isNotLinkToAnActor((ComponentExchange)((ComponentExchange)object)));
    }

    public boolean isOE2ActorTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof Entity || object instanceof EntityPkg || object instanceof CommunicationMean);
    }

    public boolean isOE2SystemTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof Entity && !(object instanceof OperationalActor) || object instanceof EntityPkg || object instanceof CommunicationMean);
    }

    public boolean isOA2SCTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof OperationalActivity || object instanceof OperationalActivityPkg);
    }

    public boolean isOA2SMTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof OperationalActivity || object instanceof OperationalActivityPkg);
    }

    public boolean isCapabilityTransitionAvailable(EObject object) {
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof OperationalAnalysis || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isOC2SMTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof OperationalCapability || object instanceof OperationalCapabilityPkg);
    }

    public boolean isES2ESTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.DATA_FLOW && (s.getKind() != ScenarioKind.INTERACTION || this.isFunctionalScenario(s))) continue;
                return false;
            }
            return scenario.getKind() == ScenarioKind.DATA_FLOW || scenario.getKind() == ScenarioKind.INTERACTION && !this.isFunctionalScenario(scenario);
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof OperationalAnalysis || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isES2ISTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && !architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.INTERFACE) continue;
                return false;
            }
            if (scenario.getKind() != ScenarioKind.DATA_FLOW) {
                return false;
            }
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof PhysicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg || object instanceof Scenario);
    }

    public boolean isESF2ESBTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && !architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.DATA_FLOW) continue;
                return false;
            }
            if (scenario.getKind() == ScenarioKind.DATA_FLOW) {
                for (SequenceMessage message : scenario.getOwnedMessages()) {
                    AbstractEventOperation operation = message.getInvokedOperation();
                    if (operation == null || operation instanceof FunctionalExchange) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof PhysicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg || object instanceof Scenario);
    }

    public boolean isFS2ESForOASATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element_p)) && this.isFS2ESTransitionAvailable(element_p);
    }

    public boolean isFS2ESForSALAPATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && (CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)element_p)) || CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)((CapellaElement)element_p)) || CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)((CapellaElement)element_p))) && this.isFS2ESTransitionAvailable(element_p);
    }

    public boolean isFS2ESTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario)) continue;
                Scenario s = (Scenario)src;
                BlockArchitecture architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
                if (architectureTarget != null && !architectureTarget.equals(architectureSource) || s.getKind() != ScenarioKind.DATA_FLOW && s.getKind() != ScenarioKind.INTERACTION) continue;
                return false;
            }
            return this.isFunctionalScenario(scenario);
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof PhysicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isES2ESForOASATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element_p)) && this.isES2ESTransitionAvailable(element_p);
    }

    public boolean isES2ESForSALATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)element_p)) && this.isES2ESTransitionAvailable(element_p);
    }

    public boolean isES2ESForLAPATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)((CapellaElement)element_p)) && this.isES2ESTransitionAvailable(element_p);
    }

    public boolean isInterfaceGenerationAvailable(EObject object) {
        PhysicalComponent pc;
        Component comp;
        if (object != null && (comp = this.getComponent(object)) != null && comp instanceof PhysicalComponent && (pc = (PhysicalComponent)comp).getNature() == PhysicalComponentNature.NODE) {
            return false;
        }
        return object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof Component && !(object instanceof ComponentContext) || object instanceof Part && ((Part)object).getAbstractType() != null && ((Part)object).getAbstractType() instanceof Component);
    }

    private Component getComponent(EObject object_p) {
        if (object_p != null) {
            Part part;
            AbstractType abstractType;
            if (object_p instanceof Component) {
                return (Component)object_p;
            }
            if (object_p instanceof Part && (abstractType = (part = (Part)object_p).getAbstractType()) != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        }
        return null;
    }

    public boolean isComponentExchangesGenerationAvailable(EObject object) {
        EObject component = object;
        if (!(component instanceof CapellaElement) || CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)component))) {
            return false;
        }
        if (object instanceof Part) {
            component = ((Part)object).getAbstractType();
        }
        if (component != null && component instanceof Component && !(object instanceof ComponentContext)) {
            if (component instanceof PhysicalComponent) {
                return ((AbstractPhysicalComponent)component).getNature() != PhysicalComponentNature.NODE;
            }
            return !(component instanceof PhysicalActor) && !(component instanceof ConfigurationItem);
        }
        return false;
    }

    public boolean isCommunicationMeansGenerationAvailable(EObject object) {
        EObject component = object;
        if (!(component instanceof CapellaElement) || !CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)component))) {
            return false;
        }
        if (object instanceof Part) {
            component = ((Part)object).getAbstractType();
        }
        if (component != null && component instanceof Component && !(object instanceof ComponentContext)) {
            if (component instanceof PhysicalComponent) {
                return ((AbstractPhysicalComponent)component).getNature() != PhysicalComponentNature.NODE;
            }
            return !(component instanceof PhysicalActor) && !(component instanceof ConfigurationItem);
        }
        return false;
    }

    public boolean isPhysicalLinksGenerationAvailable(EObject object) {
        EObject component = object;
        if (object instanceof Part) {
            component = ((Part)object).getAbstractType();
        }
        if (component != null && component instanceof Component && !(object instanceof ComponentContext)) {
            if (component instanceof PhysicalComponent) {
                return ((AbstractPhysicalComponent)component).getNature() != PhysicalComponentNature.BEHAVIOR;
            }
            if (this.canHavePhysicalPort(component)) {
                return true;
            }
            return component instanceof AbstractPhysicalComponent && !(component instanceof PhysicalActor);
        }
        return false;
    }

    public boolean canHavePhysicalPort(EObject source_p) {
        return source_p instanceof AbstractPhysicalComponent || source_p instanceof AbstractActor || source_p instanceof System || source_p instanceof Component && this.isLogicalSystemComponent(source_p);
    }

    private boolean isLogicalSystemComponent(EObject source_p) {
        return source_p.eContainer() != null && source_p.eContainer() instanceof LogicalArchitecture;
    }

    public boolean isPhysicalLinksComponentExchangesGenerationAvailable(EObject object) {
        EObject component = object;
        if (object instanceof Part) {
            component = ((Part)object).getAbstractType();
        }
        if (component != null && component instanceof Component && !(object instanceof ComponentContext)) {
            return component instanceof PhysicalActor;
        }
        return false;
    }

    public boolean isFS2FSTransitionAvailable(EObject object) {
        if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            BlockArchitecture architectureSource = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            for (AbstractTrace trace : scenario.getIncomingTraces()) {
                Scenario s;
                BlockArchitecture architectureTarget;
                TraceableElement src = trace.getSourceElement();
                if (!(src instanceof Scenario) || (architectureTarget = BlockArchitectureExt.getRootBlockArchitecture((EObject)(s = (Scenario)src))) != null && architectureTarget.equals(architectureSource) || !this.isFunctionalScenario(s)) continue;
                return false;
            }
            return this.isFunctionalScenario(scenario);
        }
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof OperationalAnalysis || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isFS2FSForOASATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element_p)) && this.isFS2FSTransitionAvailable(element_p);
    }

    public boolean isFS2FSForSALATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)((CapellaElement)element_p)) && this.isFS2FSTransitionAvailable(element_p);
    }

    public boolean isFS2FSForLAPATransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)((CapellaElement)element_p)) && this.isFS2FSTransitionAvailable(element_p);
    }

    public boolean isPropertyValueTransitionAvailable(EObject element_p) {
        return element_p instanceof CapellaElement && (element_p instanceof PropertyValueGroup || element_p instanceof PropertyValuePkg || element_p instanceof AbstractPropertyValue || element_p instanceof EnumerationPropertyType) && EcoreUtil2.isContainedBy((EObject)element_p, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE) && !CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)((CapellaElement)element_p));
    }
}

