/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.handlers.attachment;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.attachment.IAttachmentHandler;
import org.polarsys.capella.core.projection.common.handlers.log.LogHelper;
import org.polarsys.capella.core.projection.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.Messages;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public class DefaultAttachmentHandler
implements IAttachmentHandler {
    @Override
    public boolean isApplicable(EClass clazz, EStructuralFeature feature) {
        return EcoreUtil2.isEqualOrSuperClass((EClass)feature.getEContainingClass(), (EClass)clazz);
    }

    @Override
    public boolean attachElementByRel(EObject element, EObject relatedElement, EReference relationship) {
        if (!this.isApplicable(element.eClass(), (EStructuralFeature)relationship)) {
            LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_FeatureNonApplicable, (Object[])new Object[]{relationship.getName(), ((EClass)relationship.eContainer()).getName(), element.eClass().getName()}), ProjectionMessages.Activity_Transformation);
        } else if (!relationship.isChangeable() || relationship.isDerived()) {
            LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_FeatureDerivedOrNonChangeable, (Object)relationship.getName(), (Object)((EClass)relationship.eContainer()).getName()), ProjectionMessages.Activity_Transformation);
        } else {
            boolean done = false;
            boolean alreadyExist = false;
            try {
                if (relationship.isContainment()) {
                    HoldingResourceHelper.ensureMoveElement((EObject)relatedElement, (EObject)element);
                }
                if (relationship.isMany()) {
                    EList tmp = (EList)element.eGet((EStructuralFeature)relationship);
                    if (tmp.contains((Object)relatedElement)) {
                        alreadyExist = true;
                    } else {
                        tmp.add((Object)relatedElement);
                        done = true;
                    }
                } else if (relatedElement.equals(element.eGet((EStructuralFeature)relationship))) {
                    alreadyExist = true;
                } else {
                    element.eSet((EStructuralFeature)relationship, (Object)relatedElement);
                    done = true;
                }
            }
            catch (ArrayStoreException | IllegalArgumentException exception) {
                done = false;
            }
            if (done) {
                if (relationship.isContainment()) {
                    LogHelper.getInstance().info(NLS.bind((String)Messages.TigerRelationshipHelper_ContainedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement), EObjectLabelProviderHelper.getText((EObject)element), relationship.getName()}), new Object[]{relatedElement, element}, "");
                } else {
                    LogHelper.getInstance().info(NLS.bind((String)Messages.TigerRelationshipHelper_ReferencedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement), EObjectLabelProviderHelper.getText((EObject)element), relationship.getName()}), new Object[]{relatedElement, element}, "");
                }
            } else if (!alreadyExist) {
                if (relationship.isContainment()) {
                    LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_ShouldBeContainedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement), EObjectLabelProviderHelper.getText((EObject)element), relationship.getName()}), new Object[]{relatedElement, element}, "");
                } else {
                    LogHelper.getInstance().warn(NLS.bind((String)Messages.TigerRelationshipHelper_ShouldBeReferencedBy, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)relatedElement), EObjectLabelProviderHelper.getText((EObject)element), relationship.getName()}), new Object[]{relatedElement, element}, "");
                }
            }
        }
        return false;
    }

    @Override
    public void updateElementAttribute(EObject sourceElement, EObject targetElement, EAttribute feature, IContext context) {
        EAttribute attribute = feature;
        if (this.isApplicable(sourceElement.eClass(), (EStructuralFeature)attribute)) {
            Object valueTarget;
            Object valueSource = sourceElement.eGet((EStructuralFeature)attribute);
            if (this.isApplicable(targetElement.eClass(), (EStructuralFeature)attribute) && this.shouldUpdateAttribute(sourceElement, targetElement, feature, valueSource, valueTarget = targetElement.eGet((EStructuralFeature)attribute), context)) {
                if (valueTarget != null) {
                    LogHelper.getInstance().debug(NLS.bind((String)Messages.TigerRelationshipHelper_UpdateAttribute, (Object[])new Object[]{attribute.getName(), LogHelper.getInstance().getText(targetElement), LogHelper.getInstance().getText(valueTarget), LogHelper.getInstance().getText(valueSource)}), targetElement, ProjectionMessages.Activity_Transformation);
                }
                targetElement.eSet((EStructuralFeature)attribute, valueSource);
            }
        }
    }

    protected Collection<EObject> retrieveReferenceAsList(EObject object, EReference reference) {
        if (this.isApplicable(object.eClass(), (EStructuralFeature)reference)) {
            Object sourceReference = object.eGet((EStructuralFeature)reference);
            if (sourceReference instanceof Collection) {
                return (Collection)sourceReference;
            }
            return Collections.singleton((EObject)sourceReference);
        }
        return Collections.emptyList();
    }

    @Override
    public void attachTracedElements(EObject source, EObject target, EReference feature, IContext context) {
        for (EObject traced : this.retrieveReferenceAsList(source, feature)) {
            for (EObject related : TraceabilityHandlerHelper.getInstance(context).retrieveTracedElements(traced, context)) {
                this.attachElementByRel(target, related, feature);
            }
        }
    }

    @Override
    public void attachToBestElement(EObject element, EObject result, EReference reference, IContext context) {
        TigerRelationshipHelper.attachToBestElement((EObject)element, (EReference)reference, (ITransfo)context.getTransfo());
    }

    protected boolean shouldUpdateAttribute(EObject sourceElement, EObject targetElement, EAttribute feature, Object valueSource, Object valueTarget, IContext context) {
        return valueSource == null && valueTarget != null || valueSource != null && !valueSource.equals(valueTarget);
    }

    @Override
    public void init(IContext context) {
    }

    @Override
    public void dispose(IContext context) {
    }
}

