/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.massactions.core.shared.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;

public class SemanticBrowserHelper {
    private SemanticBrowserHelper() {
    }

    public static Set<ICategory> getObjectCategories(EObject rowObject) {
        Set referencedCategories = CategoryRegistry.getInstance().gatherCategories("ReferencedElementBrowser", rowObject);
        Set referencingCategories = CategoryRegistry.getInstance().gatherCategories("ReferencingElementBrowser", rowObject);
        Set currentCategories = CategoryRegistry.getInstance().gatherCategories("CurrentElementBrowser", rowObject);
        HashSet<ICategory> categories = new HashSet<ICategory>();
        categories.addAll(referencedCategories);
        categories.addAll(referencingCategories);
        categories.addAll(currentCategories);
        return categories;
    }

    public static Set<ICategory> getCommonObjectCategories(Collection<EObject> data) {
        if (data.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<EObject> rowObjects = new ArrayList<EObject>(data);
        EObject initialRowObject = (EObject)rowObjects.get(0);
        Set<ICategory> commonCategories = SemanticBrowserHelper.getObjectCategories(initialRowObject);
        int i = 1;
        while (i < rowObjects.size()) {
            EObject nextRowObject = (EObject)rowObjects.get(i);
            Set<ICategory> nextCategories = SemanticBrowserHelper.getObjectCategories(nextRowObject);
            commonCategories.retainAll(nextCategories);
            ++i;
        }
        return commonCategories;
    }
}

