/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class EIAllocationModelHelpers {
    public static List<ModelElement> getTransitionedElements(ModelElement element) {
        return EIAllocationModelHelpers.getTransitionedElements(Collections.singletonList(element));
    }

    public static List<ModelElement> getTransitionedElements(List<ModelElement> elements) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        for (ModelElement elt : elements) {
            if (elt instanceof AbstractFunction) {
                for (AbstractTrace trace : ((AbstractFunction)elt).getIncomingTraces()) {
                    AbstractFunction fct;
                    if (!(trace instanceof FunctionRealization) || (fct = ((FunctionRealization)trace).getAllocatingFunction()) == null) continue;
                    result.add((ModelElement)fct);
                }
                continue;
            }
            if (!(elt instanceof FunctionPort)) continue;
            for (AbstractTrace trace : ((FunctionPort)elt).getIncomingTraces()) {
                Port port;
                if (!(trace instanceof PortRealization) || (port = ((PortRealization)trace).getRealizingPort()) == null) continue;
                result.add((ModelElement)port);
            }
        }
        return result;
    }

    public static List<ModelElement> getTransitionerElements(ModelElement element) {
        return EIAllocationModelHelpers.getTransitionerElements(Collections.singletonList(element));
    }

    public static List<ModelElement> getTransitionerElements(List<ModelElement> elements) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        for (ModelElement elt : elements) {
            if (elt instanceof AbstractFunction) {
                for (AbstractTrace trace : ((AbstractFunction)elt).getOutgoingTraces()) {
                    AbstractFunction fct;
                    if (!(trace instanceof FunctionRealization) || (fct = ((FunctionRealization)trace).getAllocatedFunction()) == null) continue;
                    result.add((ModelElement)fct);
                }
                continue;
            }
            if (!(elt instanceof FunctionPort)) continue;
            for (AbstractTrace trace : ((FunctionPort)elt).getOutgoingTraces()) {
                Port port;
                if (!(trace instanceof PortRealization) || (port = ((PortRealization)trace).getRealizedPort()) == null) continue;
                result.add((ModelElement)port);
            }
        }
        return result;
    }

    public static List<EObject> getOwners(ExchangeItem exchangeItem) {
        return EObjectExt.getReferencers((EObject)exchangeItem, Arrays.asList(FaPackage.Literals.FUNCTION_INPUT_PORT__INCOMING_EXCHANGE_ITEMS, FaPackage.Literals.FUNCTION_OUTPUT_PORT__OUTGOING_EXCHANGE_ITEMS));
    }

    public static void handleDeletion(Collection<?> selection) {
        Collection<EObject> elts = EIAllocationModelHelpers.filterFunctionsAndPorts(selection);
        CapellaDeleteCommand cmd = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(elts), elts, false, false, false);
        if (cmd.canExecute()) {
            cmd.execute();
        }
    }

    public static Collection<EObject> filterFunctionsAndPorts(Collection<?> selection) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (Object obj : selection) {
            if (!(obj instanceof AbstractFunction) && !(obj instanceof FunctionPort)) continue;
            result.add((EObject)obj);
        }
        return result;
    }

    public static void handleAllocation(FunctionPort sepFunctionPort, FunctionPort tepFunctionPort, ExchangeItem exchangeItem) {
        if (tepFunctionPort != null && exchangeItem != null) {
            EList outgoingEI;
            if (tepFunctionPort instanceof FunctionInputPort) {
                EList incomingEI = ((FunctionInputPort)tepFunctionPort).getIncomingExchangeItems();
                if (!incomingEI.contains(exchangeItem)) {
                    incomingEI.add(exchangeItem);
                }
            } else if (tepFunctionPort instanceof FunctionOutputPort && !(outgoingEI = ((FunctionOutputPort)tepFunctionPort).getOutgoingExchangeItems()).contains(exchangeItem)) {
                outgoingEI.add(exchangeItem);
            }
            EIAllocationModelHelpers.handleAllocation(tepFunctionPort, sepFunctionPort);
        }
    }

    public static void handleAllocation(AbstractFunction source, AbstractFunction target) {
        boolean alreadyRealized = false;
        for (FunctionRealization rlz : source.getOutFunctionRealizations()) {
            AbstractFunction fct = rlz.getAllocatedFunction();
            if (!target.equals(fct)) continue;
            alreadyRealized = true;
            break;
        }
        if (!alreadyRealized) {
            FunctionRealization rlz;
            rlz = FaFactory.eINSTANCE.createFunctionRealization();
            rlz.setSourceElement((TraceableElement)source);
            rlz.setTargetElement((TraceableElement)target);
            source.getOwnedFunctionRealizations().add((Object)rlz);
        }
    }

    public static void handleAllocation(FunctionPort source, FunctionPort target) {
        boolean alreadyRealized = false;
        if (source instanceof FunctionInputPort && target instanceof FunctionInputPort || source instanceof FunctionOutputPort && target instanceof FunctionOutputPort) {
            for (PortRealization rlz : source.getOutgoingPortRealizations()) {
                Port port = rlz.getRealizedPort();
                if (!target.equals(port)) continue;
                alreadyRealized = true;
                break;
            }
            if (!alreadyRealized) {
                PortRealization rlz;
                rlz = InformationFactory.eINSTANCE.createPortRealization();
                rlz.setSourceElement((TraceableElement)source);
                rlz.setTargetElement((TraceableElement)target);
                source.getOwnedPortRealizations().add((Object)rlz);
            }
        }
    }

    public static boolean isSameType(List<EObject> elements) {
        if (elements != null && !elements.isEmpty()) {
            EClass cls = elements.get(0).eClass();
            for (EObject elt : elements) {
                if (elt.eClass().equals(cls)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSupportedType(Object element) {
        return !(element instanceof ExchangeItem);
    }

    public static boolean isCompatibleType(Object element1, Object element2) {
        if (element1 instanceof AbstractFunction && element2 instanceof AbstractFunction) {
            return true;
        }
        if (element1 instanceof FunctionPort && element2 instanceof FunctionPort) {
            return EIAllocationModelHelpers.isSamePortType((FunctionPort)element1, (FunctionPort)element2);
        }
        return false;
    }

    private static boolean isSamePortType(FunctionPort element1, FunctionPort element2) {
        return element1 instanceof FunctionInputPort && element2 instanceof FunctionInputPort || element1 instanceof FunctionOutputPort && element2 instanceof FunctionOutputPort;
    }

    public static boolean isValidTypeForDeletion(List<EObject> elements) {
        if (elements != null && !elements.isEmpty()) {
            for (EObject elt : elements) {
                if (elt instanceof AbstractFunction || elt instanceof FunctionPort) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isDelegated(ExchangeItem exchangeItem, FunctionPort port) {
        boolean isDelegated = false;
        for (PortRealization rlz : port.getIncomingPortRealizations()) {
            Port srcPort = rlz.getRealizingPort();
            if (srcPort instanceof FunctionInputPort && ((FunctionInputPort)srcPort).getIncomingExchangeItems().contains((Object)exchangeItem)) {
                isDelegated = true;
                continue;
            }
            if (!(srcPort instanceof FunctionOutputPort) || !((FunctionOutputPort)srcPort).getOutgoingExchangeItems().contains((Object)exchangeItem)) continue;
            isDelegated = true;
        }
        return isDelegated;
    }

    public static boolean isDelegator(ExchangeItem exchangeItem, FunctionPort port) {
        boolean isDelegated = false;
        for (PortRealization rlz : port.getOutgoingPortRealizations()) {
            Port dstPort = rlz.getRealizedPort();
            if (dstPort instanceof FunctionInputPort && ((FunctionInputPort)dstPort).getIncomingExchangeItems().contains((Object)exchangeItem)) {
                isDelegated = true;
                continue;
            }
            if (!(dstPort instanceof FunctionOutputPort) || !((FunctionOutputPort)dstPort).getOutgoingExchangeItems().contains((Object)exchangeItem)) continue;
            isDelegated = true;
        }
        return isDelegated;
    }
}

