/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideSMStateMode;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideSMTransitions
extends ShowHideSMStateMode {
    public ShowHideSMTransitions(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof StateTransition) {
            StateTransition trans = (StateTransition)lastContext.getValue();
            AbstractState source = trans.getSource();
            AbstractState target = trans.getTarget();
            value.put("source", (EObject)source);
            value.put("target", (EObject)target);
        }
        return value;
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        if (originCouple_p.getValue() instanceof StateTransition) {
            return true;
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        if (semantic_p instanceof StateTransition) {
            mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingSMTransition(semantic_p, this.getContent().getDDiagram()));
        }
        return mapping;
    }

    @Override
    protected boolean isValidSemanticView(EObject semantic_p, DSemanticDecorator semanticView_p, AbstractShowHide.DiagramContext context_p) {
        return true;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        if (semantic_p instanceof StateTransition) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof StateTransition) {
            return true;
        }
        return super.mustHide(originCouple_p, context_p);
    }
}

